/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.config;

import com.uwyn.rife.config.Config;
import com.uwyn.rife.config.exceptions.DateFormatInitializationException;
import com.uwyn.rife.template.TemplateFactory;
import com.uwyn.rife.tools.Convert;
import com.uwyn.rife.tools.Localization;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class RifeConfig {

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Global {
        public static final String PARAM_TEMP_PATH = "TEMP_PATH";
        public static final String PARAM_APPLICATION_CLASSPATH = "APPLICATION_CLASSPATH";
        public static final String PARAM_JAVA_COMPILER_PATH = "JAVA_COMPILER_PATH";
        public static final String PARAM_JAVA_COMPILER_ARGS = "JAVA_COMPILER_ARGS";
        public static final String PARAM_JAVA_COMPILER_INTERNAL = "JAVA_COMPILER_INTERNAL";
        private static String sFallbackTempPath = System.getProperty("java.io.tmpdir");
        private static String sFallbackApplicationClassPath = "";
        private static final String DEFAULT_JAVA_COMPILER_PATH = "javac";
        private static final boolean DEFAULT_JAVA_COMPILER_INTERNAL = false;

        public static String getTempPath() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TEMP_PATH, sFallbackTempPath);
            }
            return sFallbackTempPath;
        }

        public static synchronized void setTempPath(String path) {
            if (path == null) {
                throw new IllegalArgumentException("path can't be null.");
            }
            if (0 == path.length()) {
                throw new IllegalArgumentException("path can't be empty.");
            }
            if (Config.hasRepInstance()) {
                Config.getRepInstance().setParameter(PARAM_TEMP_PATH, path);
            } else {
                sFallbackTempPath = path;
            }
        }

        public static String getApplicationClassPath() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_APPLICATION_CLASSPATH, sFallbackApplicationClassPath);
            }
            return sFallbackApplicationClassPath;
        }

        public static synchronized void setApplicationClassPath(String path) {
            if (path == null) {
                throw new IllegalArgumentException("path can't be null.");
            }
            if (0 == path.length()) {
                throw new IllegalArgumentException("path can't be empty.");
            }
            if (Config.hasRepInstance()) {
                Config.getRepInstance().setParameter(PARAM_APPLICATION_CLASSPATH, path);
            } else {
                sFallbackApplicationClassPath = path;
            }
        }

        public static String getJavaCompilerPath() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_JAVA_COMPILER_PATH, DEFAULT_JAVA_COMPILER_PATH);
            }
            return DEFAULT_JAVA_COMPILER_PATH;
        }

        public static boolean isJavaCompilerPathSet() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().hasParameter(PARAM_JAVA_COMPILER_PATH);
            }
            return false;
        }

        public static boolean getJavaCompilerInternal() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getBool(PARAM_JAVA_COMPILER_INTERNAL, false);
            }
            return false;
        }

        public static boolean areJavaCompilerArgsSet() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().hasList(PARAM_JAVA_COMPILER_ARGS);
            }
            return false;
        }

        public static Collection<String> getJavaCompilerArgs() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getStringItems(PARAM_JAVA_COMPILER_ARGS);
            }
            return null;
        }

        public static boolean isInternalJavaCompilerAvailable() {
            try {
                Class<?> klass = Class.forName("com.sun.tools.javac.Main");
                if (klass == null) {
                    return false;
                }
            }
            catch (ClassNotFoundException e) {
                return false;
            }
            return true;
        }
    }

    public static abstract class Authentication {
        public static final String PARAM_SESSION_DURATION = "SESSION_DURATION";
        public static final String PARAM_SESSION_PURGE_FREQUENCY = "SESSION_PURGE_FREQUENCY";
        public static final String PARAM_SESSION_PURGE_SCALE = "SESSION_PURGE_SCALE";
        public static final String PARAM_REMEMBER_DURATION = "REMEMBER_DURATION";
        public static final String PARAM_REMEMBER_PURGE_FREQUENCY = "REMEMBER_PURGE_FREQUENCY";
        public static final String PARAM_REMEMBER_PURGE_SCALE = "REMEMBER_PURGE_SCALE";
        public static final String PARAM_TABLE_ROLE = "TABLE_ROLE";
        public static final String PARAM_SEQUENCE_ROLE = "SEQUENCE_ROLE";
        public static final String PARAM_TABLE_USER = "TABLE_USER";
        public static final String PARAM_TABLE_ROLELINK = "TABLE_ROLELINK";
        public static final String PARAM_TABLE_AUTHENTICATION = "TABLE_AUTHENTICATION";
        public static final String PARAM_TABLE_REMEMBER = "TABLE_REMEMBER";
        public static final String PARAM_ROLE_NAME_MAXIMUM_LENGTH = "ROLE_NAME_MAXIMUM_LENGTH";
        public static final String PARAM_LOGIN_MAXIMUM_LENGTH = "LOGIN_NAME_MAXIMUM_LENGTH";
        public static final String PARAM_LOGIN_MINIMUM_LENGTH = "LOGIN_NAME_MINIMUM_LENGTH";
        public static final String PARAM_PASSWORD_MAXIMUM_LENGTH = "PASSWORD_MAXIMUM_LENGTH";
        public static final String PARAM_PASSWORD_MINIMUM_LENGTH = "PASSWORD_MINIMUM_LENGTH";
        private static final long DEFAULT_SESSION_DURATION = 1200000L;
        private static final int DEFAULT_SESSION_PURGE_FREQUENCY = 20;
        private static final int DEFAULT_SESSION_PURGE_SCALE = 1000;
        private static final long DEFAULT_REMEMBER_DURATION = 7776000000L;
        private static final int DEFAULT_REMEMBER_PURGE_FREQUENCY = 20;
        private static final int DEFAULT_REMEMBER_PURGE_SCALE = 1000;
        private static final int DEFAULT_ROLE_NAME_MAXIMUM_LENGTH = 20;
        private static final int DEFAULT_LOGIN_MAXIMUM_LENGTH = 20;
        private static final int DEFAULT_LOGIN_MINIMUM_LENGTH = 5;
        private static final int DEFAULT_PASSWORD_MAXIMUM_LENGTH = 100;
        private static final int DEFAULT_PASSWORD_MINIMUM_LENGTH = 5;
        private static final String DEFAULT_TABLE_ROLE = "AuthRole";
        private static final String DEFAULT_SEQUENCE_ROLE = "SEQ_AUTHROLE";
        private static final String DEFAULT_TABLE_USER = "AuthUser";
        private static final String DEFAULT_TABLE_ROLELINK = "AuthRoleLink";
        private static final String DEFAULT_TABLE_AUTHENTICATION = "Authentication";
        private static final String DEFAULT_TABLE_REMEMBER = "AuthRemember";

        public static int getPasswordMinimumLength() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_PASSWORD_MINIMUM_LENGTH, 5);
            }
            return 5;
        }

        public static int getPasswordMaximumLength() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_PASSWORD_MAXIMUM_LENGTH, 100);
            }
            return 100;
        }

        public static int getLoginMinimumLength() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_LOGIN_MINIMUM_LENGTH, 5);
            }
            return 5;
        }

        public static int getLoginMaximumLength() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_LOGIN_MAXIMUM_LENGTH, 20);
            }
            return 20;
        }

        public static int getRoleNameMaximumLength() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_ROLE_NAME_MAXIMUM_LENGTH, 20);
            }
            return 20;
        }

        public static long getSessionDuration() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getLong(PARAM_SESSION_DURATION, 1200000L);
            }
            return 1200000L;
        }

        public static int getSessionPurgeFrequency() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_SESSION_PURGE_FREQUENCY, 20);
            }
            return 20;
        }

        public static int getSessionPurgeScale() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_SESSION_PURGE_SCALE, 1000);
            }
            return 1000;
        }

        public static long getRememberDuration() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getLong(PARAM_REMEMBER_DURATION, 7776000000L);
            }
            return 7776000000L;
        }

        public static int getRememberPurgeFrequency() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_REMEMBER_PURGE_FREQUENCY, 20);
            }
            return 20;
        }

        public static int getRememberPurgeScale() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_REMEMBER_PURGE_SCALE, 1000);
            }
            return 1000;
        }

        public static String getTableRole() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_ROLE, DEFAULT_TABLE_ROLE);
            }
            return DEFAULT_TABLE_ROLE;
        }

        public static String getSequenceRole() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_SEQUENCE_ROLE, DEFAULT_SEQUENCE_ROLE);
            }
            return DEFAULT_SEQUENCE_ROLE;
        }

        public static String getTableUser() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_USER, DEFAULT_TABLE_USER);
            }
            return DEFAULT_TABLE_USER;
        }

        public static String getTableRoleLink() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_ROLELINK, DEFAULT_TABLE_ROLELINK);
            }
            return DEFAULT_TABLE_ROLELINK;
        }

        public static String getTableAuthentication() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_AUTHENTICATION, DEFAULT_TABLE_AUTHENTICATION);
            }
            return DEFAULT_TABLE_AUTHENTICATION;
        }

        public static String getTableRemember() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_REMEMBER, DEFAULT_TABLE_REMEMBER);
            }
            return DEFAULT_TABLE_REMEMBER;
        }
    }

    public static abstract class Axis {
        public static final String PARAM_AXIS_SERVERCONFIG_PATH = "AXIS_SERVERCONFIG_PATH";
        public static final String PARAM_AXIS_ATTACHMENT_PATH = "AXIS_ATTACHMENT_PATH";
        public static final String PARAM_AXIS_JWSCLASSES_PATH = "AXIS_JWSCLASSES_PATH";
        private static final String DEFAULT_SERVERCONFIG_PATH = "axis/rife-server.wsdd";
        private static String sServerconfigPath = "axis/rife-server.wsdd";

        public static String getServerconfigPath() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_AXIS_SERVERCONFIG_PATH, sServerconfigPath);
            }
            return sServerconfigPath;
        }

        public static synchronized void setServerconfigPath(String path) {
            if (path == null) {
                throw new IllegalArgumentException("path can't be null.");
            }
            if (0 == path.length()) {
                throw new IllegalArgumentException("path can't be empty.");
            }
            if (Config.hasRepInstance()) {
                Config.getRepInstance().setParameter(PARAM_AXIS_SERVERCONFIG_PATH, path);
            } else {
                sServerconfigPath = path;
            }
        }

        public static String getAttachmentPath(String elementId) {
            String attachment_path = null;
            if (Config.hasRepInstance()) {
                attachment_path = Config.getRepInstance().getString(PARAM_AXIS_ATTACHMENT_PATH);
            }
            if (attachment_path == null) {
                return Global.getTempPath() + File.separator + "axis" + File.separator + "attachments";
            }
            attachment_path = attachment_path + (elementId + File.separator);
            attachment_path = attachment_path + File.separator;
            return attachment_path;
        }

        public static String getJwsclassesPath(String elementId) {
            String attachment_path = null;
            if (Config.hasRepInstance()) {
                attachment_path = Config.getRepInstance().getString(PARAM_AXIS_JWSCLASSES_PATH);
            }
            if (attachment_path == null) {
                return Global.getTempPath() + File.separator + "axis" + File.separator + "jwsclasses";
            }
            attachment_path = attachment_path + (elementId + File.separator);
            attachment_path = attachment_path + File.separator;
            return attachment_path;
        }
    }

    public static abstract class Cmf {
        public static final String PARAM_SEQUENCE_CONTENTREPOSITORY = "SEQUENCE_CONTENTREPOSITORY";
        public static final String PARAM_SEQUENCE_CONTENTINFO = "SEQUENCE_CONTENTINFO";
        public static final String PARAM_TABLE_CONTENTREPOSITORY = "TABLE_CONTENTREPOSITORY";
        public static final String PARAM_TABLE_CONTENTINFO = "TABLE_CONTENTINFO";
        public static final String PARAM_TABLE_CONTENTATTRIBUTE = "TABLE_CONTENTATTRIBUTE";
        public static final String PARAM_TABLE_CONTENTPROPERTY = "TABLE_CONTENTPROPERTY";
        public static final String PARAM_TABLE_CONTENTSTOREIMAGE = "TABLE_CONTENTSTOREIMAGE";
        public static final String PARAM_TABLE_CONTENTSTORETEXT = "TABLE_CONTENTSTORETEXT";
        public static final String PARAM_TABLE_CONTENTSTORERAWINFO = "TABLE_CONTENTSTORERAWINFO";
        public static final String PARAM_TABLE_CONTENTSTORERAWCHUNK = "TABLE_CONTENTSTORERAWCHUNK";
        private static final String DEFAULT_SEQUENCE_CONTENTREPOSITORY = "SEQ_CONTENTREPOSITORY";
        private static final String DEFAULT_SEQUENCE_CONTENTINFO = "SEQ_CONTENTINFO";
        private static final String DEFAULT_TABLE_CONTENTREPOSITORY = "ContentRepository";
        private static final String DEFAULT_TABLE_CONTENTINFO = "ContentInfo";
        private static final String DEFAULT_TABLE_CONTENTATTRIBUTE = "ContentAttribute";
        private static final String DEFAULT_TABLE_CONTENTPROPERTY = "ContentProperty";
        private static final String DEFAULT_TABLE_CONTENTSTOREIMAGE = "ContentStoreImage";
        private static final String DEFAULT_TABLE_CONTENTSTORETEXT = "ContentStoreText";
        private static final String DEFAULT_TABLE_CONTENTSTORERAWINFO = "ContentStoreRawInfo";
        private static final String DEFAULT_TABLE_CONTENTSTORERAWCHUNK = "ContentStoreRawChunk";

        public static String getSequenceContentRepository() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_SEQUENCE_CONTENTREPOSITORY, DEFAULT_SEQUENCE_CONTENTREPOSITORY);
            }
            return DEFAULT_SEQUENCE_CONTENTREPOSITORY;
        }

        public static String getSequenceContentInfo() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_SEQUENCE_CONTENTINFO, DEFAULT_SEQUENCE_CONTENTINFO);
            }
            return DEFAULT_SEQUENCE_CONTENTINFO;
        }

        public static String getTableContentRepository() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_CONTENTREPOSITORY, DEFAULT_TABLE_CONTENTREPOSITORY);
            }
            return DEFAULT_TABLE_CONTENTREPOSITORY;
        }

        public static String getTableContentInfo() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_CONTENTINFO, DEFAULT_TABLE_CONTENTINFO);
            }
            return DEFAULT_TABLE_CONTENTINFO;
        }

        public static String getTableContentAttribute() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_CONTENTATTRIBUTE, DEFAULT_TABLE_CONTENTATTRIBUTE);
            }
            return DEFAULT_TABLE_CONTENTATTRIBUTE;
        }

        public static String getTableContentProperty() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_CONTENTPROPERTY, DEFAULT_TABLE_CONTENTPROPERTY);
            }
            return DEFAULT_TABLE_CONTENTPROPERTY;
        }

        public static String getTableContentStoreImage() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_CONTENTSTOREIMAGE, DEFAULT_TABLE_CONTENTSTOREIMAGE);
            }
            return DEFAULT_TABLE_CONTENTSTOREIMAGE;
        }

        public static String getTableContentStoreText() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_CONTENTSTORETEXT, DEFAULT_TABLE_CONTENTSTORETEXT);
            }
            return DEFAULT_TABLE_CONTENTSTORETEXT;
        }

        public static String getTableContentStoreRawInfo() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_CONTENTSTORERAWINFO, DEFAULT_TABLE_CONTENTSTORERAWINFO);
            }
            return DEFAULT_TABLE_CONTENTSTORERAWINFO;
        }

        public static String getTableContentStoreRawChunk() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_CONTENTSTORERAWCHUNK, DEFAULT_TABLE_CONTENTSTORERAWCHUNK);
            }
            return DEFAULT_TABLE_CONTENTSTORERAWCHUNK;
        }
    }

    public static abstract class Database {
        public static final String PARAM_TRANSACTION_TIMEOUT = "TRANSACTION_TIMEOUT";
        public static final String PARAM_SQL_DEBUG_TRACE = "SQL_DEBUG_TRACE";
        private static final int DEFAULT_TRANSACTION_TIMEOUT = 0;
        private static final boolean DEFAULT_SQL_DEBUG_TRACE = false;

        public static int getTransactionTimeout() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_TRANSACTION_TIMEOUT, 0);
            }
            return 0;
        }

        public static boolean getSqlDebugTrace() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getBool(PARAM_SQL_DEBUG_TRACE, false);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Engine {
        public static final String PARAM_DEFAULT_CONTENT_TYPE = "DEFAULT_CONTENT_TYPE";
        public static final String PARAM_ELEMENT_AUTO_RELOAD = "ELEMENT_AUTO_RELOAD";
        public static final String PARAM_ELEMENT_GENERATION_PATH = "ELEMENT_GENERATION_PATH";
        public static final String PARAM_ELEMENT_DEBUG_TRACE = "ELEMENT_DEBUG_TRACE";
        public static final String PARAM_ELEMENT_DEBUG_MEMORY = "ELEMENT_DEBUG_MEMORY";
        public static final String PARAM_LOG_ENGINE_EXCEPTIONS = "PRETTY_LOG_EXCEPTIONS";
        public static final String PARAM_PRETTY_ENGINE_EXCEPTIONS = "PRETTY_ENGINE_EXCEPTIONS";
        public static final String PARAM_FILEUPLOAD_PATH = "FILEUPLOAD_PATH";
        public static final String PARAM_FILEUPLOAD_SIZE_LIMIT = "FILEUPLOAD_SIZE_LIMIT";
        public static final String PARAM_FILEUPLOAD_SIZE_CHECK = "FILEUPLOAD_SIZE_CHECK";
        public static final String PARAM_FILEUPLOAD_SIZE_EXCEPTION = "FILEUPLOAD_SIZE_EXCEPTION";
        public static final String PARAM_SITE_AUTO_RELOAD = "SITE_AUTO_RELOAD";
        public static final String PARAM_CONTINUATION_DURATION = "CONTINUATION_DURATION";
        public static final String PARAM_CONTINUATION_PURGE_FREQUENCY = "CONTINUATION_PURGE_FREQUENCY";
        public static final String PARAM_CONTINUATION_PURGE_SCALE = "CONTINUATION_PURGE_SCALE";
        public static final String PARAM_GZIP_COMPRESSION = "GZIP_COMPRESSION";
        public static final String PARAM_GZIP_COMPRESSION_TYPES = "GZIP_COMPRESSION_TYPES";
        public static final String PARAM_LOCAL_FORWARD_PORT = "LOCAL_FORWARD_PORT";
        public static final String PARAM_PROXY_ROOTURL = "PROXY_ROOTURL";
        private static final String DEFAULT_DEFAULT_CONTENT_TYPE = "text/html";
        private static final boolean DEFAULT_ELEMENT_AUTO_RELOAD = true;
        private static final boolean DEFAULT_ELEMENT_DEBUG_TRACE = false;
        private static final boolean DEFAULT_ELEMENT_DEBUG_MEMORY = false;
        private static final boolean DEFAULT_LOG_ENGINE_EXCEPTIONS = true;
        private static final boolean DEFAULT_PRETTY_ENGINE_EXCEPTIONS = true;
        private static final int DEFAULT_FILEUPLOAD_SIZE_LIMIT = 0x200000;
        private static final boolean DEFAULT_FILEUPLOAD_SIZE_CHECK = true;
        private static final boolean DEFAULT_FILEUPLOAD_SIZE_EXCEPTION = false;
        private static final boolean DEFAULT_SITE_AUTO_RELOAD = true;
        private static final long DEFAULT_CONTINUATION_DURATION = 1200000L;
        private static final int DEFAULT_CONTINUATION_PURGE_FREQUENCY = 20;
        private static final int DEFAULT_CONTINUATION_PURGE_SCALE = 1000;
        private static final boolean DEFAULT_GZIP_COMPRESSION = false;
        private static final Collection<String> DEFAULT_GZIP_COMPRESSION_TYPES = new 6();
        private static final int DEFAULT_LOCAL_FORWARD_PORT = -1;
        private static final String DEFAULT_PROXY_ROOTURL = null;
        private static boolean sLogEngineExceptions = true;

        public static String getDefaultContentType() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_DEFAULT_CONTENT_TYPE, DEFAULT_DEFAULT_CONTENT_TYPE);
            }
            return DEFAULT_DEFAULT_CONTENT_TYPE;
        }

        public static boolean getElementAutoReload() {
            Object value = System.getProperties().get(PARAM_ELEMENT_AUTO_RELOAD);
            return Convert.toBoolean(value, true);
        }

        public static String getElementGenerationPath() {
            String generation_path = null;
            Object value = System.getProperties().get(PARAM_ELEMENT_GENERATION_PATH);
            if (value != null) {
                generation_path = value.toString();
            }
            if (generation_path == null) {
                return new StringBuffer().append(new StringBuffer().append(Global.getTempPath()).append(File.separator).toString()).append("rife_elements").toString();
            }
            generation_path = new StringBuffer().append(generation_path).append(File.separator).toString();
            return generation_path;
        }

        public static boolean getElementDebugTrace() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getBool(PARAM_ELEMENT_DEBUG_TRACE, false);
            }
            return false;
        }

        public static boolean getElementDebugMemory() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getBool(PARAM_ELEMENT_DEBUG_MEMORY, false);
            }
            return false;
        }

        public static boolean getPrettyEngineExceptions() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getBool(PARAM_PRETTY_ENGINE_EXCEPTIONS, true);
            }
            return true;
        }

        public static boolean getLogEngineExceptions() {
            if (Config.hasRepInstance() && Config.getRepInstance().hasParameter(PARAM_LOG_ENGINE_EXCEPTIONS)) {
                return Config.getRepInstance().getBool(PARAM_LOG_ENGINE_EXCEPTIONS, true);
            }
            return sLogEngineExceptions;
        }

        public static synchronized void setLogEngineExceptions(boolean generate) {
            if (Config.hasRepInstance()) {
                Config.getRepInstance().setParameter(PARAM_LOG_ENGINE_EXCEPTIONS, generate);
            } else {
                sLogEngineExceptions = generate;
            }
        }

        public static String getFileUploadPath() {
            String fileupload_path = null;
            if (Config.hasRepInstance() && (fileupload_path = Config.getRepInstance().getString(PARAM_FILEUPLOAD_PATH)) == null) {
                return new StringBuffer().append(new StringBuffer().append(Global.getTempPath()).append(File.separator).toString()).append("rife_uploads").toString();
            }
            fileupload_path = new StringBuffer().append(fileupload_path).append(File.separator).toString();
            return fileupload_path;
        }

        public static int getFileuploadSizeLimit() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_FILEUPLOAD_SIZE_LIMIT, 0x200000);
            }
            return 0x200000;
        }

        public static boolean getFileuploadSizeCheck() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getBool(PARAM_FILEUPLOAD_SIZE_CHECK, true);
            }
            return true;
        }

        public static boolean getFileUploadSizeException() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getBool(PARAM_FILEUPLOAD_SIZE_EXCEPTION, false);
            }
            return false;
        }

        public static boolean getSiteAutoReload() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getBool(PARAM_SITE_AUTO_RELOAD, true);
            }
            return true;
        }

        public static long getContinuationDuration() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getLong(PARAM_CONTINUATION_DURATION, 1200000L);
            }
            return 1200000L;
        }

        public static int getContinuationPurgeFrequency() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_CONTINUATION_PURGE_FREQUENCY, 20);
            }
            return 20;
        }

        public static int getContinuationPurgeScale() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_CONTINUATION_PURGE_SCALE, 1000);
            }
            return 1000;
        }

        public static boolean getGzipCompression() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getBool(PARAM_GZIP_COMPRESSION, false);
            }
            return false;
        }

        public static Collection<String> getGzipCompressionTypes() {
            if (Config.hasRepInstance()) {
                Collection<String> types = Config.getRepInstance().getStringItems(PARAM_GZIP_COMPRESSION_TYPES);
                if (types == null) {
                    return DEFAULT_GZIP_COMPRESSION_TYPES;
                }
                return types;
            }
            return DEFAULT_GZIP_COMPRESSION_TYPES;
        }

        public static int getLocalForwardPort() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_LOCAL_FORWARD_PORT, -1);
            }
            return -1;
        }

        public static String getProxyRootUrl() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_PROXY_ROOTURL, DEFAULT_PROXY_ROOTURL);
            }
            return DEFAULT_PROXY_ROOTURL;
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class 6
        extends ArrayList<String> {
            6() {
                this.block$34314();
            }

            private /* synthetic */ void block$34314() {
                this.add(Engine.DEFAULT_DEFAULT_CONTENT_TYPE);
                this.add("text/xml");
                this.add("text/plain");
                this.add("text/css");
                this.add("text/javascript");
                this.add("application/xml");
                this.add("application/xhtml+xml");
            }
        }
    }

    public static abstract class Mime {
        public static final String PARAM_MIME_MAPPING = "MIME_MAPPING";
        private static Map<String, String> DEFAULT_MIME_MAPPING = new 8();

        public static String getMimeType(String extension) {
            return DEFAULT_MIME_MAPPING.get(extension);
        }

        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class 8
        extends HashMap<String, String> {
            8() {
                this.block$55361();
            }

            private /* synthetic */ void block$55361() {
                this.put("ez", "application/andrew-inset");
                this.put("jnlp", "application/jnlp");
                this.put("hqx", "application/mac-binhex40");
                this.put("cpt", "application/mac-compactpro");
                this.put("mathml", "application/mathml+xml");
                this.put("bin", "application/octet-stream");
                this.put("dms", "application/octet-stream");
                this.put("lha", "application/octet-stream");
                this.put("lzh", "application/octet-stream");
                this.put("exe", "application/octet-stream");
                this.put("class", "application/octet-stream");
                this.put("so", "application/octet-stream");
                this.put("dll", "application/octet-stream");
                this.put("dmg", "application/octet-stream");
                this.put("oda", "application/oda");
                this.put("ogg", "application/ogg");
                this.put("pdf", "application/pdf");
                this.put("ai", "application/postscript");
                this.put("eps", "application/postscript");
                this.put("ps", "application/postscript");
                this.put("rdf", "application/rdf+xml");
                this.put("smi", "application/smil");
                this.put("smil", "application/smil");
                this.put("gram", "application/srgs");
                this.put("grxml", "application/srgs+xml");
                this.put("mif", "application/vnd.mif");
                this.put("xls", "application/vnd.ms-excel");
                this.put("ppt", "application/vnd.ms-powerpoint");
                this.put("rm", "application/vnd.rn-realmedia");
                this.put("bcpio", "application/x-bcpio");
                this.put("vcd", "application/x-cdlink");
                this.put("pgn", "application/x-chess-pgn");
                this.put("cpio", "application/x-cpio");
                this.put("csh", "application/x-csh");
                this.put("dcr", "application/x-director");
                this.put("dir", "application/x-director");
                this.put("dxr", "application/x-director");
                this.put("dvi", "application/x-dvi");
                this.put("spl", "application/x-futuresplash");
                this.put("gtar", "application/x-gtar");
                this.put("hdf", "application/x-hdf");
                this.put("js", "application/x-javascript");
                this.put("skp", "application/x-koan");
                this.put("skd", "application/x-koan");
                this.put("skt", "application/x-koan");
                this.put("skm", "application/x-koan");
                this.put("latex", "application/x-latex");
                this.put("nc", "application/x-netcdf");
                this.put("cdf", "application/x-netcdf");
                this.put("ogg", "application/x-ogg");
                this.put("sh", "application/x-sh");
                this.put("shar", "application/x-shar");
                this.put("swf", "application/x-shockwave-flash");
                this.put("sit", "application/x-stuffit");
                this.put("sv4cpio", "application/x-sv4cpio");
                this.put("sv4crc", "application/x-sv4crc");
                this.put("tar", "application/x-tar");
                this.put("tcl", "application/x-tcl");
                this.put("tex", "application/x-tex");
                this.put("texinfo", "application/x-texinfo");
                this.put("texi", "application/x-texinfo");
                this.put("t", "application/x-troff");
                this.put("tr", "application/x-troff");
                this.put("roff", "application/x-troff");
                this.put("man", "application/x-troff-man");
                this.put("me", "application/x-troff-me");
                this.put("ms", "application/x-troff-ms");
                this.put("ustar", "application/x-ustar");
                this.put("src", "application/x-wais-source");
                this.put("xhtml", "application/xhtml+xml");
                this.put("xht", "application/xhtml+xml");
                this.put("xslt", "application/xslt+xml");
                this.put("xml", "application/xml");
                this.put("xsl", "application/xml");
                this.put("dtd", "application/xml-dtd");
                this.put("zip", "application/zip");
                this.put("au", "audio/basic");
                this.put("snd", "audio/basic");
                this.put("mid", "audio/midi");
                this.put("midi", "audio/midi");
                this.put("kar", "audio/midi");
                this.put("mpga", "audio/mpeg");
                this.put("mp2", "audio/mpeg");
                this.put("mp3", "audio/mpeg");
                this.put("aif", "audio/x-aiff");
                this.put("aiff", "audio/x-aiff");
                this.put("aifc", "audio/x-aiff");
                this.put("m3u", "audio/x-mpegurl");
                this.put("ram", "audio/x-pn-realaudio");
                this.put("ra", "audio/x-pn-realaudio");
                this.put("wav", "audio/x-wav");
                this.put("pdb", "chemical/x-pdb");
                this.put("xyz", "chemical/x-xyz");
                this.put("bmp", "image/bmp");
                this.put("cgm", "image/cgm");
                this.put("gif", "image/gif");
                this.put("ief", "image/ief");
                this.put("jpeg", "image/jpeg");
                this.put("jpg", "image/jpeg");
                this.put("jpe", "image/jpeg");
                this.put("png", "image/png");
                this.put("svg", "image/svg+xml");
                this.put("tiff", "image/tiff");
                this.put("tif", "image/tiff");
                this.put("djvu", "image/vnd.djvu");
                this.put("djv", "image/vnd.djvu");
                this.put("wbmp", "image/vnd.wap.wbmp");
                this.put("ras", "image/x-cmu-raster");
                this.put("ico", "image/x-icon");
                this.put("pnm", "image/x-portable-anymap");
                this.put("pbm", "image/x-portable-bitmap");
                this.put("pgm", "image/x-portable-graymap");
                this.put("ppm", "image/x-portable-pixmap");
                this.put("rgb", "image/x-rgb");
                this.put("xbm", "image/x-xbitmap");
                this.put("xpm", "image/x-xpixmap");
                this.put("xwd", "image/x-xwindowdump");
                this.put("igs", "model/iges");
                this.put("iges", "model/iges");
                this.put("msh", "model/mesh");
                this.put("mesh", "model/mesh");
                this.put("silo", "model/mesh");
                this.put("wrl", "model/vrml");
                this.put("vrml", "model/vrml");
                this.put("ics", "text/calendar");
                this.put("ifb", "text/calendar");
                this.put("css", "text/css");
                this.put("html", "text/html");
                this.put("htm", "text/html");
                this.put("asc", "text/plain");
                this.put("txt", "text/plain");
                this.put("rtx", "text/richtext");
                this.put("rtf", "text/rtf");
                this.put("sgml", "text/sgml");
                this.put("sgm", "text/sgml");
                this.put("tsv", "text/tab-separated-values");
                this.put("wml", "text/vnd.wap.wml");
                this.put("wmls", "text/vnd.wap.wmlscript");
                this.put("etx", "text/x-setext");
                this.put("htc", "text/x-component");
                this.put("mpeg", "video/mpeg");
                this.put("mpg", "video/mpeg");
                this.put("mpe", "video/mpeg");
                this.put("qt", "video/quicktime");
                this.put("mov", "video/quicktime");
                this.put("mxu", "video/vnd.mpegurl");
                this.put("m4u", "video/vnd.mpegurl");
                this.put("avi", "video/x-msvideo");
                this.put("movie", "video/x-sgi-movie");
                this.put("ice", "x-conference/x-cooltalk");
            }
        }
    }

    public static abstract class Resources {
        public static final String PARAM_TABLE_RESOURCES = "TABLE_RESOURCES";
        private static final String DEFAULT_TABLE_TASK = "Resources";

        public static String getTableResources() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_RESOURCES, DEFAULT_TABLE_TASK);
            }
            return DEFAULT_TABLE_TASK;
        }
    }

    public static abstract class Scheduler {
        public static final String PARAM_TABLE_TASK = "TABLE_TASK";
        public static final String PARAM_SEQUENCE_TASK = "SEQUENCE_TASK";
        public static final String PARAM_TABLE_TASKOPTION = "TABLE_TASKOPTION";
        public static final String PARAM_TASKOPTION_NAME_MAXIMUM_LENGTH = "TASKOPTION_NAME_MAXIMUM_LENGTH";
        public static final String PARAM_TASKOPTION_VALUE_MAXIMUM_LENGTH = "TASKOPTION_VALUE_MAXIMUM_LENGTH";
        public static final String PARAM_TASK_TYPE_MAXIMUM_LENGTH = "TASK_TYPE_MAXIMUM_LENGTH";
        public static final String PARAM_TASK_FREQUENCY_MAXIMUM_LENGTH = "TASK_FREQUENCY_MAXIMUM_LENGTH";
        private static final String DEFAULT_TABLE_TASK = "SchedTask";
        private static final String DEFAULT_SEQUENCE_TASK = "SEQ_SCHEDTASK";
        private static final String DEFAULT_TABLE_TASKOPTION = "SchedTaskoption";
        private static final int DEFAULT_TASKOPTION_NAME_MAXIMUM_LENGTH = 255;
        private static final int DEFAULT_TASKOPTION_VALUE_MAXIMUM_LENGTH = 255;
        private static final int DEFAULT_TASK_TYPE_MAXIMUM_LENGTH = 255;
        private static final int DEFAULT_TASK_FREQUENCY_MAXIMUM_LENGTH = 255;

        public static int getTaskTypeMaximumLength() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_TASK_TYPE_MAXIMUM_LENGTH, 255);
            }
            return 255;
        }

        public static int getTaskFrequencyMaximumLength() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_TASK_FREQUENCY_MAXIMUM_LENGTH, 255);
            }
            return 255;
        }

        public static int getTaskoptionValueMaximumLength() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_TASKOPTION_VALUE_MAXIMUM_LENGTH, 255);
            }
            return 255;
        }

        public static int getTaskoptionNameMaximumLength() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_TASKOPTION_NAME_MAXIMUM_LENGTH, 255);
            }
            return 255;
        }

        public static String getTableTask() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_TASK, DEFAULT_TABLE_TASK);
            }
            return DEFAULT_TABLE_TASK;
        }

        public static String getSequenceTask() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_SEQUENCE_TASK, DEFAULT_SEQUENCE_TASK);
            }
            return DEFAULT_SEQUENCE_TASK;
        }

        public static String getTableTaskoption() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TABLE_TASKOPTION, DEFAULT_TABLE_TASKOPTION);
            }
            return DEFAULT_TABLE_TASKOPTION;
        }
    }

    public static abstract class Swing {
        public static final String PARAM_ICON_CONFIRM_PATH = "ICON_CONFIRM_PATH";
        public static final String PARAM_ICON_ERROR_PATH = "ICON_ERROR_PATH";
        public static final String PARAM_ICON_INFO_PATH = "ICON_INFO_PATH";
        private static final String DEFAULT_ICON_CONFIRM_PATH = "icons/confirm.gif";
        private static final String DEFAULT_ICON_ERROR_PATH = "icons/error.gif";
        private static final String DEFAULT_ICON_INFO_PATH = "icons/info.gif";

        public static String getIconConfirmPath() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_ICON_CONFIRM_PATH, DEFAULT_ICON_CONFIRM_PATH);
            }
            return DEFAULT_ICON_CONFIRM_PATH;
        }

        public static String getIconErrorPath() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_ICON_ERROR_PATH, DEFAULT_ICON_ERROR_PATH);
            }
            return DEFAULT_ICON_ERROR_PATH;
        }

        public static String getIconInfoPath() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_ICON_INFO_PATH, DEFAULT_ICON_INFO_PATH);
            }
            return DEFAULT_ICON_INFO_PATH;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Template {
        public static final String PARAM_TEMPLATE_AUTO_RELOAD = "TEMPLATE_AUTO_RELOAD";
        public static final String PARAM_TEMPLATE_GENERATION_PATH = "TEMPLATE_GENERATION_PATH";
        public static final String PARAM_TEMPLATE_GENERATE_CLASSES = "TEMPLATE_GENERATE_CLASSES";
        public static final String PARAM_TEMPLATE_DEFAULT_ENCODING = "TEMPLATE_DEFAULT_ENCODING";
        public static final String PREFIX_TEMPLATE_DEFAULT_RESOURCEBUNDLES = "TEMPLATE_DEFAULT_RESOURCEBUNDLES_";
        private static String sGenerationPath = null;
        private static String sDefaultEncoding = null;
        private static HashMap<String, Collection<String>> sDefaultResourcebundles = null;
        private static boolean sGenerateClasses = false;
        private static final boolean DEFAULT_TEMPLATE_AUTO_RELOAD = true;

        public static boolean getAutoReload() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getBool(PARAM_TEMPLATE_AUTO_RELOAD, true);
            }
            return true;
        }

        public static String getGenerationPath() {
            String generation_path = null;
            if (Config.hasRepInstance()) {
                generation_path = Config.getRepInstance().getString(PARAM_TEMPLATE_GENERATION_PATH, sGenerationPath);
            }
            if (generation_path == null) {
                generation_path = sGenerationPath;
            }
            if (generation_path == null) {
                return new StringBuffer().append(new StringBuffer().append(Global.getTempPath()).append(File.separator).toString()).append("rife_templates").toString();
            }
            generation_path = new StringBuffer().append(generation_path).append(File.separator).toString();
            return generation_path;
        }

        public static synchronized void setGenerationPath(String path) {
            if (path == null) {
                throw new IllegalArgumentException("path can't be null.");
            }
            if (0 == path.length()) {
                throw new IllegalArgumentException("path can't be empty.");
            }
            if (Config.hasRepInstance()) {
                Config.getRepInstance().setParameter(PARAM_TEMPLATE_GENERATION_PATH, path);
            } else {
                sGenerationPath = path;
            }
        }

        public static boolean getGenerateClasses() {
            if (Config.hasRepInstance() && Config.getRepInstance().hasParameter(PARAM_TEMPLATE_GENERATE_CLASSES)) {
                return Config.getRepInstance().getBool(PARAM_TEMPLATE_GENERATE_CLASSES, sGenerateClasses);
            }
            return sGenerateClasses;
        }

        public static synchronized void setGenerateClasses(boolean generate) {
            if (Config.hasRepInstance()) {
                Config.getRepInstance().setParameter(PARAM_TEMPLATE_GENERATE_CLASSES, generate);
            } else {
                sGenerateClasses = generate;
            }
        }

        public static String getDefaultEncoding() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_TEMPLATE_DEFAULT_ENCODING, sDefaultEncoding);
            }
            return sDefaultEncoding;
        }

        public static synchronized void setDefaultEncoding(String encoding) {
            if (encoding == null) {
                throw new IllegalArgumentException("encoding can't be null.");
            }
            if (0 == encoding.length()) {
                throw new IllegalArgumentException("encoding can't be empty.");
            }
            if (Config.hasRepInstance()) {
                Config.getRepInstance().setParameter(PARAM_TEMPLATE_DEFAULT_ENCODING, encoding);
            } else {
                sDefaultEncoding = encoding;
            }
        }

        public static Collection<String> getDefaultResourcebundles(TemplateFactory factory) {
            Collection<String> result = null;
            if (Config.hasRepInstance()) {
                result = Config.getRepInstance().getStringItems(new StringBuffer().append(PREFIX_TEMPLATE_DEFAULT_RESOURCEBUNDLES).append(factory.getIdentifierUppercase()).toString());
            }
            if (result == null && sDefaultResourcebundles != null) {
                result = sDefaultResourcebundles.get(factory.getIdentifierUppercase());
            }
            return result;
        }

        public static synchronized void setDefaultResourcebundles(TemplateFactory factory, Collection<String> bundles) {
            if (Config.hasRepInstance()) {
                String param = new StringBuffer().append(PREFIX_TEMPLATE_DEFAULT_RESOURCEBUNDLES).append(factory.getIdentifierUppercase()).toString();
                Config.getRepInstance().removeList(param);
                if (bundles != null) {
                    for (String bundle : bundles) {
                        Config.getRepInstance().addListItem(param, bundle);
                    }
                }
            } else {
                if (sDefaultResourcebundles == null) {
                    sDefaultResourcebundles = new HashMap();
                }
                sDefaultResourcebundles.put(factory.getIdentifierUppercase(), bundles);
            }
        }
    }

    public static abstract class Tools {
        public static final String PARAM_L10N_RESOURCEBUNDLE_AUTO_RELOAD = "L10N_RESOURCEBUNDLE_AUTO_RELOAD";
        public static final String PARAM_L10N_DEFAULT_RESOURCEBUNDLE = "L10N_DEFAULT_RESOURCEBUNDLE";
        public static final String PARAM_L10N_DEFAULT_LANGUAGE = "L10N_DEFAULT_LANGUAGE";
        public static final String PARAM_L10N_DEFAULT_COUNTRY = "L10N_DEFAULT_COUNTRY";
        public static final String PARAM_L10N_DEFAULT_SHORT_DATEFORMAT = "L10N_DEFAULT_SHORT_DATEFORMAT";
        public static final String PARAM_L10N_DEFAULT_LONG_DATEFORMAT = "L10N_DEFAULT_LONG_DATEFORMAT";
        public static final String PARAM_MAX_VISUAL_URL_LENGTH = "MAX_VISUAL_URL_LENGTH";
        private static final String DEFAULT_LANGUAGE = "en";
        private static final int DEFAULT_MAX_VISUAL_URL_LENGTH = 70;
        private static final boolean DEFAULT_RESOURCEBUNDLE_AUTO_RELOAD = true;
        private static String sDefaultResourcebundle = null;
        private static String sDefaultLanguage = "en";
        private static String sDefaultCountry = null;

        public static boolean getResourcebundleAutoReload() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getBool(PARAM_L10N_RESOURCEBUNDLE_AUTO_RELOAD, true);
            }
            return true;
        }

        public static String getDefaultResourceBundle() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_L10N_DEFAULT_RESOURCEBUNDLE, sDefaultResourcebundle);
            }
            return sDefaultResourcebundle;
        }

        public static synchronized void setDefaultResourceBundle(String name) {
            if (name != null && 0 == name.length()) {
                throw new IllegalArgumentException("name can't be empty.");
            }
            if (Config.hasRepInstance()) {
                if (name == null) {
                    Config.getRepInstance().removeParameter(PARAM_L10N_DEFAULT_RESOURCEBUNDLE);
                } else {
                    Config.getRepInstance().setParameter(PARAM_L10N_DEFAULT_RESOURCEBUNDLE, name);
                }
            } else {
                sDefaultResourcebundle = name;
            }
        }

        public static String getDefaultLanguage() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_L10N_DEFAULT_LANGUAGE, sDefaultLanguage);
            }
            return sDefaultLanguage;
        }

        public static synchronized void setDefaultLanguage(String abbreviation) {
            if (abbreviation != null && 0 == abbreviation.length()) {
                throw new IllegalArgumentException("abbreviation can't be empty.");
            }
            if (Config.hasRepInstance()) {
                if (abbreviation == null) {
                    Config.getRepInstance().removeParameter(PARAM_L10N_DEFAULT_LANGUAGE);
                } else {
                    Config.getRepInstance().setParameter(PARAM_L10N_DEFAULT_LANGUAGE, abbreviation);
                }
            } else {
                sDefaultLanguage = abbreviation == null ? DEFAULT_LANGUAGE : abbreviation;
            }
        }

        public static String getDefaultCountry() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getString(PARAM_L10N_DEFAULT_COUNTRY, sDefaultCountry);
            }
            return sDefaultCountry;
        }

        public static synchronized void setDefaultCountry(String countryCode) {
            if (countryCode == null) {
                throw new IllegalArgumentException("countryCode can't be null.");
            }
            if (0 == countryCode.length()) {
                throw new IllegalArgumentException("countryCode can't be empty.");
            }
            if (Config.hasRepInstance()) {
                Config.getRepInstance().setParameter(PARAM_L10N_DEFAULT_COUNTRY, countryCode);
            } else {
                sDefaultCountry = countryCode;
            }
        }

        public static DateFormat getDefaultShortDateFormat() {
            Config config;
            if (Config.hasRepInstance() && (config = Config.getRepInstance()).hasParameter(PARAM_L10N_DEFAULT_SHORT_DATEFORMAT)) {
                SimpleDateFormat sf = null;
                try {
                    sf = new SimpleDateFormat(config.getString(PARAM_L10N_DEFAULT_SHORT_DATEFORMAT), Localization.getLocale());
                }
                catch (IllegalArgumentException e) {
                    throw new DateFormatInitializationException(e.getMessage());
                }
                return sf;
            }
            if (0 != Tools.getDefaultLanguage().compareToIgnoreCase(DEFAULT_LANGUAGE)) {
                return DateFormat.getDateInstance(3, Localization.getLocale());
            }
            return DateFormat.getDateInstance(3, Locale.ENGLISH);
        }

        public static DateFormat getDefaultLongDateFormat() {
            Config config;
            if (Config.hasRepInstance() && (config = Config.getRepInstance()).hasParameter(PARAM_L10N_DEFAULT_LONG_DATEFORMAT)) {
                SimpleDateFormat sf = null;
                try {
                    sf = new SimpleDateFormat(config.getString(PARAM_L10N_DEFAULT_LONG_DATEFORMAT), Localization.getLocale());
                }
                catch (IllegalArgumentException e) {
                    throw new DateFormatInitializationException(e.getMessage());
                }
                return sf;
            }
            if (0 != Tools.getDefaultLanguage().compareToIgnoreCase(DEFAULT_LANGUAGE)) {
                return DateFormat.getDateTimeInstance(2, 3, Localization.getLocale());
            }
            return DateFormat.getDateTimeInstance(2, 3, Locale.ENGLISH);
        }

        public static int getMaxVisualUrlLength() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getInt(PARAM_MAX_VISUAL_URL_LENGTH, 70);
            }
            return 70;
        }
    }

    public static abstract class Xml {
        public static final String PARAM_XML_VALIDATION = "XML_VALIDATION";
        private static final boolean DEFAULT_XML_VALIDATION = true;

        public static boolean getXmlValidation() {
            if (Config.hasRepInstance()) {
                return Config.getRepInstance().getBool(PARAM_XML_VALIDATION, true);
            }
            return true;
        }
    }
}

