/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.config;

import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.config.Xml2Config;
import com.uwyn.rife.config.exceptions.CantFindXmlPathException;
import com.uwyn.rife.config.exceptions.CantWriteToDestinationException;
import com.uwyn.rife.config.exceptions.ConfigErrorException;
import com.uwyn.rife.config.exceptions.ConfigsourceNotFoundException;
import com.uwyn.rife.config.exceptions.InitializationErrorException;
import com.uwyn.rife.config.exceptions.MissingPreferencesUserNodeException;
import com.uwyn.rife.config.exceptions.MissingXmlPathException;
import com.uwyn.rife.config.exceptions.StorePreferencesErrorException;
import com.uwyn.rife.config.exceptions.StoreXmlErrorException;
import com.uwyn.rife.rep.Participant;
import com.uwyn.rife.rep.Rep;
import com.uwyn.rife.resources.ResourceFinder;
import com.uwyn.rife.selector.XmlSelectorResolver;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.ObjectUtils;
import com.uwyn.rife.tools.SerializationUtils;
import com.uwyn.rife.tools.SortListComparables;
import com.uwyn.rife.tools.StringUtils;
import com.uwyn.rife.tools.exceptions.FileUtilsErrorException;
import com.uwyn.rife.tools.exceptions.SerializationUtilsErrorException;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.io.File;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config
implements Cloneable {
    public static final String PARAMETER_PREFERENCES_USER = "CONFIG_PREFERENCES_USER";
    public static final String PARAMETER_PREFERENCES_SYSTEM = "CONFIG_PREFERENCES_SYSTEM";
    private HashMap<String, String> mParameters = null;
    private ArrayList<String> mFinalParameters = null;
    private HashMap<String, ArrayList<String>> mLists = null;
    private ArrayList<String> mFinalLists = null;
    private String mXmlPath = null;
    private ResourceFinder mResourceFinder = null;

    public Config() {
        this.mParameters = new HashMap();
        this.mFinalParameters = new ArrayList();
        this.mLists = new HashMap();
        this.mFinalLists = new ArrayList();
    }

    public Config(String configSource, ResourceFinder resourceFinder) throws ConfigErrorException {
        this(configSource, resourceFinder, null, null, null, null);
    }

    Config(String configSource, ResourceFinder resourceFinder, HashMap<String, String> parameters, ArrayList<String> finalParameters, HashMap<String, ArrayList<String>> lists, ArrayList<String> finalLists) throws ConfigErrorException {
        if (configSource == null) {
            throw new IllegalArgumentException("configSource can't be null.");
        }
        if (0 == configSource.length()) {
            throw new IllegalArgumentException("configSource can't be empty.");
        }
        if (resourceFinder == null) {
            throw new IllegalArgumentException("resourceFinder can't be null.");
        }
        this.mResourceFinder = resourceFinder;
        String config_resolved = XmlSelectorResolver.resolve(configSource, resourceFinder, "rep/config-");
        if (config_resolved == null) {
            throw new ConfigsourceNotFoundException(configSource);
        }
        URL config_resource = resourceFinder.getResource(config_resolved);
        if (config_resource == null) {
            throw new ConfigsourceNotFoundException(configSource, config_resolved);
        }
        this.mXmlPath = config_resolved;
        Xml2Config xml_config = new Xml2Config(parameters, finalParameters, lists, finalLists);
        this.initialize(xml_config);
        xml_config = null;
    }

    public String getXmlPath() {
        return this.mXmlPath;
    }

    private boolean isPreferencesParameter(String parameter) {
        if (parameter == null) {
            return false;
        }
        return parameter.equals(PARAMETER_PREFERENCES_SYSTEM) || parameter.equals(PARAMETER_PREFERENCES_USER);
    }

    public void setPreferencesNode(Preferences node) {
        if (node == null) {
            throw new IllegalArgumentException("node can't be null.");
        }
        if (node.isUserNode()) {
            this.setParameter(PARAMETER_PREFERENCES_USER, node.absolutePath());
            this.removeParameter(PARAMETER_PREFERENCES_SYSTEM);
        } else {
            this.removeParameter(PARAMETER_PREFERENCES_USER);
            this.setParameter(PARAMETER_PREFERENCES_SYSTEM, node.absolutePath());
        }
    }

    public boolean hasPreferencesNode() {
        return this.mParameters.containsKey(PARAMETER_PREFERENCES_USER) || this.mParameters.containsKey(PARAMETER_PREFERENCES_SYSTEM);
    }

    public Preferences getPreferencesNode() {
        if (this.mParameters.containsKey(PARAMETER_PREFERENCES_USER)) {
            return Preferences.userRoot().node(this.getString(PARAMETER_PREFERENCES_USER));
        }
        if (this.mParameters.containsKey(PARAMETER_PREFERENCES_SYSTEM)) {
            return Preferences.systemRoot().node(this.getString(PARAMETER_PREFERENCES_SYSTEM));
        }
        return null;
    }

    public static boolean hasRepInstance() {
        return Rep.hasParticipant("ParticipantConfig");
    }

    public static Config getRepInstance() {
        Participant participant = Rep.getParticipant("ParticipantConfig");
        if (participant == null) {
            return null;
        }
        return (Config)participant.getObject();
    }

    public boolean hasParameter(String parameter) {
        Preferences preferences;
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        if (this.mParameters.containsKey(parameter)) {
            return true;
        }
        return !this.isPreferencesParameter(parameter) && this.hasPreferencesNode() && (preferences = this.getPreferencesNode()) != null && preferences.get(parameter, null) != null;
    }

    public boolean isFinalParameter(String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        return this.mFinalParameters.contains(parameter);
    }

    public int countParameters() {
        int result;
        block4: {
            Preferences preferences;
            result = this.mParameters.size();
            if (!this.hasPreferencesNode() || (preferences = this.getPreferencesNode()) == null) break block4;
            try {
                String[] keys;
                String[] stringArray = keys = preferences.keys();
                int n = 0;
                while (n < stringArray.length) {
                    String key = stringArray[n];
                    if (!this.mParameters.containsKey(key)) {
                        ++result;
                    }
                    ++n;
                }
            }
            catch (BackingStoreException e) {}
        }
        return result;
    }

    public String getString(String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        return this.getString(parameter, null);
    }

    public String getString(String parameter, String defaultValue) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        String result = null;
        Config config = this;
        synchronized (config) {
            Preferences preferences;
            if (!this.mFinalParameters.contains(parameter) && !this.isPreferencesParameter(parameter) && this.hasPreferencesNode() && (preferences = this.getPreferencesNode()) != null) {
                result = preferences.get(parameter, null);
            }
            if (result == null && this.mParameters != null) {
                result = this.mParameters.get(parameter);
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public boolean getBool(String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        return this.getBool(parameter, false);
    }

    public boolean getBool(String parameter, boolean defaultValue) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        String string_parameter = this.getString(parameter);
        if (string_parameter != null) {
            return StringUtils.convertToBoolean(string_parameter);
        }
        return defaultValue;
    }

    public int getChar(String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        return this.getChar(parameter, '\u0000');
    }

    public int getChar(String parameter, char defaultValue) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        String parameter_string_value = this.getString(parameter);
        if (parameter_string_value != null && parameter_string_value.length() > 0) {
            return parameter_string_value.charAt(0);
        }
        return defaultValue;
    }

    public int getInt(String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        return this.getInt(parameter, 0);
    }

    public int getInt(String parameter, int defaultValue) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        String string_parameter = this.getString(parameter);
        if (string_parameter != null) {
            try {
                return Integer.parseInt(string_parameter);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public long getLong(String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        return this.getLong(parameter, 0L);
    }

    public long getLong(String parameter, long defaultValue) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        String string_parameter = this.getString(parameter);
        if (string_parameter != null) {
            try {
                return Long.parseLong(string_parameter);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public float getFloat(String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        return this.getFloat(parameter, 0.0f);
    }

    public float getFloat(String parameter, float defaultValue) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        String string_parameter = this.getString(parameter);
        if (string_parameter != null) {
            try {
                return Float.parseFloat(string_parameter);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public double getDouble(String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        return this.getDouble(parameter, 0.0);
    }

    public double getDouble(String parameter, double defaultValue) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        String string_parameter = this.getString(parameter);
        if (string_parameter != null) {
            try {
                return Double.parseDouble(string_parameter);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public <TargetType extends Serializable> TargetType getSerializable(String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        return (TargetType)((Serializable)this.getSerializable(parameter, null));
    }

    public <TargetType extends Serializable> TargetType getSerializable(String parameter, TargetType defaultValue) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        String value = this.getString(parameter);
        if (value != null) {
            try {
                return (TargetType)((Serializable)SerializationUtils.deserializeFromString(value));
            }
            catch (SerializationUtilsErrorException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public void setFinalParameter(String parameter, boolean isFinal) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        if (isFinal && !this.mFinalParameters.contains(parameter)) {
            this.mFinalParameters.add(parameter);
        } else {
            this.mFinalParameters.remove(parameter);
        }
    }

    public void setParameter(String parameter, String value) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value can't be null.");
        }
        Config config = this;
        synchronized (config) {
            if (!this.mFinalParameters.contains(parameter)) {
                Preferences preferences;
                this.mParameters.put(parameter, value);
                if (!this.isPreferencesParameter(parameter) && this.hasPreferencesNode() && (preferences = this.getPreferencesNode()) != null && preferences.get(parameter, null) != null) {
                    preferences.put(parameter, value);
                }
                if (RifeConfig.Engine.PARAM_ELEMENT_AUTO_RELOAD.equals(parameter) || RifeConfig.Engine.PARAM_ELEMENT_GENERATION_PATH.equals(parameter)) {
                    System.getProperties().put(parameter, value);
                }
            }
        }
    }

    public void setParameter(String parameter, boolean value) {
        this.setParameter(parameter, String.valueOf(value));
    }

    public void setParameter(String parameter, char value) {
        this.setParameter(parameter, String.valueOf(value));
    }

    public void setParameter(String parameter, int value) {
        this.setParameter(parameter, String.valueOf(value));
    }

    public void setParameter(String parameter, long value) {
        this.setParameter(parameter, String.valueOf(value));
    }

    public void setParameter(String parameter, float value) {
        this.setParameter(parameter, String.valueOf(value));
    }

    public void setParameter(String parameter, double value) {
        this.setParameter(parameter, String.valueOf(value));
    }

    public void setParameter(String parameter, Serializable value) throws ConfigErrorException {
        try {
            this.setParameter(parameter, SerializationUtils.serializeToString(value));
        }
        catch (SerializationUtilsErrorException e) {
            throw new ConfigErrorException(e);
        }
    }

    public void removeParameter(String parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("parameter can't be null.");
        }
        if (0 == parameter.length()) {
            throw new IllegalArgumentException("parameter can't be empty.");
        }
        if (this.mFinalParameters.contains(parameter)) {
            return;
        }
        Config config = this;
        synchronized (config) {
            Preferences preferences;
            this.mParameters.remove(parameter);
            if (!this.isPreferencesParameter(parameter) && this.hasPreferencesNode() && (preferences = this.getPreferencesNode()) != null) {
                preferences.remove(parameter);
            }
        }
    }

    public boolean isFinalList(String list) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null.");
        }
        if (0 == list.length()) {
            throw new IllegalArgumentException("list can't be empty.");
        }
        return this.mFinalLists.contains(list);
    }

    public Collection<String> getStringItems(String list) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null.");
        }
        if (0 == list.length()) {
            throw new IllegalArgumentException("list can't be empty.");
        }
        Config config = this;
        synchronized (config) {
            Preferences list_preferences;
            Preferences preferences;
            ArrayList<String> list_items = null;
            if (!this.mFinalLists.contains(list) && this.hasPreferencesNode() && (preferences = this.getPreferencesNode()) != null && (list_preferences = preferences.node(list)) != null) {
                try {
                    String[] string_array = list_preferences.keys();
                    if (string_array != null && string_array.length > 0) {
                        int[] int_array = new int[string_array.length];
                        int counter = 0;
                        String[] stringArray = string_array;
                        int n = 0;
                        while (n < stringArray.length) {
                            String item_string = stringArray[n];
                            int_array[counter++] = Integer.parseInt(item_string);
                            ++n;
                        }
                        Arrays.sort(int_array);
                        list_items = new ArrayList(int_array.length);
                        int[] nArray = int_array;
                        int n2 = 0;
                        while (n2 < nArray.length) {
                            int item_int = nArray[n2];
                            list_items.add(list_preferences.get(String.valueOf(item_int), null));
                            ++n2;
                        }
                    }
                }
                catch (BackingStoreException e) {
                    // empty catch block
                }
            }
            if (list_items == null) {
                list_items = this.mLists.get(list);
            }
            return list_items;
        }
    }

    public Collection<Boolean> getBoolItems(String list) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null.");
        }
        if (0 == list.length()) {
            throw new IllegalArgumentException("list can't be empty.");
        }
        Collection<String> list_items = this.getStringItems(list);
        ArrayList<Boolean> result = new ArrayList<Boolean>(list_items.size());
        for (String item : list_items) {
            if (item.equalsIgnoreCase("true") || item.equalsIgnoreCase("t") || item.equalsIgnoreCase("1")) {
                result.add(true);
                continue;
            }
            result.add(false);
        }
        return result;
    }

    public Collection<Character> getCharItems(String list) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null.");
        }
        if (0 == list.length()) {
            throw new IllegalArgumentException("list can't be empty.");
        }
        Collection<String> list_items = this.getStringItems(list);
        ArrayList<Character> result = new ArrayList<Character>(list_items.size());
        for (String item : list_items) {
            if (item == null || item.length() <= 0) continue;
            result.add(new Character(item.charAt(0)));
        }
        return result;
    }

    public Collection<Integer> getIntItems(String list) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null.");
        }
        if (0 == list.length()) {
            throw new IllegalArgumentException("list can't be empty.");
        }
        Collection<String> list_items = this.getStringItems(list);
        ArrayList<Integer> result = new ArrayList<Integer>(list_items.size());
        for (String item : list_items) {
            if (item == null) continue;
            try {
                result.add(new Integer(Integer.parseInt(item)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    public Collection<Long> getLongItems(String list) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null.");
        }
        if (0 == list.length()) {
            throw new IllegalArgumentException("list can't be empty.");
        }
        Collection<String> list_items = this.getStringItems(list);
        ArrayList<Long> result = new ArrayList<Long>(list_items.size());
        for (String item : list_items) {
            if (item == null) continue;
            try {
                result.add(new Long(Long.parseLong(item)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    public Collection<Float> getFloatItems(String list) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null.");
        }
        if (0 == list.length()) {
            throw new IllegalArgumentException("list can't be empty.");
        }
        Collection<String> list_items = this.getStringItems(list);
        ArrayList<Float> result = new ArrayList<Float>(list_items.size());
        for (String item : list_items) {
            if (item == null) continue;
            try {
                result.add(new Float(Float.parseFloat(item)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    public Collection<Double> getDoubleItems(String list) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null.");
        }
        if (0 == list.length()) {
            throw new IllegalArgumentException("list can't be empty.");
        }
        Collection<String> list_items = this.getStringItems(list);
        ArrayList<Double> result = new ArrayList<Double>(list_items.size());
        for (String item : list_items) {
            if (item == null) continue;
            try {
                result.add(new Double(Double.parseDouble(item)));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    public <TargetType extends Serializable> Collection<TargetType> getSerializableItems(String list) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null.");
        }
        if (0 == list.length()) {
            throw new IllegalArgumentException("list can't be empty.");
        }
        Collection<String> list_items = this.getStringItems(list);
        ArrayList<Serializable> result = new ArrayList<Serializable>(list_items.size());
        for (String item : list_items) {
            try {
                result.add((Serializable)SerializationUtils.deserializeFromString(item));
            }
            catch (SerializationUtilsErrorException e) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean hasList(String list) {
        block6: {
            Preferences preferences;
            if (list == null) {
                throw new IllegalArgumentException("list can't be null.");
            }
            if (0 == list.length()) {
                throw new IllegalArgumentException("list can't be empty.");
            }
            if (this.mLists.containsKey(list)) {
                return true;
            }
            if (!this.hasPreferencesNode() || (preferences = this.getPreferencesNode()) == null) break block6;
            try {
                String[] list_names_array = preferences.childrenNames();
                if (list_names_array != null) {
                    List<String> list_names = Arrays.asList(list_names_array);
                    return list_names.contains(list);
                }
            }
            catch (BackingStoreException e) {}
        }
        return false;
    }

    public int countLists() {
        int result;
        block5: {
            Preferences preferences;
            result = this.mLists.size();
            if (!this.hasPreferencesNode() || (preferences = this.getPreferencesNode()) == null) break block5;
            try {
                String[] list_names = preferences.childrenNames();
                if (list_names != null) {
                    String[] stringArray = list_names;
                    int n = 0;
                    while (n < stringArray.length) {
                        String list_name = stringArray[n];
                        if (!this.mLists.containsKey(list_name)) {
                            ++result;
                        }
                        ++n;
                    }
                }
            }
            catch (BackingStoreException e) {}
        }
        return result;
    }

    public void addListItem(String list, String item) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null.");
        }
        if (0 == list.length()) {
            throw new IllegalArgumentException("list can't be empty.");
        }
        if (item == null) {
            throw new IllegalArgumentException("item can't be null.");
        }
        if (this.mFinalLists.contains(list)) {
            return;
        }
        Config config = this;
        synchronized (config) {
            Preferences list_preferences;
            Preferences preferences;
            ArrayList<Object> list_items = null;
            if (this.hasPreferencesNode() && (preferences = this.getPreferencesNode()) != null && (list_preferences = preferences.node(list)) != null) {
                try {
                    String[] string_array = list_preferences.keys();
                    if (string_array != null) {
                        int[] int_array = new int[string_array.length];
                        int counter = 0;
                        String[] stringArray = string_array;
                        int n = 0;
                        while (n < stringArray.length) {
                            String item_string = stringArray[n];
                            int_array[counter++] = Integer.parseInt(item_string);
                            ++n;
                        }
                        Arrays.sort(int_array);
                        list_items = new ArrayList(int_array.length);
                        int[] nArray = int_array;
                        int n2 = 0;
                        while (n2 < nArray.length) {
                            int item_int = nArray[n2];
                            list_items.add(list_preferences.get(String.valueOf(item_int), null));
                            ++n2;
                        }
                    }
                    list_preferences.put(String.valueOf(string_array.length), item);
                    list_items.add(item);
                }
                catch (BackingStoreException e) {
                    // empty catch block
                }
            }
            if (list_items != null) {
                this.mLists.put(list, list_items);
            } else if (this.mLists.containsKey(list)) {
                list_items = this.mLists.get(list);
                list_items.add(item);
            } else {
                list_items = new ArrayList();
                this.mLists.put(list, list_items);
                list_items.add(item);
            }
        }
    }

    public void addListItem(String list, boolean item) {
        this.addListItem(list, String.valueOf(item));
    }

    public void addListItem(String list, char item) {
        this.addListItem(list, String.valueOf(item));
    }

    public void addListItem(String list, int item) {
        this.addListItem(list, String.valueOf(item));
    }

    public void addListItem(String list, long item) {
        this.addListItem(list, String.valueOf(item));
    }

    public void addListItem(String list, float item) {
        this.addListItem(list, String.valueOf(item));
    }

    public void addListItem(String list, double item) {
        this.addListItem(list, String.valueOf(item));
    }

    public void addListItem(String list, Serializable item) throws ConfigErrorException {
        try {
            this.addListItem(list, SerializationUtils.serializeToString(item));
        }
        catch (SerializationUtilsErrorException e) {
            throw new ConfigErrorException(e);
        }
    }

    public void clearList(String list) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null.");
        }
        if (0 == list.length()) {
            throw new IllegalArgumentException("list can't be empty.");
        }
        if (this.mFinalLists.contains(list)) {
            return;
        }
        Config config = this;
        synchronized (config) {
            Preferences list_preferences;
            Preferences preferences;
            if (this.hasPreferencesNode() && (preferences = this.getPreferencesNode()) != null && (list_preferences = preferences.node(list)) != null) {
                try {
                    list_preferences.clear();
                }
                catch (BackingStoreException e) {
                    // empty catch block
                }
            }
            if (this.mLists.containsKey(list)) {
                this.mLists.put(list, new ArrayList());
            }
        }
    }

    public void removeList(String list) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null.");
        }
        if (0 == list.length()) {
            throw new IllegalArgumentException("list can't be empty.");
        }
        if (this.mFinalLists.contains(list)) {
            return;
        }
        Config config = this;
        synchronized (config) {
            Preferences list_preferences;
            Preferences preferences;
            if (this.hasPreferencesNode() && (preferences = this.getPreferencesNode()) != null && (list_preferences = preferences.node(list)) != null) {
                try {
                    list_preferences.removeNode();
                }
                catch (BackingStoreException e) {
                    // empty catch block
                }
            }
            this.mLists.remove(list);
        }
    }

    public void setFinalList(String list, boolean isFinal) {
        if (list == null) {
            throw new IllegalArgumentException("list can't be null.");
        }
        if (0 == list.length()) {
            throw new IllegalArgumentException("list can't be empty.");
        }
        if (isFinal && !this.mFinalLists.contains(list)) {
            this.mFinalLists.add(list);
        } else {
            this.mFinalLists.remove(list);
        }
    }

    private void initialize(Xml2Config xmlConfig) throws ConfigErrorException {
        try {
            xmlConfig.processXml(this.mXmlPath, this.mResourceFinder);
            Config config = this;
            synchronized (config) {
                this.mParameters = xmlConfig.getParameters();
                this.mFinalParameters = xmlConfig.getFinalParameters();
                this.mLists = xmlConfig.getLists();
                this.mFinalLists = xmlConfig.getFinalLists();
                if (this.mParameters.containsKey("ELEMENT_AUTO_RELOAD")) {
                    System.getProperties().put("ELEMENT_AUTO_RELOAD", this.mParameters.get("ELEMENT_AUTO_RELOAD"));
                }
                if (this.mParameters.containsKey("ELEMENT_GENERATION_PATH")) {
                    System.getProperties().put("ELEMENT_GENERATION_PATH", this.mParameters.get("ELEMENT_GENERATION_PATH"));
                }
            }
        }
        catch (XmlErrorException e) {
            throw new InitializationErrorException(this.mXmlPath, e);
        }
    }

    Map<String, String> getParameters() {
        return this.mParameters;
    }

    List<String> getFinalParameters() {
        return this.mFinalParameters;
    }

    Map<String, ArrayList<String>> getLists() {
        return this.mLists;
    }

    List<String> getFinalLists() {
        return this.mFinalLists;
    }

    public String toXml() {
        StringBuffer xml_output;
        StringBuffer stringBuffer = xml_output = new StringBuffer();
        synchronized (stringBuffer) {
            xml_output.append("<config>\n");
            ArrayList<String> list_keys_arraylist = new ArrayList<String>();
            for (String list_key : (Collection)this.mLists.keySet()) {
                list_keys_arraylist.add(list_key);
            }
            new SortListComparables().sort(list_keys_arraylist);
            for (String list_key : (Collection)list_keys_arraylist) {
                xml_output.append("\t<list name=\"");
                xml_output.append(StringUtils.encodeXml(list_key));
                if (this.mFinalLists.contains(list_key)) {
                    xml_output.append("\" final=\"true");
                }
                xml_output.append("\">\n");
                ArrayList<String> list_items = this.mLists.get(list_key);
                for (String list_item : (Collection)list_items) {
                    xml_output.append(new StringBuffer().append(new StringBuffer().append("\t\t<item>").append(StringUtils.encodeXml(list_item)).toString()).append("</item>\n").toString());
                }
                xml_output.append("\t</list>\n");
            }
            ArrayList<String> parameter_keys_arraylist = new ArrayList<String>();
            for (String parameter_key : (Collection)this.mParameters.keySet()) {
                parameter_keys_arraylist.add(parameter_key);
            }
            new SortListComparables().sort(parameter_keys_arraylist);
            for (String parameter_key : (Collection)parameter_keys_arraylist) {
                xml_output.append("\t<param name=\"");
                xml_output.append(StringUtils.encodeXml(parameter_key));
                if (this.mFinalParameters.contains(parameter_key)) {
                    xml_output.append("\" final=\"true");
                }
                xml_output.append("\">");
                xml_output.append(StringUtils.encodeXml(this.mParameters.get(parameter_key).toString()));
                xml_output.append("</param>\n");
            }
            xml_output.append("</config>\n");
            return xml_output.toString();
        }
    }

    public void storeToXml() throws ConfigErrorException {
        String xmlpath = null;
        URL xmlpath_resource = null;
        xmlpath = this.getXmlPath();
        if (xmlpath == null) {
            throw new MissingXmlPathException();
        }
        xmlpath_resource = this.mResourceFinder.getResource(xmlpath);
        if (xmlpath_resource == null) {
            throw new CantFindXmlPathException(xmlpath);
        }
        try {
            this.storeToXml(new File(URLDecoder.decode(xmlpath_resource.getPath(), "ISO-8859-1")));
        }
        catch (UnsupportedEncodingException e) {}
    }

    public synchronized void storeToXml(File destination) throws ConfigErrorException {
        if (destination == null) {
            throw new IllegalArgumentException("destination can't be null");
        }
        if (destination.exists() && !destination.canWrite()) {
            throw new CantWriteToDestinationException(destination);
        }
        StringBuffer content = new StringBuffer(new StringBuffer().append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n").append("<!DOCTYPE config SYSTEM \"/dtd/config.dtd\">\n").toString());
        content.append(this.toXml());
        try {
            FileUtils.writeString(content.toString(), destination);
        }
        catch (FileUtilsErrorException e) {
            throw new StoreXmlErrorException(destination, (Throwable)e);
        }
    }

    public void storeToPreferences() throws ConfigErrorException {
        if (!this.hasPreferencesNode()) {
            throw new MissingPreferencesUserNodeException();
        }
        this.storeToPreferences(this.getPreferencesNode());
    }

    public synchronized void storeToPreferences(Preferences preferences) throws ConfigErrorException {
        if (preferences == null) {
            throw new IllegalArgumentException("destination can't be null");
        }
        Preferences preferences2 = preferences;
        synchronized (preferences2) {
            Preferences list_node = null;
            for (String list_key : (Collection)this.mLists.keySet()) {
                if (this.mFinalLists.contains(list_key)) continue;
                list_node = preferences.node(list_key);
                int counter = 0;
                ArrayList<String> list_items = this.mLists.get(list_key);
                for (String list_item : (Collection)list_items) {
                    list_node.put(String.valueOf(counter++), list_item);
                }
            }
            for (String parameter_key : (Collection)this.mParameters.keySet()) {
                if (parameter_key.equals(PARAMETER_PREFERENCES_SYSTEM) || parameter_key.equals(PARAMETER_PREFERENCES_USER) || this.mFinalParameters.contains(parameter_key)) continue;
                preferences.put(parameter_key, this.mParameters.get(parameter_key));
            }
            try {
                preferences.flush();
            }
            catch (BackingStoreException e) {
                throw new StorePreferencesErrorException(preferences, (Throwable)e);
            }
        }
    }

    public Config clone() {
        Config new_config = null;
        try {
            new_config = (Config)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.config").severe(ExceptionUtils.getExceptionStackTrace(e));
        }
        try {
            new_config.mParameters = ObjectUtils.deepClone(this.mParameters);
            new_config.mFinalParameters = ObjectUtils.deepClone(this.mFinalParameters);
            new_config.mLists = ObjectUtils.deepClone(this.mLists);
            new_config.mFinalLists = ObjectUtils.deepClone(this.mFinalLists);
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger("com.uwyn.rife.config").severe(ExceptionUtils.getExceptionStackTrace(e));
        }
        return new_config;
    }

    public /* synthetic */ Object clone() {
        return this.clone();
    }
}

