/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.loader.xhtml;

import com.uwyn.rife.cmf.loader.XhtmlContentLoaderBackend;
import com.uwyn.rife.resources.ResourceFinderClasspath;
import com.uwyn.rife.template.Template;
import com.uwyn.rife.template.TemplateFactory;
import com.uwyn.rife.xml.LoggingErrorRedirector;
import com.uwyn.rife.xml.XmlEntityResolver;
import com.uwyn.rife.xml.XmlErrorRedirector;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jdk14Loader
extends XhtmlContentLoaderBackend {
    @Override
    public String loadFromString(String data, boolean fragment, Set<String> errors) {
        return new LoaderDelegate().load(data, fragment, errors);
    }

    @Override
    public boolean isBackendPresent() {
        try {
            return Class.forName("org.xml.sax.XMLReader") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoaderDelegate
    extends DefaultHandler {
        private XmlEntityResolver mEntityResolver = null;
        private XmlErrorRedirector mErrorRedirector = null;

        public String load(String data, boolean fragment, Set<String> errors) {
            String complete_page = data;
            StringReader reader = null;
            if (fragment) {
                Template t = TemplateFactory.XHTML.get("cmf.container.template");
                t.setValue("fragment", data);
                complete_page = t.getContent();
            }
            reader = new StringReader(complete_page);
            try {
                InputSource inputsource = new InputSource(reader);
                this.mEntityResolver = new XmlEntityResolver(ResourceFinderClasspath.getInstance()).addAlias("http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", "/dtd/cmf/xhtml1-transitional.dtd").addAlias("http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent", "/dtd/cmf/xhtml-lat1.ent").addAlias("http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent", "/dtd/cmf/xhtml-symbol.ent").addAlias("http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent", "/dtd/cmf/xhtml-special.ent").restrictToAliases(true);
                this.mErrorRedirector = new LoggingErrorRedirector();
                XMLReader xml_reader = null;
                try {
                    xml_reader = XMLReaderFactory.createXMLReader();
                }
                catch (SAXException e) {
                    try {
                        xml_reader = XMLReaderFactory.createXMLReader("org.apache.crimson.parser.XMLReaderImpl");
                    }
                    catch (SAXException e2) {
                        throw new XmlErrorException(e2);
                    }
                }
                xml_reader.setEntityResolver(this.mEntityResolver);
                xml_reader.setErrorHandler(this.mErrorRedirector);
                try {
                    xml_reader.setFeature("http://xml.org/sax/features/validation", true);
                }
                catch (SAXException e) {
                    throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append("The parser '").append(xml_reader.getClass().getName()).toString()).append("' doesn't support validation.").toString(), e);
                }
                try {
                    xml_reader.parse(inputsource);
                }
                catch (SAXParseException e) {
                    if (errors != null) {
                        errors.add(this.formatException(fragment, e));
                    }
                }
                catch (SAXException e) {
                    if (e.getException() != null && e.getException() instanceof RuntimeException) {
                        throw (RuntimeException)e.getException();
                    }
                    throw new XmlErrorException(e);
                }
                catch (IOException e) {
                    throw new XmlErrorException(e);
                }
                if (errors != null) {
                    if (this.mErrorRedirector.hasErrors()) {
                        errors.addAll(this.formatExceptions(fragment, this.mErrorRedirector.getErrors()));
                    }
                    if (this.mErrorRedirector.hasFatalErrors()) {
                        errors.addAll(this.formatExceptions(fragment, this.mErrorRedirector.getFatalErrors()));
                    }
                }
            }
            catch (RuntimeException e) {
                if (errors != null) {
                    errors.add(e.getMessage());
                }
                return null;
            }
            if (errors != null && errors.size() > 0 || this.mErrorRedirector.hasErrors() || this.mErrorRedirector.hasFatalErrors()) {
                return null;
            }
            return data;
        }

        private Collection<String> formatExceptions(boolean fragment, Collection<SAXParseException> exceptions) {
            if (exceptions == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            for (SAXParseException e : exceptions) {
                result.add(this.formatException(fragment, e));
            }
            return result;
        }

        private String formatException(boolean fragment, SAXParseException e) {
            StringBuffer formatted;
            StringBuffer stringBuffer = formatted = new StringBuffer();
            synchronized (stringBuffer) {
                if (e.getSystemId() != null) {
                    formatted.append(e.getSystemId());
                }
                if (e.getPublicId() != null) {
                    if (formatted.length() > 0) {
                        formatted.append(", ");
                    }
                    formatted.append(e.getPublicId());
                }
                if (e.getLineNumber() >= 0) {
                    if (formatted.length() > 0) {
                        formatted.append(", ");
                    }
                    formatted.append("line ");
                    if (fragment) {
                        formatted.append(e.getLineNumber() - 3);
                    } else {
                        formatted.append(e.getLineNumber());
                    }
                }
                if (e.getColumnNumber() >= 0) {
                    if (formatted.length() > 0) {
                        formatted.append(", ");
                    }
                    formatted.append("col ");
                    formatted.append(e.getColumnNumber());
                }
                if (formatted.length() > 0) {
                    formatted.append(" : ");
                }
                formatted.append(e.getMessage());
                return formatted.toString();
            }
        }
    }
}

