/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.loader.image;

import com.uwyn.rife.cmf.loader.ImageContentLoaderBackend;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.ImageWaiter;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.File;
import java.util.Set;
import magick.ImageInfo;
import magick.MagickImage;
import magick.MagickProducer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMagickLoader
extends ImageContentLoaderBackend {
    @Override
    public Image loadFromBytes(byte[] data, Set<String> errors) {
        return new LoaderDelegate().load(data, errors);
    }

    @Override
    public boolean isBackendPresent() {
        try {
            return Class.forName("magick.ImageInfo") != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoaderDelegate {
        public Image load(byte[] data, Set<String> errors) {
            Image image = null;
            File tmp_file = null;
            try {
                try {
                    tmp_file = File.createTempFile("cmfjmagick", "", new File(RifeConfig.Global.getTempPath()));
                    FileUtils.writeBytes(data, tmp_file);
                    ImageInfo image_info = new ImageInfo(tmp_file.getAbsolutePath());
                    MagickImage magick = new MagickImage();
                    magick.readImage(image_info);
                    if (0 == magick.getMagick().length()) {
                        Image image2 = null;
                        if (tmp_file != null) {
                            tmp_file.delete();
                        }
                        return image2;
                    }
                    MagickProducer producer = new MagickProducer(magick);
                    image = Toolkit.getDefaultToolkit().createImage((ImageProducer)producer);
                    ImageWaiter.wait(image);
                }
                catch (Throwable e) {
                    if (errors != null) {
                        errors.add(ExceptionUtils.getExceptionStackTrace(e));
                    }
                    image = null;
                }
            }
            finally {
                if (tmp_file != null) {
                    tmp_file.delete();
                }
            }
            return image;
        }
    }
}

