/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.loader.image;

import com.imagero.reader.ImageReader;
import com.imagero.reader.ReaderFactory;
import com.uwyn.rife.cmf.loader.ImageContentLoaderBackend;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.ImageWaiter;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageroReaderLoader
extends ImageContentLoaderBackend {
    @Override
    public Image loadFromBytes(byte[] data, Set<String> errors) {
        return new LoaderDelegate().load(data, errors);
    }

    @Override
    public boolean isBackendPresent() {
        try {
            return Class.forName("com.imagero.reader.ReaderFactory") != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoaderDelegate {
        public Image load(byte[] data, Set<String> errors) {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            Image image = null;
            PrintStream default_out = System.out;
            PrintStream default_err = System.err;
            try {
                try {
                    System.setOut(new PrintStream(new ByteArrayOutputStream()));
                    System.setErr(new PrintStream(new ByteArrayOutputStream()));
                    ImageReader imagero = ReaderFactory.createReader((InputStream)in);
                    if (imagero.getImageCount() > 0) {
                        ImageProducer producer = imagero.getProducer(0);
                        image = Toolkit.getDefaultToolkit().createImage(producer);
                        ImageWaiter.wait(image);
                    }
                }
                catch (Throwable e) {
                    if (errors != null) {
                        errors.add(ExceptionUtils.getExceptionStackTrace(e));
                    }
                    image = null;
                }
            }
            finally {
                System.setOut(default_out);
                System.setErr(default_err);
            }
            return image;
        }
    }
}

