/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.format;

import com.uwyn.rife.cmf.MimeType;
import com.uwyn.rife.cmf.dao.Content;
import com.uwyn.rife.cmf.format.Formatter;
import com.uwyn.rife.cmf.format.exceptions.FormatException;
import com.uwyn.rife.cmf.format.exceptions.InvalidContentDataTypeException;
import com.uwyn.rife.cmf.format.exceptions.UnexpectedConversionErrorException;
import com.uwyn.rife.cmf.format.exceptions.UnreadableDataFormatException;
import com.uwyn.rife.cmf.format.exceptions.UnsupportedTargetMimeTypeException;
import com.uwyn.rife.cmf.loader.ImageContentLoader;
import com.uwyn.rife.cmf.transform.ContentTransformer;
import com.uwyn.rife.tools.ImageWaiter;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageFormatter
implements Formatter<byte[], Image> {
    @Override
    public byte[] format(Content content, ContentTransformer<Image> transformer) throws FormatException {
        if (!(content.getData() instanceof byte[])) {
            Class<?> clazz;
            try {
                clazz = Class.forName("[B");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            throw new InvalidContentDataTypeException(this, content.getMimeType(), clazz, content.getData().getClass());
        }
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(content.getMimeType().toString());
        ImageWriter writer = null;
        if (writers.hasNext()) {
            writer = writers.next();
        }
        if (writer == null) {
            throw new UnsupportedTargetMimeTypeException(content.getMimeType());
        }
        Image data = null;
        if (content.hasCachedLoadedData()) {
            data = (Image)content.getCachedLoadedData();
        }
        if (data == null) {
            HashSet<String> errors = new HashSet<String>();
            data = (Image)new ImageContentLoader().load(content.getData(), false, errors);
            if (data == null) {
                throw new UnreadableDataFormatException(content.getMimeType(), errors);
            }
        }
        if (content.hasAttributes() && (content.hasAttribute("width") || content.hasAttribute("height"))) {
            String width_value = content.getAttribute("width");
            String height_value = content.getAttribute("height");
            int width = -1;
            int height = -1;
            if (width_value != null) {
                try {
                    width = Integer.parseInt(width_value.toString());
                }
                catch (NumberFormatException e) {
                    throw new FormatException(e);
                }
            }
            if (height_value != null) {
                try {
                    height = Integer.parseInt(height_value.toString());
                }
                catch (NumberFormatException e) {
                    throw new FormatException(e);
                }
            }
            if ((width >= 0 && width != data.getWidth(null) || height >= 0 && height != data.getHeight(null)) && ((data = data.getScaledInstance(width, height, 4)).getWidth(null) < 0 || data.getHeight(null) < 0)) {
                ImageWaiter.wait(data);
            }
        }
        if (transformer != null) {
            data = transformer.transform(data, content.getAttributes());
        }
        BufferedImage buffer = null;
        buffer = content.getMimeType() == MimeType.IMAGE_JPEG ? new BufferedImage(data.getWidth(null), data.getHeight(null), 1) : new BufferedImage(data.getWidth(null), data.getHeight(null), 2);
        Graphics2D g2 = buffer.createGraphics();
        g2.setComposite(AlphaComposite.SrcOver);
        g2.drawImage(data, 0, 0, null);
        g2.dispose();
        content.property("cmf:width", String.valueOf(buffer.getWidth())).property("cmf:height", String.valueOf(buffer.getHeight()));
        ByteArrayOutputStream bytes_out = new ByteArrayOutputStream();
        BufferedOutputStream buffered_out = new BufferedOutputStream(bytes_out);
        try {
            ImageOutputStream image_out = ImageIO.createImageOutputStream(buffered_out);
            writer.setOutput(image_out);
            writer.write(buffer);
            writer.dispose();
            bytes_out.flush();
            bytes_out.close();
        }
        catch (IOException e) {
            throw new UnexpectedConversionErrorException(e);
        }
        return bytes_out.toByteArray();
    }

    @Override
    public /* synthetic */ Object format(Content content, ContentTransformer contentTransformer) throws FormatException {
        return this.format(content, (ContentTransformer<Image>)contentTransformer);
    }
}

