/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.dam.contentstores;

import com.uwyn.rife.cmf.MimeType;
import com.uwyn.rife.cmf.dam.ContentDataUser;
import com.uwyn.rife.cmf.dam.contentstores.DatabaseContentStore;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.StoreContentDataErrorException;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.UseContentDataErrorException;
import com.uwyn.rife.cmf.dao.Content;
import com.uwyn.rife.cmf.dao.ContentInfo;
import com.uwyn.rife.cmf.format.Formatter;
import com.uwyn.rife.cmf.format.exceptions.FormatException;
import com.uwyn.rife.cmf.transform.ContentTransformer;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.tools.Convert;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.StringUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseTextStore
extends DatabaseContentStore {
    private static /* synthetic */ boolean $assertionsDisabled;

    public DatabaseTextStore(Datasource datasource) {
        super(datasource);
        this.addMimeType(MimeType.APPLICATION_XHTML);
        this.addMimeType(MimeType.TEXT_PLAIN);
        this.addMimeType(MimeType.TEXT_XML);
    }

    @Override
    public String getContentType(ContentInfo contentInfo) {
        MimeType mimeType = MimeType.getMimeType(contentInfo.getMimeType());
        if (!this.getSupportedMimeTypes().contains(mimeType)) {
            return null;
        }
        return new StringBuffer().append(mimeType).append("; charset=UTF-8").toString();
    }

    @Override
    public Formatter getFormatter(MimeType mimeType, boolean fragment) {
        if (!this.getSupportedMimeTypes().contains(mimeType)) {
            return null;
        }
        return mimeType.getFormatter();
    }

    protected boolean _storeContentData(Insert storeContent, int id, Content content, ContentTransformer transformer) {
        String typed_data;
        if (id < 0) {
            throw new IllegalArgumentException("id must be positive");
        }
        if (content != null && content.getData() != null && !(content.getData() instanceof String)) {
            throw new IllegalArgumentException("the content data must be of type String");
        }
        if (!$assertionsDisabled && storeContent == null) {
            throw new AssertionError();
        }
        if (content == null || content.getData() == null) {
            typed_data = null;
        } else {
            Formatter formatter = null;
            if (!Convert.toBoolean(content.getAttribute("unformatted"), false)) {
                formatter = this.getFormatter(content.getMimeType(), content.isFragment());
            }
            if (formatter != null) {
                try {
                    typed_data = (String)formatter.format(content, transformer);
                }
                catch (FormatException e) {
                    throw new StoreContentDataErrorException(id, (Throwable)e);
                }
            } else {
                typed_data = (String)content.getData();
            }
        }
        return this.storeContent(storeContent, id, typed_data);
    }

    protected boolean storeContent(Insert storeContent, int id, String data) {
        try {
            int result = this.executeUpdate(storeContent, new 1(id, data));
            return result > 0;
        }
        catch (DatabaseException e) {
            throw new StoreContentDataErrorException(id, (Throwable)e);
        }
    }

    protected <ResultType> ResultType _useContentData(Select retrieveContent, int id, ContentDataUser user) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be positive");
        }
        if (user == null) {
            throw new IllegalArgumentException("user can't be null");
        }
        if (!$assertionsDisabled && retrieveContent == null) {
            throw new AssertionError();
        }
        try {
            return user.useContentData(this.executeGetFirstString(retrieveContent, new 2(id)));
        }
        catch (DatabaseException e) {
            throw new UseContentDataErrorException(id, (Throwable)e);
        }
    }

    @Override
    public String getContentForHtml(int id, ContentInfo info, ElementInfo serveContent) {
        return (String)this.useContentData(id, new 3(info));
    }

    @Override
    protected void outputContentColumn(ResultSet resultSet, OutputStream os) throws SQLException {
        Reader text_reader = resultSet.getCharacterStream("content");
        char[] buffer = new char[512];
        int size = 0;
        try {
            while ((size = text_reader.read(buffer)) != -1) {
                os.write(new String(buffer).getBytes("UTF-8"), 0, size);
            }
            os.flush();
        }
        catch (IOException e) {}
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.cmf.dam.contentstores.DatabaseTextStore");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    class 1
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;
        private final /* synthetic */ String val$data;

        1(int n, String string) {
            this.val$id = n;
            this.val$data = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$id);
            if (this.val$data == null) {
                statement.setNull("content", 2005).setInt(DatabaseTextStore.this.getContentSizeColumnName(), 0);
            } else {
                byte[] bytes = null;
                try {
                    bytes = this.val$data.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    Logger.getLogger("com.uwyn.rife.cmf").severe(ExceptionUtils.getExceptionStackTrace(e));
                }
                statement.setInt(DatabaseTextStore.this.getContentSizeColumnName(), bytes.length).setCharacterStream("content", (Reader)new StringReader(this.val$data), this.val$data.length());
            }
        }

        static /* synthetic */ DatabaseTextStore access$0(1 var0) {
            return var0.DatabaseTextStore.this;
        }
    }

    class 2
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;

        2(int n) {
            this.val$id = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$id);
        }

        static /* synthetic */ DatabaseTextStore access$0(2 var0) {
            return var0.DatabaseTextStore.this;
        }
    }

    class 3
    extends ContentDataUser {
        private final /* synthetic */ ContentInfo val$info;

        3(ContentInfo contentInfo) {
            this.val$info = contentInfo;
        }

        public String useContentData(Object contentData) {
            if (contentData == null) {
                return "";
            }
            if (MimeType.APPLICATION_XHTML.equals(this.val$info.getMimeType())) {
                return contentData.toString();
            }
            if (MimeType.TEXT_PLAIN.equals(this.val$info.getMimeType())) {
                return StringUtils.encodeHtml(contentData.toString());
            }
            return "";
        }

        public /* synthetic */ Object useContentData(Object object) {
            return this.useContentData(object);
        }

        static /* synthetic */ DatabaseTextStore access$0(3 var0) {
            return var0.DatabaseTextStore.this;
        }
    }
}

