/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.dam.contentstores;

import com.uwyn.rife.cmf.MimeType;
import com.uwyn.rife.cmf.dam.ContentDataUser;
import com.uwyn.rife.cmf.dam.ContentStore;
import com.uwyn.rife.cmf.dam.contentstores.DatabaseRawStore;
import com.uwyn.rife.cmf.dam.contentstores.RawContentStream;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.DeleteContentDataErrorException;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.HasContentDataErrorException;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.InstallContentStoreErrorException;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.RemoveContentStoreErrorException;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.RetrieveSizeErrorException;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.StoreContentDataErrorException;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.UseContentDataErrorException;
import com.uwyn.rife.cmf.dao.Content;
import com.uwyn.rife.cmf.dao.ContentInfo;
import com.uwyn.rife.cmf.format.Formatter;
import com.uwyn.rife.cmf.format.exceptions.FormatException;
import com.uwyn.rife.cmf.transform.ContentTransformer;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.DbResultSet;
import com.uwyn.rife.database.DbTransactionUser;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.DropTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.ReadQuery;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.engine.ElementSupport;
import com.uwyn.rife.tools.Convert;
import com.uwyn.rife.tools.ExceptionUtils;
import com.uwyn.rife.tools.FileUtils;
import com.uwyn.rife.tools.InnerClassException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseRawStore
extends DbQueryManager
implements ContentStore {
    private ArrayList<MimeType> mMimeTypes = new ArrayList();
    private static /* synthetic */ boolean $assertionsDisabled;

    public DatabaseRawStore(Datasource datasource) {
        super(datasource);
        this.addMimeType(MimeType.RAW);
    }

    protected void addMimeType(MimeType mimeType) {
        this.mMimeTypes.add(mimeType);
    }

    @Override
    public Collection<MimeType> getSupportedMimeTypes() {
        return this.mMimeTypes;
    }

    @Override
    public String getContentType(ContentInfo contentInfo) {
        MimeType mimeType = MimeType.getMimeType(contentInfo.getMimeType());
        if (!this.getSupportedMimeTypes().contains(mimeType)) {
            return null;
        }
        Map<String, String> attributes = contentInfo.getAttributes();
        if (attributes != null && attributes.containsKey("content-type")) {
            return attributes.get("content-type");
        }
        if (contentInfo.hasName()) {
            return RifeConfig.Mime.getMimeType(FileUtils.getExtension(contentInfo.getName()));
        }
        return null;
    }

    @Override
    public Formatter getFormatter(MimeType mimeType, boolean fragment) {
        if (!this.getSupportedMimeTypes().contains(mimeType)) {
            return null;
        }
        return mimeType.getFormatter();
    }

    @Override
    public String getContentForHtml(int id, ContentInfo info, ElementInfo serveContent) {
        return "";
    }

    protected boolean _install(CreateTable createTableContentInfo, CreateTable createTableContentChunk) {
        if (!$assertionsDisabled && createTableContentInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && createTableContentChunk == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(createTableContentInfo);
            this.executeUpdate(createTableContentChunk);
        }
        catch (DatabaseException e) {
            throw new InstallContentStoreErrorException(e);
        }
        return true;
    }

    protected boolean _remove(DropTable dropTableContentInfo, DropTable dropTableContentChunk) {
        if (!$assertionsDisabled && dropTableContentInfo == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(dropTableContentChunk);
            this.executeUpdate(dropTableContentInfo);
        }
        catch (DatabaseException e) {
            throw new RemoveContentStoreErrorException(e);
        }
        return true;
    }

    protected boolean _deleteContentData(Delete deleteContentInfo, Delete deleteContentChunk, int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be positive");
        }
        if (!$assertionsDisabled && deleteContentInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && deleteContentChunk == null) {
            throw new AssertionError();
        }
        Boolean result = null;
        try {
            result = (Boolean)this.inTransaction(new 3(deleteContentChunk, id, deleteContentInfo));
        }
        catch (DatabaseException e) {
            throw new DeleteContentDataErrorException(id, e);
        }
        return result != null && result != false;
    }

    protected int _getSize(Select retrieveSize, int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be positive");
        }
        if (!$assertionsDisabled && retrieveSize == null) {
            throw new AssertionError();
        }
        try {
            return this.executeGetFirstInt(retrieveSize, new 4(id));
        }
        catch (DatabaseException e) {
            throw new RetrieveSizeErrorException(id, e);
        }
    }

    protected boolean _hasContentData(Select hasContentData, int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be positive");
        }
        if (!$assertionsDisabled && hasContentData == null) {
            throw new AssertionError();
        }
        try {
            return this.executeHasResultRows(hasContentData, new 5(id));
        }
        catch (DatabaseException e) {
            throw new HasContentDataErrorException(id, e);
        }
    }

    protected String getContentSizeColumnName() {
        return "size";
    }

    protected boolean _storeContentData(Insert storeContentInfo, Insert storeContentChunk, int id, Content content, ContentTransformer transformer) {
        InputStream typed_data;
        if (id < 0) {
            throw new IllegalArgumentException("id must be positive");
        }
        if (content != null && content.getData() != null && !(content.getData() instanceof InputStream)) {
            throw new IllegalArgumentException("the content data must be of type InputStream");
        }
        if (!$assertionsDisabled && storeContentInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && storeContentChunk == null) {
            throw new AssertionError();
        }
        if (content == null || content.getData() == null) {
            typed_data = null;
        } else {
            Formatter formatter = null;
            if (!Convert.toBoolean(content.getAttribute("unformatted"), false)) {
                formatter = this.getFormatter(content.getMimeType(), content.isFragment());
            }
            if (formatter != null) {
                try {
                    typed_data = (InputStream)formatter.format(content, transformer);
                }
                catch (FormatException e) {
                    throw new StoreContentDataErrorException(id, (Throwable)e);
                }
            } else {
                typed_data = (InputStream)content.getData();
            }
        }
        try {
            Boolean success = (Boolean)this.inTransaction(new 7(storeContentChunk, id, typed_data, storeContentInfo));
            return success == null ? false : success;
        }
        catch (InnerClassException e) {
            throw new StoreContentDataErrorException(id, (Throwable)e.getCause());
        }
        catch (DatabaseException e) {
            throw new StoreContentDataErrorException(id, (Throwable)e);
        }
    }

    protected int storeChunks(Insert storeContentChunk, int id, InputStream data) throws IOException {
        8.Scope s = new 8.Scope(this);
        if (data != null) {
            s.buffer = new byte[65535];
            while ((s.length = data.read(s.buffer)) != -1) {
                s.size += s.length;
                if (this.executeUpdate(storeContentChunk, new 9(id, s)) <= 0) {
                    return -1;
                }
                ++s.ordinal;
            }
        }
        return s.size;
    }

    protected <ResultType> ResultType _useContentData(Select retrieveContentChunks, int id, ContentDataUser user) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be positive");
        }
        if (user == null) {
            throw new IllegalArgumentException("user can't be null");
        }
        if (!$assertionsDisabled && retrieveContentChunks == null) {
            throw new AssertionError();
        }
        try {
            RawContentStream data = RawContentStream.getInstance(this, retrieveContentChunks, id);
            try {
                Object ResultType = user.useContentData(data);
                if (data != null) {
                    try {
                        ((InputStream)data).close();
                    }
                    catch (IOException e) {
                        throw new UseContentDataErrorException(id, (Throwable)e);
                    }
                }
                return ResultType;
            }
            catch (Throwable throwable) {
                if (data != null) {
                    try {
                        ((InputStream)data).close();
                    }
                    catch (IOException e) {
                        throw new UseContentDataErrorException(id, (Throwable)e);
                    }
                }
                throw throwable;
            }
        }
        catch (DatabaseException e) {
            throw new UseContentDataErrorException(id, (Throwable)e);
        }
    }

    protected void _serveContentData(Select retrieveContentChunks, ElementSupport element, int id) {
        if (element == null) {
            throw new IllegalArgumentException("element can't be null");
        }
        if (id < 0) {
            element.setStatus(404);
            return;
        }
        if (!$assertionsDisabled && retrieveContentChunks == null) {
            throw new AssertionError();
        }
        int size = this.getSize(id);
        if (size < 0) {
            element.setStatus(404);
            return;
        }
        element.setContentLength(size);
        try {
            Boolean success = (Boolean)this.executeQuery((ReadQuery)retrieveContentChunks, new 10(id, element, size));
            if (success == null || !success.booleanValue()) {
                element.setStatus(404);
                return;
            }
        }
        catch (DatabaseException e) {
            Logger.getLogger("com.uwyn.rife.cmf").severe(ExceptionUtils.getExceptionStackTrace(e));
            element.setStatus(404);
        }
    }

    protected void serveChunks(DbResultSet resultset, OutputStream os, int size) throws SQLException, IOException {
        byte[] buffer = new byte[512];
        do {
            InputStream is = resultset.getBinaryStream("chunk");
            BufferedInputStream buffered_raw_is = new BufferedInputStream(is, 512);
            int buffer_size = 0;
            try {
                while ((buffer_size = buffered_raw_is.read(buffer)) != -1) {
                    os.write(buffer, 0, buffer_size);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        } while (resultset.next());
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.cmf.dam.contentstores.DatabaseRawStore");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    class 3
    extends DbTransactionUser {
        private final /* synthetic */ Delete val$deleteContentChunk;
        private final /* synthetic */ int val$id;
        private final /* synthetic */ Delete val$deleteContentInfo;

        3(Delete delete2, int n, Delete delete3) {
            this.val$deleteContentChunk = delete2;
            this.val$id = n;
            this.val$deleteContentInfo = delete3;
        }

        public Boolean useTransaction() {
            if (0 == DatabaseRawStore.this.executeUpdate(this.val$deleteContentChunk, new 1(this.val$id))) {
                return new Boolean(false);
            }
            if (0 == DatabaseRawStore.this.executeUpdate(this.val$deleteContentInfo, new 2(this.val$id))) {
                return new Boolean(false);
            }
            return new Boolean(true);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ DatabaseRawStore access$0(3 var0) {
            return var0.DatabaseRawStore.this;
        }

        class 1
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int val$id;

            1(int n) {
                this.val$id = n;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setInt("contentId", this.val$id);
            }

            static /* synthetic */ 3 access$0(1 var0) {
                return var0.3.this;
            }
        }

        class 2
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int val$id;

            2(int n) {
                this.val$id = n;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setInt("contentId", this.val$id);
            }

            static /* synthetic */ 3 access$0(2 var0) {
                return var0.3.this;
            }
        }
    }

    class 4
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;

        4(int n) {
            this.val$id = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$id);
        }

        static /* synthetic */ DatabaseRawStore access$0(4 var0) {
            return var0.DatabaseRawStore.this;
        }
    }

    class 5
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;

        5(int n) {
            this.val$id = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$id);
        }

        static /* synthetic */ DatabaseRawStore access$0(5 var0) {
            return var0.DatabaseRawStore.this;
        }
    }

    class 7
    extends DbTransactionUser {
        private final /* synthetic */ Insert val$storeContentChunk;
        private final /* synthetic */ int val$id;
        private final /* synthetic */ InputStream val$typed_data;
        private final /* synthetic */ Insert val$storeContentInfo;

        7(Insert insert2, int n, InputStream inputStream, Insert insert3) {
            this.val$storeContentChunk = insert2;
            this.val$id = n;
            this.val$typed_data = inputStream;
            this.val$storeContentInfo = insert3;
        }

        public Object useTransaction() {
            try {
                int size = DatabaseRawStore.this.storeChunks(this.val$storeContentChunk, this.val$id, this.val$typed_data);
                if (size < 0) {
                    this.rollback();
                }
                if (DatabaseRawStore.this.executeUpdate(this.val$storeContentInfo, new 6(this.val$id, size)) <= 0) {
                    this.rollback();
                }
            }
            catch (IOException e) {
                this.throwException(e);
            }
            return new Boolean(true);
        }

        class 6
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int val$id;
            private final /* synthetic */ int val$size;

            6(int n, int n2) {
                this.val$id = n;
                this.val$size = n2;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setInt("contentId", this.val$id).setInt(DatabaseRawStore.this.getContentSizeColumnName(), this.val$size);
            }

            static /* synthetic */ 7 access$0(6 var0) {
                return var0.7.this;
            }
        }
    }

    class 9
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;
        private final /* synthetic */ 8.Scope val$s;

        9(int n, 8.Scope scope) {
            this.val$id = n;
            this.val$s = scope;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$id).setInt("ordinal", this.val$s.ordinal).setBinaryStream("chunk", (InputStream)new ByteArrayInputStream(this.val$s.buffer), this.val$s.length);
        }

        static /* synthetic */ DatabaseRawStore access$0(9 var0) {
            return var0.DatabaseRawStore.this;
        }
    }

    class 10
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;
        private final /* synthetic */ ElementSupport val$element;
        private final /* synthetic */ int val$size;

        10(int n, ElementSupport elementSupport, int n2) {
            this.val$id = n;
            this.val$element = elementSupport;
            this.val$size = n2;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$id);
        }

        public Object concludeResults(DbResultSet resultset) throws SQLException {
            if (!resultset.next()) {
                return new Boolean(false);
            }
            OutputStream os = this.val$element.getOutputStream();
            try {
                DatabaseRawStore.this.serveChunks(resultset, os, this.val$size);
                os.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            return new Boolean(true);
        }

        static /* synthetic */ DatabaseRawStore access$0(10 var0) {
            return var0.DatabaseRawStore.this;
        }
    }
}

