/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.dam.contentstores;

import com.uwyn.rife.cmf.MimeType;
import com.uwyn.rife.cmf.dam.ContentDataUser;
import com.uwyn.rife.cmf.dam.contentstores.DatabaseContentStore;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.StoreContentDataErrorException;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.UseContentDataErrorException;
import com.uwyn.rife.cmf.dao.Content;
import com.uwyn.rife.cmf.dao.ContentInfo;
import com.uwyn.rife.cmf.format.Formatter;
import com.uwyn.rife.cmf.format.exceptions.FormatException;
import com.uwyn.rife.cmf.transform.ContentTransformer;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbResultSet;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.ReadQuery;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.engine.ElementInfo;
import com.uwyn.rife.tools.Convert;
import com.uwyn.rife.tools.StringUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseImageStore
extends DatabaseContentStore {
    private static /* synthetic */ boolean $assertionsDisabled;

    public DatabaseImageStore(Datasource datasource) {
        super(datasource);
        this.addMimeType(MimeType.IMAGE_GIF);
        this.addMimeType(MimeType.IMAGE_JPEG);
        this.addMimeType(MimeType.IMAGE_PNG);
    }

    @Override
    public String getContentType(ContentInfo contentInfo) {
        MimeType mimeType = MimeType.getMimeType(contentInfo.getMimeType());
        if (!this.getSupportedMimeTypes().contains(mimeType)) {
            return null;
        }
        return mimeType.toString();
    }

    @Override
    public Formatter getFormatter(MimeType mimeType, boolean fragment) {
        if (!this.getSupportedMimeTypes().contains(mimeType)) {
            return null;
        }
        return mimeType.getFormatter();
    }

    @Override
    public String getContentForHtml(int id, ContentInfo info, ElementInfo serveContent) {
        StringBuffer result;
        if (serveContent == null) {
            throw new IllegalArgumentException("serveContent can't be null.");
        }
        StringBuffer stringBuffer = result = new StringBuffer();
        synchronized (stringBuffer) {
            result.append("<img src=\"");
            result.append(StringUtils.encodeHtml(new StringBuffer().append(serveContent.getUrl()).append(info.getPath()).toString()));
            result.append("\"");
            Map<String, String> properties = info.getProperties();
            if (properties != null) {
                String height;
                String width = properties.get("cmf:width");
                if (width != null) {
                    result.append(" width=\"");
                    result.append(width);
                    result.append("\"");
                }
                if ((height = properties.get("cmf:height")) != null) {
                    result.append(" height=\"");
                    result.append(height);
                    result.append("\"");
                }
            }
            result.append(" alt=\"\" />");
            return result.toString();
        }
    }

    protected boolean _storeContentData(Insert storeContent, int id, Content content, ContentTransformer transformer) {
        byte[] typed_data;
        if (id < 0) {
            throw new IllegalArgumentException("id must be positive");
        }
        if (content != null && content.getData() != null && !(content.getData() instanceof byte[])) {
            throw new IllegalArgumentException("the content data must be of type byte[]");
        }
        if (!$assertionsDisabled && storeContent == null) {
            throw new AssertionError();
        }
        if (content == null || content.getData() == null) {
            typed_data = null;
        } else {
            Formatter formatter = null;
            if (!Convert.toBoolean(content.getAttribute("unformatted"), false)) {
                formatter = this.getFormatter(content.getMimeType(), content.isFragment());
            }
            if (formatter != null) {
                try {
                    typed_data = (byte[])formatter.format(content, transformer);
                }
                catch (FormatException e) {
                    throw new StoreContentDataErrorException(id, (Throwable)e);
                }
            } else {
                typed_data = (byte[])content.getData();
            }
        }
        return this.storeTypedData(storeContent, id, typed_data);
    }

    protected boolean storeTypedData(Insert storeContent, int id, byte[] data) {
        try {
            int result = this.executeUpdate(storeContent, new 1(id, data));
            return result != -1;
        }
        catch (DatabaseException e) {
            throw new StoreContentDataErrorException(id, (Throwable)e);
        }
    }

    protected <ResultType> ResultType _useContentData(Select retrieveContent, int id, ContentDataUser user) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be positive");
        }
        if (user == null) {
            throw new IllegalArgumentException("user can't be null");
        }
        if (!$assertionsDisabled && retrieveContent == null) {
            throw new AssertionError();
        }
        try {
            return user.useContentData(this.executeQuery((ReadQuery)retrieveContent, new 2(id)));
        }
        catch (DatabaseException e) {
            throw new UseContentDataErrorException(id, (Throwable)e);
        }
    }

    @Override
    protected void outputContentColumn(ResultSet resultSet, OutputStream os) throws SQLException {
        InputStream is = resultSet.getBinaryStream("content");
        byte[] buffer = new byte[512];
        BufferedInputStream buffered_raw_is = new BufferedInputStream(is, 512);
        int size = 0;
        try {
            while ((size = buffered_raw_is.read(buffer)) != -1) {
                os.write(buffer, 0, size);
            }
            os.flush();
        }
        catch (IOException e) {}
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.cmf.dam.contentstores.DatabaseImageStore");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    class 1
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;
        private final /* synthetic */ byte[] val$data;

        1(int n, byte[] byArray) {
            this.val$id = n;
            this.val$data = byArray;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$id);
            if (this.val$data == null) {
                statement.setNull("content", 2004).setInt(DatabaseImageStore.this.getContentSizeColumnName(), 0);
            } else {
                statement.setBinaryStream("content", (InputStream)new ByteArrayInputStream(this.val$data), this.val$data.length).setInt(DatabaseImageStore.this.getContentSizeColumnName(), this.val$data.length);
            }
        }

        static /* synthetic */ DatabaseImageStore access$0(1 var0) {
            return var0.DatabaseImageStore.this;
        }
    }

    class 2
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;

        2(int n) {
            this.val$id = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$id);
        }

        public Object concludeResults(DbResultSet resultset) throws SQLException {
            if (!resultset.next()) {
                return null;
            }
            return resultset.getBytes("content");
        }

        static /* synthetic */ DatabaseImageStore access$0(2 var0) {
            return var0.DatabaseImageStore.this;
        }
    }
}

