/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.dam.contentstores;

import com.uwyn.rife.cmf.MimeType;
import com.uwyn.rife.cmf.dam.ContentStore;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.DeleteContentDataErrorException;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.HasContentDataErrorException;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.InstallContentStoreErrorException;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.RemoveContentStoreErrorException;
import com.uwyn.rife.cmf.dam.contentstores.exceptions.RetrieveSizeErrorException;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.DbRowProcessor;
import com.uwyn.rife.database.DbTransactionUser;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.DropTable;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.engine.ElementSupport;
import com.uwyn.rife.tools.ExceptionUtils;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseContentStore
extends DbQueryManager
implements ContentStore {
    private ArrayList<MimeType> mMimeTypes = new ArrayList();
    private static /* synthetic */ boolean $assertionsDisabled;

    public DatabaseContentStore(Datasource datasource) {
        super(datasource);
    }

    protected void addMimeType(MimeType mimeType) {
        this.mMimeTypes.add(mimeType);
    }

    @Override
    public Collection<MimeType> getSupportedMimeTypes() {
        return this.mMimeTypes;
    }

    protected boolean _install(CreateTable createTableContentStore) {
        if (!$assertionsDisabled && createTableContentStore == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(createTableContentStore);
        }
        catch (DatabaseException e) {
            throw new InstallContentStoreErrorException(e);
        }
        return true;
    }

    protected boolean _remove(DropTable dropTableContentStore) {
        if (!$assertionsDisabled && dropTableContentStore == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(dropTableContentStore);
        }
        catch (DatabaseException e) {
            throw new RemoveContentStoreErrorException(e);
        }
        return true;
    }

    protected boolean _deleteContentData(Delete deleteContentData, int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be positive");
        }
        if (!$assertionsDisabled && deleteContentData == null) {
            throw new AssertionError();
        }
        Boolean result = null;
        try {
            result = (Boolean)this.inTransaction(new 2(deleteContentData, id));
        }
        catch (DatabaseException e) {
            throw new DeleteContentDataErrorException(id, e);
        }
        return result != null && result != false;
    }

    protected int _getSize(Select retrieveSize, int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be positive");
        }
        if (!$assertionsDisabled && retrieveSize == null) {
            throw new AssertionError();
        }
        try {
            return this.executeGetFirstInt(retrieveSize, new 3(id));
        }
        catch (DatabaseException e) {
            throw new RetrieveSizeErrorException(id, e);
        }
    }

    protected boolean _hasContentData(Select hasContentData, int id) {
        if (id < 0) {
            throw new IllegalArgumentException("id must be positive");
        }
        if (!$assertionsDisabled && hasContentData == null) {
            throw new AssertionError();
        }
        try {
            return this.executeHasResultRows(hasContentData, new 4(id));
        }
        catch (DatabaseException e) {
            throw new HasContentDataErrorException(id, e);
        }
    }

    protected String getContentSizeColumnName() {
        return "size";
    }

    protected void _serveContentData(Select retrieveContent, ElementSupport element, int id) {
        if (element == null) {
            throw new IllegalArgumentException("element can't be null");
        }
        if (id < 0) {
            element.setStatus(404);
            return;
        }
        if (!$assertionsDisabled && retrieveContent == null) {
            throw new AssertionError();
        }
        try {
            if (!this.executeFetchFirst(retrieveContent, new 5(element), new 6(id))) {
                element.setStatus(404);
                return;
            }
        }
        catch (DatabaseException e) {
            Logger.getLogger("com.uwyn.rife.cmf").severe(ExceptionUtils.getExceptionStackTrace(e));
            element.setStatus(404);
        }
    }

    protected abstract void outputContentColumn(ResultSet var1, OutputStream var2) throws SQLException;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.cmf.dam.contentstores.DatabaseContentStore");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    class 2
    extends DbTransactionUser {
        private final /* synthetic */ Delete val$deleteContentData;
        private final /* synthetic */ int val$id;

        2(Delete delete2, int n) {
            this.val$deleteContentData = delete2;
            this.val$id = n;
        }

        public Boolean useTransaction() {
            if (0 == DatabaseContentStore.this.executeUpdate(this.val$deleteContentData, new 1(this.val$id))) {
                return new Boolean(false);
            }
            return new Boolean(true);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ DatabaseContentStore access$0(2 var0) {
            return var0.DatabaseContentStore.this;
        }

        class 1
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int val$id;

            1(int n) {
                this.val$id = n;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setInt("contentId", this.val$id);
            }

            static /* synthetic */ 2 access$0(1 var0) {
                return var0.2.this;
            }
        }
    }

    class 3
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;

        3(int n) {
            this.val$id = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$id);
        }

        static /* synthetic */ DatabaseContentStore access$0(3 var0) {
            return var0.DatabaseContentStore.this;
        }
    }

    class 4
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;

        4(int n) {
            this.val$id = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$id);
        }

        static /* synthetic */ DatabaseContentStore access$0(4 var0) {
            return var0.DatabaseContentStore.this;
        }
    }

    class 5
    extends DbRowProcessor {
        private final /* synthetic */ ElementSupport val$element;

        5(ElementSupport elementSupport) {
            this.val$element = elementSupport;
        }

        public boolean processRow(ResultSet resultSet) throws SQLException {
            this.val$element.setContentLength(resultSet.getInt(DatabaseContentStore.this.getContentSizeColumnName()));
            OutputStream os = this.val$element.getOutputStream();
            DatabaseContentStore.this.outputContentColumn(resultSet, os);
            return true;
        }

        static /* synthetic */ DatabaseContentStore access$0(5 var0) {
            return var0.DatabaseContentStore.this;
        }
    }

    class 6
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$id;

        6(int n) {
            this.val$id = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$id);
        }

        static /* synthetic */ DatabaseContentStore access$0(6 var0) {
            return var0.DatabaseContentStore.this;
        }
    }
}

