/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.dam.contentmanagers.databasedrivers;

import com.uwyn.rife.cmf.dam.ContentStore;
import com.uwyn.rife.cmf.dam.contentmanagers.databasedrivers.generic;
import com.uwyn.rife.cmf.dam.contentmanagers.exceptions.InstallContentErrorException;
import com.uwyn.rife.cmf.dam.contentmanagers.exceptions.RemoveContentErrorException;
import com.uwyn.rife.cmf.dam.contentmanagers.exceptions.UnknownContentRepositoryException;
import com.uwyn.rife.cmf.dam.contentmanagers.exceptions.UnsupportedMimeTypeException;
import com.uwyn.rife.cmf.dam.exceptions.ContentManagerException;
import com.uwyn.rife.cmf.dao.Content;
import com.uwyn.rife.cmf.transform.ContentTransformer;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbConnection;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbTransactionUser;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.AbstractWhereGroup;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Query;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.datastructures.Pair;
import com.uwyn.rife.tools.InnerClassException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class org_apache_derby_jdbc_EmbeddedDriver
extends generic {
    public org_apache_derby_jdbc_EmbeddedDriver(Datasource datasource) {
        super(datasource);
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        Class<?> clazz5;
        Class<?> clazz6;
        Class<?> clazz7;
        Class<?> clazz8;
        try {
            clazz8 = Class.forName("com.uwyn.rife.cmf.dao.ContentRepository");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mCreateTableContentRepository = new CreateTable(this.getDatasource()).table(RifeConfig.Cmf.getTableContentRepository()).columns(clazz8).column("repositoryId", Integer.TYPE).customAttribute("repositoryId", "GENERATED ALWAYS AS IDENTITY").primaryKey("PK_CONTENTREP", "repositoryId");
        try {
            clazz7 = Class.forName("com.uwyn.rife.cmf.dam.contentmanagers.DatabaseContentInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mCreateTableContentInfo = new CreateTable(this.getDatasource()).table(RifeConfig.Cmf.getTableContentInfo()).columns(clazz7).column("repositoryId", Integer.TYPE, CreateTable.NOTNULL).defaultFunction("created", "CURRENT_TIMESTAMP").customAttribute("contentId", "GENERATED ALWAYS AS IDENTITY").unique(("UQ_" + RifeConfig.Cmf.getTableContentInfo()).toUpperCase(), new String[]{"repositoryId", "path", "version"}).foreignKey("FK_" + RifeConfig.Cmf.getTableContentInfo(), RifeConfig.Cmf.getTableContentRepository(), "repositoryId", "repositoryId");
        try {
            clazz6 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        try {
            clazz5 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mCreateTableContentAttribute = new CreateTable(this.getDatasource()).table(RifeConfig.Cmf.getTableContentAttribute()).column("contentId", Integer.TYPE, CreateTable.NOTNULL).column("name", clazz6, 255, CreateTable.NOTNULL).column(this.getValueColumnName(), clazz5, 255, CreateTable.NOTNULL).foreignKey("FK_CONTENTATTR", RifeConfig.Cmf.getTableContentInfo(), "contentId", "contentId");
        try {
            clazz4 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        try {
            clazz3 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mCreateTableContentProperty = new CreateTable(this.getDatasource()).table(RifeConfig.Cmf.getTableContentProperty()).column("contentId", Integer.TYPE, CreateTable.NOTNULL).column("name", clazz4, 255, CreateTable.NOTNULL).column(this.getValueColumnName(), clazz3, 255, CreateTable.NOTNULL).foreignKey("FK_CONTENTPROP", RifeConfig.Cmf.getTableContentInfo(), "contentId", "contentId");
        this.mCreateContentInfoPathNameIndex = "CREATE INDEX " + RifeConfig.Cmf.getTableContentInfo() + "_pathnm ON " + RifeConfig.Cmf.getTableContentInfo() + " (path, name)";
        this.mDropContentInfoPathNameIndex = "DROP INDEX " + RifeConfig.Cmf.getTableContentInfo() + "_pathnm";
        this.mGetVersion = (Select)((Select)new Select(this.getDatasource()).from(RifeConfig.Cmf.getTableContentInfo()).field("CASE WHEN MAX(version) IS NULL THEN 0 ELSE MAX(version)+1 END").whereParameter("repositoryId", "=")).whereParameterAnd("path", "=");
        try {
            clazz2 = Class.forName("com.uwyn.rife.cmf.dao.ContentRepository");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mStoreContentRepository = new Insert(this.getDatasource()).into(RifeConfig.Cmf.getTableContentRepository()).fieldsParameters(clazz2);
        try {
            clazz = Class.forName("com.uwyn.rife.cmf.dam.contentmanagers.DatabaseContentInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mStoreContentInfo = new Insert(this.getDatasource()).into(RifeConfig.Cmf.getTableContentInfo()).fieldsParametersExcluded(clazz, new String[]{"contentId"}).fieldParameter("repositoryId").field("version", this.mGetVersion);
        this.mGetLatestContentInfo = ((Select)((AbstractWhereGroup)((AbstractWhereGroup)((AbstractWhereGroup)((AbstractWhereGroup)((Select)((Select)new Select(this.getDatasource()).from(RifeConfig.Cmf.getTableContentInfo()).join(RifeConfig.Cmf.getTableContentRepository()).field(RifeConfig.Cmf.getTableContentInfo() + ".*").where(RifeConfig.Cmf.getTableContentInfo() + ".repositoryId = " + RifeConfig.Cmf.getTableContentRepository() + ".repositoryId")).whereParameterAnd(RifeConfig.Cmf.getTableContentRepository() + ".name", "repository", "=")).startWhereAnd().whereParameter("path", "=")).startWhereOr().whereParameter("path", "pathpart", "=")).whereParameterAnd(RifeConfig.Cmf.getTableContentInfo() + ".name", "namepart", "=")).end()).end()).orderBy("version", Select.DESC);
    }

    public boolean install() {
        try {
            this.executeUpdate(this.mCreateTableContentRepository);
            this.executeUpdate(this.mCreateTableContentInfo);
            this.executeUpdate(this.mCreateTableContentAttribute);
            this.executeUpdate(this.mCreateTableContentProperty);
            this.createRepository("default");
            Iterator iterator = ((Collection)this.mStores).iterator();
            while (iterator.hasNext()) {
                ContentStore store = (ContentStore)iterator.next();
                store.install();
            }
            this.executeUpdate(this.mCreateContentInfoPathIndex);
            this.executeUpdate(this.mCreateContentInfoPathNameIndex);
        }
        catch (DatabaseException e) {
            throw new InstallContentErrorException(e);
        }
        return true;
    }

    public boolean remove() {
        try {
            this.executeUpdate(this.mDropContentInfoPathNameIndex);
            this.executeUpdate(this.mDropContentInfoPathIndex);
            Iterator iterator = ((Collection)this.mStores).iterator();
            while (iterator.hasNext()) {
                ContentStore store = (ContentStore)iterator.next();
                store.remove();
            }
            this.executeUpdate(this.mDropTableContentProperties);
            this.executeUpdate(this.mDropTableContentAttribute);
            this.executeUpdate(this.mDropTableContentInfo);
            this.executeUpdate(this.mDropTableContentRepository);
        }
        catch (DatabaseException e) {
            throw new RemoveContentErrorException(e);
        }
        return true;
    }

    public boolean createRepository(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty");
        }
        Boolean result = null;
        try {
            result = (Boolean)this.inTransaction(new 2(name));
        }
        catch (InnerClassException e) {
            throw (ContentManagerException)e.getCause();
        }
        return result != null && result != false;
    }

    public boolean storeContent(String location, Content content, ContentTransformer transformer) {
        if (content == null) {
            throw new IllegalArgumentException("content can't be null");
        }
        Pair<String, String> split_location = this.splitLocation(location);
        ContentStore store = this.mMimeMapping.get(content.getMimeType());
        if (store == null) {
            throw new UnsupportedMimeTypeException(content.getMimeType());
        }
        Boolean result = null;
        try {
            result = (Boolean)this.inTransaction(new 7(split_location, content, store, transformer));
        }
        catch (InnerClassException e) {
            throw (ContentManagerException)e.getCause();
        }
        return result != null && result != false;
    }

    static /* synthetic */ ArrayList access$Lcom$uwyn$rife$cmf$dam$contentmanagers$DatabaseContent$1(org_apache_derby_jdbc_EmbeddedDriver org_apache_derby_jdbc_EmbeddedDriver2) {
        return org_apache_derby_jdbc_EmbeddedDriver2.mStores;
    }

    static /* synthetic */ void access$Scom$uwyn$rife$cmf$dam$contentmanagers$DatabaseContent$1(org_apache_derby_jdbc_EmbeddedDriver org_apache_derby_jdbc_EmbeddedDriver2, ArrayList arrayList) {
        org_apache_derby_jdbc_EmbeddedDriver2.mStores = arrayList;
    }

    static /* synthetic */ HashMap access$Lcom$uwyn$rife$cmf$dam$contentmanagers$DatabaseContent$2(org_apache_derby_jdbc_EmbeddedDriver org_apache_derby_jdbc_EmbeddedDriver2) {
        return org_apache_derby_jdbc_EmbeddedDriver2.mMimeMapping;
    }

    static /* synthetic */ void access$Scom$uwyn$rife$cmf$dam$contentmanagers$DatabaseContent$2(org_apache_derby_jdbc_EmbeddedDriver org_apache_derby_jdbc_EmbeddedDriver2, HashMap hashMap) {
        org_apache_derby_jdbc_EmbeddedDriver2.mMimeMapping = hashMap;
    }

    class 2
    extends DbTransactionUser {
        private final /* synthetic */ String val$name;

        2(String string) {
            this.val$name = string;
        }

        public Boolean useTransaction() {
            return new Boolean(org_apache_derby_jdbc_EmbeddedDriver.this.executeUpdate(org_apache_derby_jdbc_EmbeddedDriver.this.mStoreContentRepository, new 1(this.val$name)) > 0);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ org_apache_derby_jdbc_EmbeddedDriver access$0(2 var0) {
            return var0.org_apache_derby_jdbc_EmbeddedDriver.this;
        }

        class 1
        extends DbPreparedStatementHandler {
            private final /* synthetic */ String val$name;

            1(String string) {
                this.val$name = string;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setString("name", this.val$name);
            }

            static /* synthetic */ 2 access$0(1 var0) {
                return var0.2.this;
            }
        }
    }

    class 7
    extends DbTransactionUser {
        private final /* synthetic */ Pair val$split_location;
        private final /* synthetic */ Content val$content;
        private final /* synthetic */ ContentStore val$store;
        private final /* synthetic */ ContentTransformer val$transformer;

        7(Pair pair, Content content, ContentStore contentStore, ContentTransformer contentTransformer) {
            this.val$split_location = pair;
            this.val$content = content;
            this.val$store = contentStore;
            this.val$transformer = contentTransformer;
        }

        public Boolean useTransaction() {
            int[] ids_array;
            int repository_id = org_apache_derby_jdbc_EmbeddedDriver.this.executeGetFirstInt(org_apache_derby_jdbc_EmbeddedDriver.this.mGetContentRepositoryId, new 3(this.val$split_location));
            if (-1 == repository_id) {
                this.throwException(new UnknownContentRepositoryException((String)this.val$split_location.getFirst()));
            }
            if (org_apache_derby_jdbc_EmbeddedDriver.this.executeUpdate(org_apache_derby_jdbc_EmbeddedDriver.this.mStoreContentInfo, new 4(repository_id, this.val$split_location, this.val$content, ids_array = new int[1])) > 0) {
                String value;
                String name;
                Iterator iterator;
                if (this.val$content.hasAttributes()) {
                    iterator = ((Collection)this.val$content.getAttributes().entrySet()).iterator();
                    while (iterator.hasNext()) {
                        Map.Entry attribute = (Map.Entry)iterator.next();
                        name = (String)attribute.getKey();
                        value = (String)attribute.getValue();
                        org_apache_derby_jdbc_EmbeddedDriver.this.executeUpdate(org_apache_derby_jdbc_EmbeddedDriver.this.mStoreContentAttribute, new 5(ids_array, name, value));
                    }
                }
                try {
                    if (!this.val$store.storeContentData(ids_array[0], this.val$content, this.val$transformer)) {
                        this.rollback();
                    }
                }
                catch (ContentManagerException e) {
                    this.throwException(e);
                }
                if (this.val$content.hasProperties()) {
                    iterator = ((Collection)this.val$content.getProperties().entrySet()).iterator();
                    while (iterator.hasNext()) {
                        Map.Entry property = (Map.Entry)iterator.next();
                        name = (String)property.getKey();
                        value = (String)property.getValue();
                        org_apache_derby_jdbc_EmbeddedDriver.this.executeUpdate(org_apache_derby_jdbc_EmbeddedDriver.this.mStoreContentProperty, new 6(ids_array, name, value));
                    }
                }
                return new Boolean(true);
            }
            return new Boolean(false);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        class 3
        extends DbPreparedStatementHandler {
            private final /* synthetic */ Pair val$split_location;

            3(Pair pair) {
                this.val$split_location = pair;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setString("repository", (String)this.val$split_location.getFirst());
            }

            static /* synthetic */ 7 access$0(3 var0) {
                return var0.7.this;
            }
        }

        class 4
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int val$repository_id;
            private final /* synthetic */ Pair val$split_location;
            private final /* synthetic */ Content val$content;
            private final /* synthetic */ int[] val$ids_array;

            4(int n, Pair pair, Content content, int[] nArray) {
                this.val$repository_id = n;
                this.val$split_location = pair;
                this.val$content = content;
                this.val$ids_array = nArray;
            }

            public DbPreparedStatement getPreparedStatement(Query query, DbConnection connection) {
                return connection.getPreparedStatement(query, 1);
            }

            public int performUpdate(DbPreparedStatement statement) {
                statement.setInt("repositoryId", this.val$repository_id).setString("path", (String)this.val$split_location.getSecond()).setString("mimeType", this.val$content.getMimeType().toString()).setBoolean("fragment", this.val$content.isFragment());
                if (this.val$content.hasName()) {
                    statement.setString("name", this.val$content.getName());
                } else {
                    statement.setNull("name", 12);
                }
                int query_result = statement.executeUpdate();
                this.val$ids_array[0] = statement.getFirstGeneratedIntKey();
                return query_result;
            }

            static /* synthetic */ 7 access$0(4 var0) {
                return var0.7.this;
            }
        }

        class 5
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int[] val$ids_array;
            private final /* synthetic */ String val$name;
            private final /* synthetic */ String val$value;

            5(int[] nArray, String string, String string2) {
                this.val$ids_array = nArray;
                this.val$name = string;
                this.val$value = string2;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setInt("contentId", this.val$ids_array[0]).setString("name", this.val$name).setString(org_apache_derby_jdbc_EmbeddedDriver.this.getValueColumnName(), this.val$value);
            }

            static /* synthetic */ 7 access$0(5 var0) {
                return var0.7.this;
            }
        }

        class 6
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int[] val$ids_array;
            private final /* synthetic */ String val$name;
            private final /* synthetic */ String val$value;

            6(int[] nArray, String string, String string2) {
                this.val$ids_array = nArray;
                this.val$name = string;
                this.val$value = string2;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setInt("contentId", this.val$ids_array[0]).setString("name", this.val$name).setString(org_apache_derby_jdbc_EmbeddedDriver.this.getValueColumnName(), this.val$value);
            }

            static /* synthetic */ 7 access$0(6 var0) {
                return var0.7.this;
            }
        }
    }
}

