/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf.dam.contentmanagers.databasedrivers;

import com.uwyn.rife.cmf.dam.ContentStore;
import com.uwyn.rife.cmf.dam.contentmanagers.databasedrivers.generic;
import com.uwyn.rife.cmf.dam.contentmanagers.exceptions.InstallContentErrorException;
import com.uwyn.rife.cmf.dam.contentmanagers.exceptions.RemoveContentErrorException;
import com.uwyn.rife.cmf.dam.contentmanagers.exceptions.UnknownContentRepositoryException;
import com.uwyn.rife.cmf.dam.contentmanagers.exceptions.UnsupportedMimeTypeException;
import com.uwyn.rife.cmf.dam.exceptions.ContentManagerException;
import com.uwyn.rife.cmf.dao.Content;
import com.uwyn.rife.cmf.transform.ContentTransformer;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbConnection;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbTransactionUser;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Query;
import com.uwyn.rife.datastructures.Pair;
import com.uwyn.rife.tools.InnerClassException;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class com_mysql_jdbc_Driver
extends generic {
    private static final Object sVersionMonitor = new Object();

    public com_mysql_jdbc_Driver(Datasource datasource) {
        super(datasource);
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        Class<?> clazz4;
        try {
            clazz4 = Class.forName("com.uwyn.rife.cmf.dao.ContentRepository");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mCreateTableContentRepository = new CreateTable(this.getDatasource()).table(RifeConfig.Cmf.getTableContentRepository()).columns(clazz4).column("repositoryId", Integer.TYPE).customAttribute("repositoryId", "AUTO_INCREMENT").primaryKey("PK_" + RifeConfig.Cmf.getTableContentRepository(), "repositoryId");
        try {
            clazz3 = Class.forName("com.uwyn.rife.cmf.dam.contentmanagers.DatabaseContentInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mCreateTableContentInfo = new CreateTable(this.getDatasource()).table(RifeConfig.Cmf.getTableContentInfo()).columns(clazz3).column("repositoryId", Integer.TYPE, CreateTable.NOTNULL).customAttribute("contentId", "AUTO_INCREMENT").unique(("UQ_" + RifeConfig.Cmf.getTableContentInfo()).toUpperCase(), new String[]{"repositoryId", "path", "version"}).foreignKey("FK_" + RifeConfig.Cmf.getTableContentInfo() + "_REPOSITORYID", RifeConfig.Cmf.getTableContentRepository(), "repositoryId", "repositoryId");
        this.mDropContentInfoPathIndex = "DROP INDEX " + RifeConfig.Cmf.getTableContentInfo() + "_path ON " + RifeConfig.Cmf.getTableContentInfo();
        this.mDropContentInfoPathNameIndex = "DROP INDEX " + RifeConfig.Cmf.getTableContentInfo() + "_pathname ON " + RifeConfig.Cmf.getTableContentInfo();
        try {
            clazz2 = Class.forName("com.uwyn.rife.cmf.dao.ContentRepository");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mStoreContentRepository = new Insert(this.getDatasource()).into(RifeConfig.Cmf.getTableContentRepository()).fieldsParameters(clazz2);
        try {
            clazz = Class.forName("com.uwyn.rife.cmf.dam.contentmanagers.DatabaseContentInfo");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mStoreContentInfo = new Insert(this.getDatasource()).into(RifeConfig.Cmf.getTableContentInfo()).fieldsParametersExcluded(clazz, new String[]{"contentId"}).fieldParameter("repositoryId").fieldParameter("version").fieldParameter("created");
    }

    public boolean install() {
        try {
            this.executeUpdate(this.mCreateTableContentRepository);
            this.executeUpdate(this.mCreateTableContentInfo);
            this.executeUpdate(this.mCreateTableContentAttribute);
            this.executeUpdate(this.mCreateTableContentProperty);
            this.createRepository("default");
            Iterator iterator = ((Collection)this.mStores).iterator();
            while (iterator.hasNext()) {
                ContentStore store = (ContentStore)iterator.next();
                store.install();
            }
            this.executeUpdate(this.mCreateContentInfoPathIndex);
            this.executeUpdate(this.mCreateContentInfoPathNameIndex);
        }
        catch (DatabaseException e) {
            throw new InstallContentErrorException(e);
        }
        return true;
    }

    public boolean remove() {
        try {
            this.executeUpdate(this.mDropContentInfoPathNameIndex);
            this.executeUpdate(this.mDropContentInfoPathIndex);
            Iterator iterator = ((Collection)this.mStores).iterator();
            while (iterator.hasNext()) {
                ContentStore store = (ContentStore)iterator.next();
                store.remove();
            }
            this.executeUpdate(this.mDropTableContentProperties);
            this.executeUpdate(this.mDropTableContentAttribute);
            this.executeUpdate(this.mDropTableContentInfo);
            this.executeUpdate(this.mDropTableContentRepository);
        }
        catch (DatabaseException e) {
            throw new RemoveContentErrorException(e);
        }
        return true;
    }

    public boolean createRepository(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        if (0 == name.length()) {
            throw new IllegalArgumentException("name can't be empty");
        }
        Boolean result = null;
        try {
            result = (Boolean)this.inTransaction(new 2(name));
        }
        catch (InnerClassException e) {
            throw (ContentManagerException)e.getCause();
        }
        return result != null && result != false;
    }

    public boolean storeContent(String location, Content content, ContentTransformer transformer) {
        if (content == null) {
            throw new IllegalArgumentException("content can't be null");
        }
        Pair<String, String> split_location = this.splitLocation(location);
        ContentStore store = this.mMimeMapping.get(content.getMimeType());
        if (store == null) {
            throw new UnsupportedMimeTypeException(content.getMimeType());
        }
        Object object = sVersionMonitor;
        synchronized (object) {
            int[] ids_array;
            int repository_id = this.executeGetFirstInt(this.mGetContentRepositoryId, new 3(split_location));
            if (-1 == repository_id) {
                throw new UnknownContentRepositoryException(split_location.getFirst());
            }
            int version = this.executeGetFirstInt(this.mGetVersion, new 4(repository_id, split_location));
            if (this.executeUpdate(this.mStoreContentInfo, new 5(split_location, content, repository_id, version, ids_array = new int[1])) > 0) {
                String value;
                String name;
                Iterator iterator;
                if (content.hasAttributes()) {
                    iterator = ((Collection)content.getAttributes().entrySet()).iterator();
                    while (iterator.hasNext()) {
                        Map.Entry attribute = (Map.Entry)iterator.next();
                        name = (String)attribute.getKey();
                        value = (String)attribute.getValue();
                        this.executeUpdate(this.mStoreContentAttribute, new 6(ids_array, name, value));
                    }
                }
                if (!store.storeContentData(ids_array[0], content, transformer)) {
                    return false;
                }
                if (content.hasProperties()) {
                    iterator = ((Collection)content.getProperties().entrySet()).iterator();
                    while (iterator.hasNext()) {
                        Map.Entry property = (Map.Entry)iterator.next();
                        name = (String)property.getKey();
                        value = (String)property.getValue();
                        this.executeUpdate(this.mStoreContentProperty, new 7(ids_array, name, value));
                    }
                }
                return true;
            }
            return false;
        }
    }

    static /* synthetic */ ArrayList access$Lcom$uwyn$rife$cmf$dam$contentmanagers$DatabaseContent$1(com_mysql_jdbc_Driver com_mysql_jdbc_Driver2) {
        return com_mysql_jdbc_Driver2.mStores;
    }

    static /* synthetic */ void access$Scom$uwyn$rife$cmf$dam$contentmanagers$DatabaseContent$1(com_mysql_jdbc_Driver com_mysql_jdbc_Driver2, ArrayList arrayList) {
        com_mysql_jdbc_Driver2.mStores = arrayList;
    }

    static /* synthetic */ HashMap access$Lcom$uwyn$rife$cmf$dam$contentmanagers$DatabaseContent$2(com_mysql_jdbc_Driver com_mysql_jdbc_Driver2) {
        return com_mysql_jdbc_Driver2.mMimeMapping;
    }

    static /* synthetic */ void access$Scom$uwyn$rife$cmf$dam$contentmanagers$DatabaseContent$2(com_mysql_jdbc_Driver com_mysql_jdbc_Driver2, HashMap hashMap) {
        com_mysql_jdbc_Driver2.mMimeMapping = hashMap;
    }

    class 2
    extends DbTransactionUser {
        private final /* synthetic */ String val$name;

        2(String string) {
            this.val$name = string;
        }

        public Boolean useTransaction() {
            return new Boolean(com_mysql_jdbc_Driver.this.executeUpdate(com_mysql_jdbc_Driver.this.mStoreContentRepository, new 1(this.val$name)) > 0);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(2 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }

        class 1
        extends DbPreparedStatementHandler {
            private final /* synthetic */ String val$name;

            1(String string) {
                this.val$name = string;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setString("name", this.val$name);
            }

            static /* synthetic */ 2 access$0(1 var0) {
                return var0.2.this;
            }
        }
    }

    class 3
    extends DbPreparedStatementHandler {
        private final /* synthetic */ Pair val$split_location;

        3(Pair pair) {
            this.val$split_location = pair;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("repository", (String)this.val$split_location.getFirst());
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(3 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 4
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$repository_id;
        private final /* synthetic */ Pair val$split_location;

        4(int n, Pair pair) {
            this.val$repository_id = n;
            this.val$split_location = pair;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("repositoryId", this.val$repository_id).setString("path", (String)this.val$split_location.getSecond());
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(4 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 5
    extends DbPreparedStatementHandler {
        private final /* synthetic */ Pair val$split_location;
        private final /* synthetic */ Content val$content;
        private final /* synthetic */ int val$repository_id;
        private final /* synthetic */ int val$version;
        private final /* synthetic */ int[] val$ids_array;

        5(Pair pair, Content content, int n, int n2, int[] nArray) {
            this.val$split_location = pair;
            this.val$content = content;
            this.val$repository_id = n;
            this.val$version = n2;
            this.val$ids_array = nArray;
        }

        public DbPreparedStatement getPreparedStatement(Query query, DbConnection connection) {
            return connection.getPreparedStatement(query, 1);
        }

        public int performUpdate(DbPreparedStatement statement) {
            statement.setString("path", (String)this.val$split_location.getSecond()).setString("mimeType", this.val$content.getMimeType().toString()).setBoolean("fragment", this.val$content.isFragment()).setDate("created", new Date(Calendar.getInstance().getTime().getTime())).setInt("repositoryId", this.val$repository_id).setInt("version", this.val$version);
            if (this.val$content.hasName()) {
                statement.setString("name", this.val$content.getName());
            } else {
                statement.setNull("name", 12);
            }
            int query_result = statement.executeUpdate();
            this.val$ids_array[0] = statement.getFirstGeneratedIntKey();
            return query_result;
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(5 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 6
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int[] val$ids_array;
        private final /* synthetic */ String val$name;
        private final /* synthetic */ String val$value;

        6(int[] nArray, String string, String string2) {
            this.val$ids_array = nArray;
            this.val$name = string;
            this.val$value = string2;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$ids_array[0]).setString("name", this.val$name).setString(com_mysql_jdbc_Driver.this.getValueColumnName(), this.val$value);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(6 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 7
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int[] val$ids_array;
        private final /* synthetic */ String val$name;
        private final /* synthetic */ String val$value;

        7(int[] nArray, String string, String string2) {
            this.val$ids_array = nArray;
            this.val$name = string;
            this.val$value = string2;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("contentId", this.val$ids_array[0]).setString("name", this.val$name).setString(com_mysql_jdbc_Driver.this.getValueColumnName(), this.val$value);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(7 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }
}

