/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.cmf;

import com.uwyn.rife.cmf.CmfProperty;
import com.uwyn.rife.cmf.format.Formatter;
import com.uwyn.rife.cmf.format.ImageFormatter;
import com.uwyn.rife.cmf.format.PlainTextFormatter;
import com.uwyn.rife.cmf.format.RawFormatter;
import com.uwyn.rife.cmf.format.XhtmlFormatter;
import com.uwyn.rife.cmf.validation.CmfPropertyValidationRule;
import com.uwyn.rife.cmf.validation.SupportedImage;
import com.uwyn.rife.cmf.validation.SupportedXhtml;
import com.uwyn.rife.datastructures.EnumClass;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MimeType
extends EnumClass<String> {
    public static final MimeType APPLICATION_XHTML = new 1("application/xhtml+xml");
    public static final MimeType IMAGE_GIF = new 2("image/gif");
    public static final MimeType IMAGE_JPEG = new 3("image/jpeg");
    public static final MimeType IMAGE_PNG = new 4("image/png");
    public static final MimeType TEXT_PLAIN = new 5("text/plain");
    public static final MimeType TEXT_XML = new 6("text/xml");
    public static final MimeType RAW = new 7("raw");

    public abstract CmfPropertyValidationRule getValidationRule(CmfProperty var1);

    public abstract Formatter getFormatter();

    public static MimeType getMimeType(String identifier) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.cmf.MimeType");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (MimeType)EnumClass.getMember(clazz, identifier);
    }

    MimeType(String identifier) {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.cmf.MimeType");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        super(clazz, identifier);
    }

    class 1
    extends MimeType {
        1(String string) {
            super(string);
        }

        public CmfPropertyValidationRule getValidationRule(CmfProperty constrainedProperty) {
            return new SupportedXhtml(constrainedProperty.getPropertyName(), constrainedProperty.isFragment());
        }

        public Formatter getFormatter() {
            return new XhtmlFormatter();
        }
    }

    class 2
    extends MimeType {
        2(String string) {
            super(string);
        }

        public CmfPropertyValidationRule getValidationRule(CmfProperty constrainedProperty) {
            return new SupportedImage(constrainedProperty.getPropertyName());
        }

        public Formatter getFormatter() {
            return new ImageFormatter();
        }
    }

    class 3
    extends MimeType {
        3(String string) {
            super(string);
        }

        public CmfPropertyValidationRule getValidationRule(CmfProperty constrainedProperty) {
            return new SupportedImage(constrainedProperty.getPropertyName());
        }

        public Formatter getFormatter() {
            return new ImageFormatter();
        }
    }

    class 4
    extends MimeType {
        4(String string) {
            super(string);
        }

        public CmfPropertyValidationRule getValidationRule(CmfProperty constrainedProperty) {
            return new SupportedImage(constrainedProperty.getPropertyName());
        }

        public Formatter getFormatter() {
            return new ImageFormatter();
        }
    }

    class 5
    extends MimeType {
        5(String string) {
            super(string);
        }

        public CmfPropertyValidationRule getValidationRule(CmfProperty constrainedProperty) {
            return null;
        }

        public Formatter getFormatter() {
            return new PlainTextFormatter();
        }
    }

    class 6
    extends MimeType {
        6(String string) {
            super(string);
        }

        public CmfPropertyValidationRule getValidationRule(CmfProperty constrainedProperty) {
            return null;
        }

        public Formatter getFormatter() {
            return new PlainTextFormatter();
        }
    }

    class 7
    extends MimeType {
        7(String string) {
            super(string);
        }

        public CmfPropertyValidationRule getValidationRule(CmfProperty constrainedProperty) {
            return null;
        }

        public Formatter getFormatter() {
            return new RawFormatter();
        }
    }
}

