/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.sessionmanagers;

import com.uwyn.rife.authentication.ListSessions;
import com.uwyn.rife.authentication.SessionManager;
import com.uwyn.rife.authentication.exceptions.SessionManagerException;
import com.uwyn.rife.authentication.sessionmanagers.exceptions.ContinueSessionErrorException;
import com.uwyn.rife.authentication.sessionmanagers.exceptions.CountSessionsErrorException;
import com.uwyn.rife.authentication.sessionmanagers.exceptions.EraseAllSessionsErrorException;
import com.uwyn.rife.authentication.sessionmanagers.exceptions.EraseSessionErrorException;
import com.uwyn.rife.authentication.sessionmanagers.exceptions.EraseUserSessionsErrorException;
import com.uwyn.rife.authentication.sessionmanagers.exceptions.GetSessionUserIdErrorException;
import com.uwyn.rife.authentication.sessionmanagers.exceptions.IsSessionValidErrorException;
import com.uwyn.rife.authentication.sessionmanagers.exceptions.PurgeSessionsErrorException;
import com.uwyn.rife.authentication.sessionmanagers.exceptions.SessionRememberedCheckErrorException;
import com.uwyn.rife.authentication.sessionmanagers.exceptions.StartSessionErrorException;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.DbRowProcessor;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.DropTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.database.queries.Update;
import com.uwyn.rife.tools.UniqueID;
import com.uwyn.rife.tools.UniqueIDGenerator;
import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class DatabaseSessions
extends DbQueryManager
implements SessionManager {
    private long mSessionDuration = RifeConfig.Authentication.getSessionDuration();
    private static /* synthetic */ boolean $assertionsDisabled;

    protected DatabaseSessions(Datasource datasource) {
        super(datasource);
    }

    public long getSessionDuration() {
        return this.mSessionDuration;
    }

    public void setSessionDuration(long milliseconds) {
        this.mSessionDuration = milliseconds;
    }

    public abstract boolean install() throws SessionManagerException;

    public abstract boolean remove() throws SessionManagerException;

    public abstract long countSessions() throws SessionManagerException;

    protected boolean _install(CreateTable createAuthentication, String createAuthenticationSessStartIndex) throws SessionManagerException {
        if (!$assertionsDisabled && createAuthentication == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && createAuthenticationSessStartIndex == null) {
            throw new AssertionError();
        }
        this.executeUpdate(createAuthentication);
        this.executeUpdate(createAuthenticationSessStartIndex);
        return true;
    }

    protected boolean _remove(DropTable removeAuthentication, String removeAuthenticationSessStartIndex) throws SessionManagerException {
        if (!$assertionsDisabled && removeAuthentication == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && removeAuthenticationSessStartIndex == null) {
            throw new AssertionError();
        }
        this.executeUpdate(removeAuthenticationSessStartIndex);
        this.executeUpdate(removeAuthentication);
        return true;
    }

    protected void _purgeSessions(Delete purgeSession) throws SessionManagerException {
        try {
            this.executeUpdate(purgeSession, new 1());
        }
        catch (DatabaseException e) {
            throw new PurgeSessionsErrorException(e);
        }
    }

    protected String _startSession(Insert startSession, long userId, String hostIp, boolean remembered) throws SessionManagerException {
        if (!$assertionsDisabled && startSession == null) {
            throw new AssertionError();
        }
        if (userId < (long)0 || hostIp == null || 0 == hostIp.length()) {
            throw new StartSessionErrorException(userId, hostIp);
        }
        UniqueID auth_id = UniqueIDGenerator.generate(hostIp);
        String auth_id_string = auth_id.toString();
        try {
            if (0 == this.executeUpdate(startSession, new 2(auth_id_string, userId, hostIp, remembered))) {
                throw new StartSessionErrorException(userId, hostIp);
            }
        }
        catch (DatabaseException e) {
            throw new StartSessionErrorException(userId, hostIp, e);
        }
        return auth_id_string;
    }

    protected boolean _isSessionValid(Select sessionValidity, String authId, String hostIp) throws SessionManagerException {
        if (!$assertionsDisabled && sessionValidity == null) {
            throw new AssertionError();
        }
        if (authId == null || 0 == authId.length() || hostIp == null || 0 == hostIp.length()) {
            return false;
        }
        boolean result = false;
        try {
            result = this.executeHasResultRows(sessionValidity, new 3(authId, hostIp));
        }
        catch (DatabaseException e) {
            throw new IsSessionValidErrorException(authId, hostIp, e);
        }
        return result;
    }

    public boolean _continueSession(Update continueSession, String authId) throws SessionManagerException {
        if (!$assertionsDisabled && continueSession == null) {
            throw new AssertionError();
        }
        if (authId == null || 0 == authId.length()) {
            return false;
        }
        boolean result = false;
        try {
            if (0 != this.executeUpdate(continueSession, new 4(authId))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new ContinueSessionErrorException(authId, e);
        }
        return result;
    }

    protected boolean _eraseSession(Delete eraseSession, String authId) throws SessionManagerException {
        if (!$assertionsDisabled && eraseSession == null) {
            throw new AssertionError();
        }
        if (authId == null || 0 == authId.length()) {
            return false;
        }
        boolean result = false;
        try {
            if (0 != this.executeUpdate(eraseSession, new 5(authId))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new EraseSessionErrorException(authId, e);
        }
        return result;
    }

    protected boolean _wasRemembered(Select wasRemembered, String authId) throws SessionManagerException {
        if (!$assertionsDisabled && wasRemembered == null) {
            throw new AssertionError();
        }
        if (authId == null || 0 == authId.length()) {
            return false;
        }
        boolean result = false;
        try {
            result = this.executeGetFirstBoolean(wasRemembered, new 6(authId));
        }
        catch (DatabaseException e) {
            throw new SessionRememberedCheckErrorException(authId, e);
        }
        return result;
    }

    protected boolean _eraseUserSessions(Delete eraseUserSessions, long userId) throws SessionManagerException {
        if (!$assertionsDisabled && eraseUserSessions == null) {
            throw new AssertionError();
        }
        if (userId < (long)0) {
            return false;
        }
        boolean result = false;
        try {
            if (0 != this.executeUpdate(eraseUserSessions, new 7(userId))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new EraseUserSessionsErrorException(userId, e);
        }
        return result;
    }

    protected void _eraseAllSessions(Delete eraseAllSessions) throws SessionManagerException {
        if (!$assertionsDisabled && eraseAllSessions == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(eraseAllSessions);
        }
        catch (DatabaseException e) {
            throw new EraseAllSessionsErrorException(e);
        }
    }

    protected long _countSessions(Select countSessions) throws SessionManagerException {
        if (!$assertionsDisabled && countSessions == null) {
            throw new AssertionError();
        }
        long result = -1;
        try {
            result = this.executeGetFirstLong(countSessions, new 8());
        }
        catch (DatabaseException e) {
            throw new CountSessionsErrorException(e);
        }
        return result;
    }

    protected long _getSessionUserId(Select getSessionUserId, String authId) throws SessionManagerException {
        if (!$assertionsDisabled && getSessionUserId == null) {
            throw new AssertionError();
        }
        if (authId == null || 0 == authId.length()) {
            return -1;
        }
        long result = -1;
        try {
            result = this.executeGetFirstLong(getSessionUserId, new 9(authId));
        }
        catch (DatabaseException e) {
            throw new GetSessionUserIdErrorException(authId, e);
        }
        return result;
    }

    protected boolean _listSessions(Select listSessions, ListSessions processor) throws SessionManagerException {
        if (processor == null) {
            throw new IllegalArgumentException("processor can't be null");
        }
        boolean result = false;
        try {
            result = this.executeFetchAll(listSessions, new 10(processor), new 11());
        }
        catch (DatabaseException e) {
            throw new CountSessionsErrorException(e);
        }
        return result;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.authentication.sessionmanagers.DatabaseSessions");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    class 1
    extends DbPreparedStatementHandler {
        1() {
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong(1, System.currentTimeMillis() - DatabaseSessions.this.getSessionDuration());
        }

        static /* synthetic */ DatabaseSessions access$0(1 var0) {
            return var0.DatabaseSessions.this;
        }
    }

    class 2
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$auth_id_string;
        private final /* synthetic */ long val$userId;
        private final /* synthetic */ String val$hostIp;
        private final /* synthetic */ boolean val$remembered;

        2(String string, long l, String string2, boolean bl) {
            this.val$auth_id_string = string;
            this.val$userId = l;
            this.val$hostIp = string2;
            this.val$remembered = bl;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("authId", this.val$auth_id_string).setLong("userId", this.val$userId).setString("hostIp", this.val$hostIp).setLong("sessStart", System.currentTimeMillis()).setBoolean("remembered", this.val$remembered);
        }

        static /* synthetic */ DatabaseSessions access$0(2 var0) {
            return var0.DatabaseSessions.this;
        }
    }

    class 3
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$authId;
        private final /* synthetic */ String val$hostIp;

        3(String string, String string2) {
            this.val$authId = string;
            this.val$hostIp = string2;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("authId", this.val$authId).setString("hostIp", this.val$hostIp).setLong("sessStart", System.currentTimeMillis() - DatabaseSessions.this.getSessionDuration());
        }

        static /* synthetic */ DatabaseSessions access$0(3 var0) {
            return var0.DatabaseSessions.this;
        }
    }

    class 4
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$authId;

        4(String string) {
            this.val$authId = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("sessStart", System.currentTimeMillis()).setString("authId", this.val$authId);
        }

        static /* synthetic */ DatabaseSessions access$0(4 var0) {
            return var0.DatabaseSessions.this;
        }
    }

    class 5
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$authId;

        5(String string) {
            this.val$authId = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("authId", this.val$authId);
        }

        static /* synthetic */ DatabaseSessions access$0(5 var0) {
            return var0.DatabaseSessions.this;
        }
    }

    class 6
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$authId;

        6(String string) {
            this.val$authId = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("authId", this.val$authId);
        }

        static /* synthetic */ DatabaseSessions access$0(6 var0) {
            return var0.DatabaseSessions.this;
        }
    }

    class 7
    extends DbPreparedStatementHandler {
        private final /* synthetic */ long val$userId;

        7(long l) {
            this.val$userId = l;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("userId", this.val$userId);
        }

        static /* synthetic */ DatabaseSessions access$0(7 var0) {
            return var0.DatabaseSessions.this;
        }
    }

    class 8
    extends DbPreparedStatementHandler {
        8() {
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("sessStart", System.currentTimeMillis() - DatabaseSessions.this.getSessionDuration());
        }

        static /* synthetic */ DatabaseSessions access$0(8 var0) {
            return var0.DatabaseSessions.this;
        }
    }

    class 9
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$authId;

        9(String string) {
            this.val$authId = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("authId", this.val$authId);
        }

        static /* synthetic */ DatabaseSessions access$0(9 var0) {
            return var0.DatabaseSessions.this;
        }
    }

    class 10
    extends DbRowProcessor {
        private final /* synthetic */ ListSessions val$processor;

        10(ListSessions listSessions) {
            this.val$processor = listSessions;
        }

        public boolean processRow(ResultSet resultSet) throws SQLException {
            return this.val$processor.foundSession(resultSet.getInt("userId"), resultSet.getString("hostIp"), resultSet.getString("authId"));
        }

        static /* synthetic */ DatabaseSessions access$0(10 var0) {
            return var0.DatabaseSessions.this;
        }
    }

    class 11
    extends DbPreparedStatementHandler {
        11() {
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("sessStart", System.currentTimeMillis() - DatabaseSessions.this.getSessionDuration());
        }

        static /* synthetic */ DatabaseSessions access$0(11 var0) {
            return var0.DatabaseSessions.this;
        }
    }
}

