/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.remembermanagers;

import com.uwyn.rife.authentication.RememberManager;
import com.uwyn.rife.authentication.exceptions.RememberManagerException;
import com.uwyn.rife.authentication.remembermanagers.exceptions.CreateRememberIdErrorException;
import com.uwyn.rife.authentication.remembermanagers.exceptions.EraseAllRememberIdsErrorException;
import com.uwyn.rife.authentication.remembermanagers.exceptions.EraseRememberIdErrorException;
import com.uwyn.rife.authentication.remembermanagers.exceptions.EraseUserRememberIdsErrorException;
import com.uwyn.rife.authentication.remembermanagers.exceptions.GetRememberedUserIdErrorException;
import com.uwyn.rife.authentication.remembermanagers.exceptions.PurgeRememberIdsErrorException;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.DropTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.tools.StringEncryptor;
import com.uwyn.rife.tools.UniqueID;
import com.uwyn.rife.tools.UniqueIDGenerator;
import java.security.NoSuchAlgorithmException;

public abstract class DatabaseRemember
extends DbQueryManager
implements RememberManager {
    private long mRememberDuration = RifeConfig.Authentication.getRememberDuration();
    private static /* synthetic */ boolean $assertionsDisabled;

    protected DatabaseRemember(Datasource datasource) {
        super(datasource);
    }

    public long getRememberDuration() {
        return this.mRememberDuration;
    }

    public void setRememberDuration(long milliseconds) {
        this.mRememberDuration = milliseconds;
    }

    public abstract boolean install() throws RememberManagerException;

    public abstract boolean remove() throws RememberManagerException;

    protected boolean _install(CreateTable createRemember, String createRememberMomentIndex) throws RememberManagerException {
        this.executeUpdate(createRemember);
        this.executeUpdate(createRememberMomentIndex);
        return true;
    }

    protected boolean _remove(DropTable removeRemember, String removeRememberMomentIndex) throws RememberManagerException {
        this.executeUpdate(removeRememberMomentIndex);
        this.executeUpdate(removeRemember);
        return true;
    }

    protected String _createRememberId(Insert createRememberId, long userId, String hostIp) throws RememberManagerException {
        if (!$assertionsDisabled && createRememberId == null) {
            throw new AssertionError();
        }
        if (userId < (long)0) {
            throw new CreateRememberIdErrorException(userId);
        }
        UniqueID remember_id = UniqueIDGenerator.generate(hostIp);
        String remember_id_string = remember_id.toString();
        try {
            if (0 == this.executeUpdate(createRememberId, new 1(remember_id_string, userId))) {
                throw new CreateRememberIdErrorException(userId);
            }
        }
        catch (DatabaseException e) {
            throw new CreateRememberIdErrorException(userId, (Throwable)e);
        }
        try {
            return StringEncryptor.SHA.encrypt(String.valueOf(userId)) + "|" + remember_id_string;
        }
        catch (NoSuchAlgorithmException e) {
            throw new CreateRememberIdErrorException(userId, (Throwable)e);
        }
    }

    protected boolean _eraseRememberId(Delete eraseRememberId, String rememberId) throws RememberManagerException {
        if (!$assertionsDisabled && eraseRememberId == null) {
            throw new AssertionError();
        }
        if (rememberId == null || 0 == rememberId.length()) {
            return false;
        }
        int rememberid_slash = rememberId.indexOf("|");
        if (-1 == rememberid_slash) {
            return false;
        }
        boolean result = false;
        try {
            if (0 != this.executeUpdate(eraseRememberId, new 2(rememberId, rememberid_slash))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new EraseRememberIdErrorException(rememberId, e);
        }
        return result;
    }

    protected boolean _eraseUserRememberIds(Delete eraseUserRememberIds, long userId) throws RememberManagerException {
        if (!$assertionsDisabled && eraseUserRememberIds == null) {
            throw new AssertionError();
        }
        if (userId < (long)0) {
            return false;
        }
        boolean result = false;
        try {
            if (0 != this.executeUpdate(eraseUserRememberIds, new 3(userId))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new EraseUserRememberIdsErrorException(userId, e);
        }
        return result;
    }

    protected void _eraseAllRememberIds(Delete eraseAllRememberIds) throws RememberManagerException {
        if (!$assertionsDisabled && eraseAllRememberIds == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(eraseAllRememberIds);
        }
        catch (DatabaseException e) {
            throw new EraseAllRememberIdsErrorException(e);
        }
    }

    protected long _getRememberedUserId(Select getRememberedUserId, String rememberId) throws RememberManagerException {
        if (!$assertionsDisabled && getRememberedUserId == null) {
            throw new AssertionError();
        }
        if (rememberId == null || 0 == rememberId.length()) {
            return -1;
        }
        int rememberid_slash = rememberId.indexOf("|");
        if (-1 == rememberid_slash) {
            return -1;
        }
        String encrypted_userid = rememberId.substring(0, rememberid_slash);
        String real_rememberid = rememberId.substring(rememberid_slash + 1);
        long result = -1;
        try {
            result = this.executeGetFirstLong(getRememberedUserId, new 4(real_rememberid));
        }
        catch (DatabaseException e) {
            throw new GetRememberedUserIdErrorException(rememberId, e);
        }
        try {
            if (!encrypted_userid.equals(StringEncryptor.SHA.encrypt(String.valueOf(result)))) {
                return -1;
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new GetRememberedUserIdErrorException(rememberId, e);
        }
        return result;
    }

    protected void _purgeRememberIds(Delete purgeRememberIds) throws RememberManagerException {
        try {
            this.executeUpdate(purgeRememberIds, new 5());
        }
        catch (DatabaseException e) {
            throw new PurgeRememberIdsErrorException(e);
        }
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.authentication.remembermanagers.DatabaseRemember");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    class 1
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$remember_id_string;
        private final /* synthetic */ long val$userId;

        1(String string, long l) {
            this.val$remember_id_string = string;
            this.val$userId = l;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("rememberId", this.val$remember_id_string).setLong("userId", this.val$userId).setLong("moment", System.currentTimeMillis());
        }

        static /* synthetic */ DatabaseRemember access$0(1 var0) {
            return var0.DatabaseRemember.this;
        }
    }

    class 2
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$rememberId;
        private final /* synthetic */ int val$rememberid_slash;

        2(String string, int n) {
            this.val$rememberId = string;
            this.val$rememberid_slash = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("rememberId", this.val$rememberId.substring(this.val$rememberid_slash + 1));
        }

        static /* synthetic */ DatabaseRemember access$0(2 var0) {
            return var0.DatabaseRemember.this;
        }
    }

    class 3
    extends DbPreparedStatementHandler {
        private final /* synthetic */ long val$userId;

        3(long l) {
            this.val$userId = l;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("userId", this.val$userId);
        }

        static /* synthetic */ DatabaseRemember access$0(3 var0) {
            return var0.DatabaseRemember.this;
        }
    }

    class 4
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$real_rememberid;

        4(String string) {
            this.val$real_rememberid = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("rememberId", this.val$real_rememberid);
        }

        static /* synthetic */ DatabaseRemember access$0(4 var0) {
            return var0.DatabaseRemember.this;
        }
    }

    class 5
    extends DbPreparedStatementHandler {
        5() {
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong(1, System.currentTimeMillis() - DatabaseRemember.this.getRememberDuration());
        }

        static /* synthetic */ DatabaseRemember access$0(5 var0) {
            return var0.DatabaseRemember.this;
        }
    }
}

