/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.elements;

import com.uwyn.rife.authentication.SessionManager;
import com.uwyn.rife.authentication.SessionValidator;
import com.uwyn.rife.authentication.credentialsmanagers.RoleUserAttributes;
import com.uwyn.rife.authentication.credentialsmanagers.RoleUserIdentity;
import com.uwyn.rife.authentication.credentialsmanagers.RoleUsersManager;
import com.uwyn.rife.authentication.elements.AuthenticatedDeployer;
import com.uwyn.rife.authentication.exceptions.CredentialsManagerException;
import com.uwyn.rife.authentication.exceptions.SessionManagerException;
import com.uwyn.rife.engine.Element;
import com.uwyn.rife.engine.ElementInfo;

public class Identified
extends Element {
    public static final String IDENTITY_ATTRIBUTE_NAME = "identity";

    public String getAuthElementId() {
        return String.valueOf(this.getProperty("authElementId"));
    }

    public ElementInfo getAuthElement() {
        return this.getSite().resolveId(this.getAuthElementId(), this.getElementInfo());
    }

    public void processElement() {
        this.child();
    }

    public void setIdentityAttribute(String name, String[] values) {
        RoleUserIdentity identity = this.getIdentity(name, values);
        if (identity != null) {
            this.setRequestAttribute(IDENTITY_ATTRIBUTE_NAME, identity);
        }
    }

    public RoleUserIdentity getIdentity(String name, String[] values) {
        if (values == null || 0 == values.length) {
            return null;
        }
        String value = values[0];
        String login = null;
        RoleUserAttributes attributes = null;
        try {
            AuthenticatedDeployer deployer;
            SessionValidator validator;
            ElementInfo authenticated = this.getAuthElement();
            if (authenticated != null && authenticated.getDeployer() != null && authenticated.hasProperty("authvar_name") && authenticated.hasProperty("authvar_type") && authenticated.getDeployer() instanceof AuthenticatedDeployer && (validator = (deployer = (AuthenticatedDeployer)authenticated.getDeployer()).getSessionValidator()).getCredentialsManager() instanceof RoleUsersManager && validator.getSessionManager().isSessionValid(value, this.getRemoteAddr())) {
                RoleUsersManager credentials = (RoleUsersManager)((Object)validator.getCredentialsManager());
                SessionManager sessions = validator.getSessionManager();
                long userid = -1;
                String authvar_name = authenticated.getPropertyString("authvar_name");
                if (authvar_name.equals(name)) {
                    userid = sessions.getSessionUserId(value);
                    if (userid > (long)-1) {
                        login = credentials.getLogin(userid);
                    }
                    if (login != null) {
                        attributes = credentials.getAttributes(login);
                    }
                }
            }
        }
        catch (SessionManagerException e) {
        }
        catch (CredentialsManagerException e) {
            // empty catch block
        }
        if (login != null && attributes != null) {
            return new RoleUserIdentity(login, attributes);
        }
        return null;
    }

    public boolean childTriggered(String name, String[] values) {
        if (!this.hasRequestAttribute(IDENTITY_ATTRIBUTE_NAME)) {
            this.setIdentityAttribute(name, values);
        }
        return true;
    }
}

