/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.elements;

import com.uwyn.rife.authentication.RememberManager;
import com.uwyn.rife.authentication.SessionManager;
import com.uwyn.rife.authentication.elements.exceptions.UndefinedLogoutRememberManagerException;
import com.uwyn.rife.authentication.exceptions.RememberManagerException;
import com.uwyn.rife.authentication.exceptions.SessionManagerException;
import com.uwyn.rife.engine.Element;
import com.uwyn.rife.engine.exceptions.EngineException;
import com.uwyn.rife.engine.exceptions.PropertyRequiredException;
import javax.servlet.http.Cookie;

public abstract class AbstractLogout
extends Element {
    protected SessionManager mSessionManager = null;
    protected RememberManager mRememberManager = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    protected AbstractLogout() {
    }

    protected void setSessionManager(SessionManager sessionValidator) {
        if (!$assertionsDisabled && sessionValidator == null) {
            throw new AssertionError();
        }
        this.mSessionManager = sessionValidator;
    }

    public SessionManager getSessionManager() {
        return this.mSessionManager;
    }

    public void setRememberManager(RememberManager rememberManager) {
        this.mRememberManager = rememberManager;
    }

    public RememberManager getRememberManager() {
        return this.mRememberManager;
    }

    protected void performLogout() {
        Cookie cookie;
        if (!this.hasProperty("authvar_name")) {
            throw new PropertyRequiredException(this.getDeclarationName(), "authvar_name");
        }
        if (!this.hasProperty("remembervar_name")) {
            throw new PropertyRequiredException(this.getDeclarationName(), "remembervar_name");
        }
        String authvar_name = this.getPropertyString("authvar_name");
        boolean has_authvar_input = this.getElementInfo().containsInputPossibility(authvar_name);
        boolean has_authvar_cookie = this.getElementInfo().containsIncookiePossibility(authvar_name);
        String authid = null;
        if (has_authvar_cookie && (cookie = this.getCookie(authvar_name)) != null) {
            authid = cookie.getValue();
        }
        if (has_authvar_input && (authid == null || 0 == authid.length())) {
            authid = this.getInput(authvar_name);
        }
        if (authid != null) {
            Cookie cookie2;
            try {
                this.mSessionManager.eraseSession(authid);
            }
            catch (SessionManagerException e) {
                throw new EngineException(e);
            }
            String remembervar_name = this.getPropertyString("remembervar_name");
            if (this.getElementInfo().containsIncookie(remembervar_name) && this.hasCookie(remembervar_name)) {
                if (this.mRememberManager == null) {
                    throw new UndefinedLogoutRememberManagerException();
                }
                try {
                    this.mRememberManager.eraseRememberId(this.getCookieValue(remembervar_name));
                }
                catch (RememberManagerException e) {
                    throw new EngineException(e);
                }
                cookie2 = this.getCookie(remembervar_name);
                cookie2.setMaxAge(-1);
                cookie2.setPath("/");
                cookie2.setValue("");
                this.setCookie(cookie2);
            }
            if (has_authvar_cookie && this.hasCookie(authvar_name)) {
                cookie2 = this.getCookie(authvar_name);
                cookie2.setMaxAge(-1);
                cookie2.setPath("/");
                cookie2.setValue("");
                this.setCookie(cookie2);
            }
            if (has_authvar_input) {
                this.clearOutput(authvar_name);
            }
        }
        this.removeRequestAttribute("identity");
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.authentication.elements.AbstractLogout");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }
}

