/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.credentialsmanagers.databasedrivers;

import com.uwyn.rife.authentication.Credentials;
import com.uwyn.rife.authentication.credentialsmanagers.DatabaseUsers;
import com.uwyn.rife.authentication.credentialsmanagers.ListRoles;
import com.uwyn.rife.authentication.credentialsmanagers.ListUsers;
import com.uwyn.rife.authentication.credentialsmanagers.RoleUserAttributes;
import com.uwyn.rife.authentication.credentialsmanagers.RoleUsersManager;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.DuplicateLoginException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.DuplicateRoleException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.DuplicateUserIdException;
import com.uwyn.rife.authentication.exceptions.CredentialsManagerException;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.queries.CreateSequence;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.DropSequence;
import com.uwyn.rife.database.queries.DropTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.database.queries.SequenceValue;
import com.uwyn.rife.database.queries.Update;

public class generic
extends DatabaseUsers {
    protected CreateSequence mCreateSequenceRole = new CreateSequence(this.getDatasource()).name(RifeConfig.Authentication.getSequenceRole());
    protected CreateTable mCreateTableRole = null;
    protected CreateTable mCreateTableUser = null;
    protected CreateTable mCreateTableRoleLink = null;
    protected Select mVerifyCredentialsNoRole = null;
    protected Select mVerifyCredentialsRole = null;
    protected Select mGetRoleId = null;
    protected SequenceValue mGetNewRoleId = null;
    protected Insert mAddRole = null;
    protected Select mContainsRole = null;
    protected Select mCountRoles = null;
    protected Select mListRoles = null;
    protected Insert mAddUserWithId = null;
    protected Select mGetFreeUserId = null;
    protected Insert mAddRoleLink = null;
    protected Select mGetAttributes = null;
    protected Select mGetUserRoles = null;
    protected Select mContainsUser = null;
    protected Select mCountUsers = null;
    protected Select mGetLogin = null;
    protected Select mGetUserId = null;
    protected Select mListUsers = null;
    protected Select mListUsersRanged = null;
    protected Select mIsUserInRole = null;
    protected Select mListUsersInRole = null;
    protected Update mUpdateUser = null;
    protected Delete mRemoveRoleLinksByUserId = null;
    protected Delete mRemoveUserByLogin = null;
    protected Delete mRemoveUserByUserId = null;
    protected Delete mRemoveRole = null;
    protected Delete mClearUsers = null;
    protected Select mListUserRoles = null;
    protected DropSequence mDropSequenceRole = null;
    protected DropTable mDropTableRole = null;
    protected DropTable mDropTableUser = null;
    protected DropTable mDropTableRoleLink = null;

    public generic(Datasource datasource) {
        super(datasource);
        Class<?> clazz;
        Class<?> clazz2;
        Class<?> clazz3;
        try {
            clazz3 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mCreateTableRole = new CreateTable(this.getDatasource()).table(RifeConfig.Authentication.getTableRole()).column("roleId", Integer.TYPE, CreateTable.NOTNULL).column("name", clazz3, RifeConfig.Authentication.getRoleNameMaximumLength(), CreateTable.NOTNULL).primaryKey(RifeConfig.Authentication.getTableRole().toUpperCase() + "_PK", "roleId").unique(RifeConfig.Authentication.getTableRole().toUpperCase() + "_NAME_UQ", "name");
        try {
            clazz2 = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mCreateTableUser = new CreateTable(this.getDatasource()).table(RifeConfig.Authentication.getTableUser()).column("userId", Long.TYPE, CreateTable.NOTNULL).column("login", clazz2, RifeConfig.Authentication.getLoginMaximumLength(), CreateTable.NOTNULL).column("passwd", clazz, RifeConfig.Authentication.getPasswordMaximumLength(), CreateTable.NOTNULL).primaryKey(RifeConfig.Authentication.getTableUser().toUpperCase() + "_PK", "userId").unique(RifeConfig.Authentication.getTableUser().toUpperCase() + "_LOGIN_UQ", "login");
        this.mCreateTableRoleLink = new CreateTable(this.getDatasource()).table(RifeConfig.Authentication.getTableRoleLink()).column("userId", Long.TYPE, CreateTable.NOTNULL).column("roleId", Integer.TYPE, CreateTable.NOTNULL).primaryKey(RifeConfig.Authentication.getTableRoleLink().toUpperCase() + "_PK", new String[]{"userId", "roleId"}).foreignKey(RifeConfig.Authentication.getTableRoleLink().toUpperCase() + "_USERID_FK", this.mCreateTableUser.getTable(), "userId", "userId", null, CreateTable.CASCADE).foreignKey(RifeConfig.Authentication.getTableRoleLink().toUpperCase() + "_ROLEID_FK", this.mCreateTableRole.getTable(), "roleId", "roleId", null, CreateTable.CASCADE);
        this.mVerifyCredentialsNoRole = (Select)((Select)new Select(this.getDatasource()).from(this.mCreateTableUser.getTable()).field("userId").whereParameter("login", "=")).whereParameterAnd("passwd", "=");
        this.mVerifyCredentialsRole = (Select)((Select)((Select)((Select)((Select)new Select(this.getDatasource()).from(this.mCreateTableUser.getTable()).join(this.mCreateTableRoleLink.getTable()).join(this.mCreateTableRole.getTable()).field(this.mCreateTableUser.getTable() + ".userId").whereParameter("login", "=")).whereParameterAnd("passwd", "=")).whereAnd(this.mCreateTableUser.getTable() + ".userId = " + this.mCreateTableRoleLink.getTable() + ".userId")).whereParameterAnd("name", "role", "=")).whereAnd(this.mCreateTableRole.getTable() + ".roleId = " + this.mCreateTableRoleLink.getTable() + ".roleId");
        this.mGetRoleId = (Select)new Select(this.getDatasource()).from(this.mCreateTableRole.getTable()).field("roleId").whereParameter("name", "=");
        this.mGetNewRoleId = new SequenceValue(this.getDatasource()).name(this.mCreateSequenceRole.getName()).next();
        this.mAddRole = new Insert(this.getDatasource()).into(this.mCreateTableRole.getTable()).fieldParameter("roleId").fieldParameter("name");
        this.mContainsRole = (Select)new Select(this.getDatasource()).from(this.mCreateTableRole.getTable()).whereParameter("name", "=");
        this.mCountRoles = new Select(this.getDatasource()).field("count(*)").from(this.mCreateTableRole.getTable());
        this.mListRoles = new Select(this.getDatasource()).from(this.mCreateTableRole.getTable()).orderBy("name");
        this.mAddUserWithId = new Insert(this.getDatasource()).into(this.mCreateTableUser.getTable()).fieldParameter("userId").fieldParameter("login").fieldParameter("passwd");
        this.mGetFreeUserId = new Select(this.getDatasource()).field("COALESCE(MAX(userId)+1, 0) as freeUserId").from(this.mCreateTableUser.getTable());
        this.mAddRoleLink = new Insert(this.getDatasource()).into(this.mCreateTableRoleLink.getTable()).fieldParameter("userId").fieldParameter("roleId");
        this.mGetAttributes = (Select)new Select(this.getDatasource()).field("userId").field("passwd AS password").from(this.mCreateTableUser.getTable()).whereParameter("login", "=");
        this.mGetUserRoles = ((Select)((Select)new Select(this.getDatasource()).field("name").from(this.mCreateTableRoleLink.getTable()).join(this.mCreateTableRole.getTable()).whereParameter("userId", "=")).whereAnd(this.mCreateTableRoleLink.getTable() + ".roleId = " + this.mCreateTableRole.getTable() + ".roleId")).orderBy("name");
        this.mContainsUser = (Select)new Select(this.getDatasource()).from(this.mCreateTableUser.getTable()).whereParameter("login", "=");
        this.mCountUsers = new Select(this.getDatasource()).field("count(*)").from(this.mCreateTableUser.getTable());
        this.mGetLogin = (Select)new Select(this.getDatasource()).field("login").from(this.mCreateTableUser.getTable()).whereParameter("userId", "=");
        this.mGetUserId = (Select)new Select(this.getDatasource()).field("userId").from(this.mCreateTableUser.getTable()).whereParameter("login", "=");
        this.mListUsers = new Select(this.getDatasource()).from(this.mCreateTableUser.getTable()).orderBy("login");
        this.mListUsersRanged = new Select(this.getDatasource()).from(this.mCreateTableUser.getTable()).orderBy("login").limitParameter("limit").offsetParameter("offset");
        this.mIsUserInRole = (Select)((Select)((Select)new Select(this.getDatasource()).from(this.mCreateTableRoleLink.getTable()).join(this.mCreateTableRole.getTable()).field(this.mCreateTableRoleLink.getTable() + ".userId").whereParameter(this.mCreateTableRoleLink.getTable() + ".userId", "=")).whereParameterAnd("name", "role", "=")).whereAnd(this.mCreateTableRole.getTable() + ".roleId = " + this.mCreateTableRoleLink.getTable() + ".roleId");
        this.mListUsersInRole = ((Select)((Select)((Select)new Select(this.getDatasource()).field(this.mCreateTableUser.getTable() + ".userId").field("login").field("passwd").from(this.mCreateTableUser.getTable()).join(this.mCreateTableRoleLink.getTable()).join(this.mCreateTableRole.getTable()).where(this.mCreateTableUser.getTable() + ".userId = " + this.mCreateTableRoleLink.getTable() + ".userId")).whereAnd(this.mCreateTableRoleLink.getTable() + ".roleId = " + this.mCreateTableRole.getTable() + ".roleId")).whereParameterAnd(this.mCreateTableRole.getTable() + ".name", "role", "=")).orderBy("login");
        this.mUpdateUser = (Update)new Update(this.getDatasource()).table(this.mCreateTableUser.getTable()).fieldParameter("passwd").whereParameter("login", "=");
        this.mRemoveRoleLinksByUserId = (Delete)new Delete(this.getDatasource()).from(this.mCreateTableRoleLink.getTable()).whereParameter("userId", "=");
        this.mRemoveUserByLogin = (Delete)new Delete(this.getDatasource()).from(this.mCreateTableUser.getTable()).whereParameter("login", "=");
        this.mRemoveUserByUserId = (Delete)new Delete(this.getDatasource()).from(this.mCreateTableUser.getTable()).whereParameter("userId", "=");
        this.mRemoveRole = (Delete)new Delete(this.getDatasource()).from(this.mCreateTableRole.getTable()).whereParameter("name", "role", "=");
        this.mClearUsers = new Delete(this.getDatasource()).from(this.mCreateTableUser.getTable());
        this.mListUserRoles = (Select)((Select)((Select)new Select(this.getDatasource()).from(this.mCreateTableRole.getTable()).join(this.mCreateTableRoleLink.getTable()).join(this.mCreateTableUser.getTable()).field(this.mCreateTableRole.getTable() + ".name").where(this.mCreateTableRole.getTable() + ".roleId = " + this.mCreateTableRoleLink.getTable() + ".roleId")).whereParameterAnd(this.mCreateTableUser.getTable() + ".login", "=")).whereAnd(this.mCreateTableUser.getTable() + ".userId = " + this.mCreateTableRoleLink.getTable() + ".userId");
        this.mDropSequenceRole = new DropSequence(this.getDatasource()).name(this.mCreateSequenceRole.getName());
        this.mDropTableRole = new DropTable(this.getDatasource()).table(this.mCreateTableRole.getTable());
        this.mDropTableUser = new DropTable(this.getDatasource()).table(this.mCreateTableUser.getTable());
        this.mDropTableRoleLink = new DropTable(this.getDatasource()).table(this.mCreateTableRoleLink.getTable());
    }

    public boolean install() {
        return this._install(this.mCreateSequenceRole, this.mCreateTableRole, this.mCreateTableUser, this.mCreateTableRoleLink);
    }

    public boolean remove() {
        return this._remove(this.mDropSequenceRole, this.mDropTableRole, this.mDropTableUser, this.mDropTableRoleLink);
    }

    public long verifyCredentials(Credentials credentials) {
        return this._verifyCredentials(this.mVerifyCredentialsNoRole, this.mVerifyCredentialsRole, credentials);
    }

    public DatabaseUsers addRole(String role) {
        try {
            this._addRole(this.mGetNewRoleId, this.mAddRole, role);
        }
        catch (CredentialsManagerException e) {
            String message;
            if (e.getCause() != null && e.getCause().getCause() != null && -1 != (message = e.getCause().getCause().getMessage().toUpperCase()).indexOf(this.mCreateTableRole.getUniqueConstraints().get(0).getName())) {
                throw new DuplicateRoleException(role);
            }
            throw e;
        }
        return this;
    }

    public /* synthetic */ RoleUsersManager addRole(String string) {
        return this.addRole(string);
    }

    public boolean containsRole(String role) {
        return this._containsRole(this.mContainsRole, role);
    }

    public long countRoles() {
        return this._countRoles(this.mCountRoles);
    }

    public boolean listRoles(ListRoles processor) {
        return this._listRoles(this.mListRoles, processor);
    }

    public DatabaseUsers addUser(String login, RoleUserAttributes attributes) {
        try {
            this._addUser(this.mAddUserWithId, this.mGetFreeUserId, this.mGetRoleId, this.mAddRoleLink, login, attributes);
        }
        catch (CredentialsManagerException e) {
            if (e.getCause() != null && e.getCause().getCause() != null) {
                String message = e.getCause().getCause().getMessage().toUpperCase();
                if (-1 != message.indexOf(this.mCreateTableUser.getPrimaryKeys().get(0).getName())) {
                    throw new DuplicateUserIdException(attributes.getUserId());
                }
                if (-1 != message.indexOf(this.mCreateTableUser.getUniqueConstraints().get(0).getName())) {
                    throw new DuplicateLoginException(login);
                }
            }
            throw e;
        }
        return this;
    }

    public /* synthetic */ RoleUsersManager addUser(String string, RoleUserAttributes roleUserAttributes) {
        return this.addUser(string, roleUserAttributes);
    }

    public RoleUserAttributes getAttributes(String login) {
        return this._getAttributes(this.mGetAttributes, this.mGetUserRoles, login);
    }

    public boolean containsUser(String login) {
        return this._containsUser(this.mContainsUser, login);
    }

    public long countUsers() {
        return this._countUsers(this.mCountUsers);
    }

    public String getLogin(long userId) {
        return this._getLogin(this.mGetLogin, userId);
    }

    public long getUserId(String login) {
        return this._getUserId(this.mGetUserId, login);
    }

    public boolean listUsers(ListUsers processor) {
        return this._listUsers(this.mListUsers, processor);
    }

    public boolean listUsers(ListUsers processor, int limit, int offset) {
        return this._listUsers(this.mListUsersRanged, processor, limit, offset);
    }

    public boolean isUserInRole(long userId, String role) {
        return this._isUserInRole(this.mIsUserInRole, userId, role);
    }

    public boolean listUsersInRole(ListUsers processor, String role) {
        return this._listUsersInRole(this.mListUsersInRole, processor, role);
    }

    public boolean updateUser(String login, RoleUserAttributes attributes) {
        return this._updateUser(this.mUpdateUser, this.mRemoveRoleLinksByUserId, this.mGetRoleId, this.mAddRoleLink, login, attributes);
    }

    public boolean removeUser(String login) {
        return this._removeUser(this.mRemoveUserByLogin, login);
    }

    public boolean removeUser(long userId) {
        return this._removeUser(this.mRemoveUserByUserId, userId);
    }

    public boolean removeRole(String name) {
        return this._removeRole(this.mRemoveRole, name);
    }

    public void clearUsers() {
        this._clearUsers(this.mClearUsers);
    }

    public boolean listUserRoles(String login, ListRoles processor) {
        return this._listUserRoles(this.mListUserRoles, login, processor);
    }
}

