/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.credentialsmanagers.databasedrivers;

import com.uwyn.rife.authentication.credentialsmanagers.DatabaseUsers;
import com.uwyn.rife.authentication.credentialsmanagers.RoleUserAttributes;
import com.uwyn.rife.authentication.credentialsmanagers.databasedrivers.generic;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.AddRoleErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.AddUserErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.DuplicateLoginException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.DuplicateRoleException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.DuplicateUserIdException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.InstallCredentialsErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.RemoveCredentialsErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.RemoveRoleErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.RemoveUserErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.UnknownRoleErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.UpdateUserErrorException;
import com.uwyn.rife.config.RifeConfig;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbStatement;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.tools.StringEncryptor;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Iterator;

public class com_mysql_jdbc_Driver
extends generic {
    private Delete mRemoveRoleLinksByRoleId = null;

    public com_mysql_jdbc_Driver(Datasource datasource) {
        super(datasource);
        Class<?> clazz;
        try {
            clazz = Class.forName("java.lang.String");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mCreateTableRole = new CreateTable(this.getDatasource()).table(RifeConfig.Authentication.getTableRole()).column("roleId", Integer.TYPE, CreateTable.NOTNULL).column("name", clazz, RifeConfig.Authentication.getRoleNameMaximumLength(), CreateTable.NOTNULL).customAttribute("roleId", "AUTO_INCREMENT").primaryKey(RifeConfig.Authentication.getTableRole().toUpperCase() + "_PK", "roleId").unique(RifeConfig.Authentication.getTableRole().toUpperCase() + "_NAME_UQ", "name");
        this.mCreateTableRoleLink = new CreateTable(this.getDatasource()).table(RifeConfig.Authentication.getTableRoleLink()).column("userId", Long.TYPE, CreateTable.NOTNULL).column("roleId", Integer.TYPE, CreateTable.NOTNULL).primaryKey(RifeConfig.Authentication.getTableRoleLink().toUpperCase() + "_PK", new String[]{"userId", "roleId"});
        this.mAddRole = new Insert(this.getDatasource()).into(this.mCreateTableRole.getTable()).fieldParameter("name");
        this.mGetFreeUserId = new Select(this.getDatasource()).field("MAX(userId)+1 as freeUserId").from(this.mCreateTableUser.getTable());
        this.mGetRoleId = (Select)new Select(this.getDatasource()).from(this.mCreateTableRole.getTable()).field("roleId").whereParameter("name", "role", "=");
        this.mRemoveRoleLinksByRoleId = (Delete)new Delete(this.getDatasource()).from(this.mCreateTableRoleLink.getTable()).whereParameter("roleId", "=");
    }

    public boolean install() {
        try {
            this.executeUpdate(this.mCreateTableRole);
            this.executeUpdate(this.mCreateTableUser);
            this.executeUpdate(this.mCreateTableRoleLink);
        }
        catch (DatabaseException e) {
            throw new InstallCredentialsErrorException(e);
        }
        return true;
    }

    public boolean remove() {
        try {
            this.executeUpdate(this.mDropTableRoleLink);
            this.executeUpdate(this.mDropTableUser);
            this.executeUpdate(this.mDropTableRole);
        }
        catch (DatabaseException e) {
            throw new RemoveCredentialsErrorException(e);
        }
        return true;
    }

    public DatabaseUsers addRole(String role) {
        if (role == null || 0 == role.length()) {
            throw new AddRoleErrorException(role);
        }
        try {
            if (0 == this.executeUpdate(this.mAddRole, new 1(role))) {
                throw new AddRoleErrorException(role);
            }
        }
        catch (DatabaseException e) {
            String message;
            if (e.getCause() != null && -1 != (message = e.getCause().getMessage().toUpperCase()).indexOf("DUPLICATE") && -1 != message.indexOf("FOR KEY 2")) {
                throw new DuplicateRoleException(role);
            }
            throw new AddRoleErrorException(role, e);
        }
        return this;
    }

    public DatabaseUsers addUser(String login, RoleUserAttributes attributes) {
        block28: {
            if (login == null || 0 == login.length() || attributes == null) {
                throw new AddUserErrorException(login, attributes);
            }
            try {
                Cloneable ps_get_roleid;
                String password = null;
                if (this.mPasswordEncryptor == null || attributes.getPassword().startsWith(this.mPasswordEncryptor.toString())) {
                    password = attributes.getPassword();
                } else {
                    try {
                        password = this.mPasswordEncryptor.encrypt(attributes.getPassword());
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new AddUserErrorException(login, attributes, e);
                    }
                }
                HashMap<String, Integer> roleids = null;
                if (attributes.getRoles() != null) {
                    roleids = new HashMap<String, Integer>();
                    ps_get_roleid = this.getConnection().getPreparedStatement(this.mGetRoleId);
                    int roleid = -1;
                    try {
                        Iterator<String> iterator = attributes.getRoles().iterator();
                        while (iterator.hasNext()) {
                            String role = iterator.next();
                            ((DbPreparedStatement)ps_get_roleid).setString(1, role);
                            ((DbPreparedStatement)ps_get_roleid).executeQuery();
                            if (((DbStatement)ps_get_roleid).getResultSet().hasResultRows()) {
                                roleid = ((DbStatement)ps_get_roleid).getResultSet().getFirstInt();
                            }
                            if (-1 == roleid) {
                                throw new UnknownRoleErrorException(role, login, attributes);
                            }
                            roleids.put(role, new Integer(roleid));
                        }
                    }
                    finally {
                        ((DbPreparedStatement)ps_get_roleid).close();
                    }
                }
                ps_get_roleid = this.mGetFreeUserId;
                synchronized (ps_get_roleid) {
                    String adapted_password = password;
                    if (attributes.getUserId() < (long)0) {
                        attributes.setUserId(this.executeGetFirstLong(this.mGetFreeUserId));
                    }
                    if (0 == this.executeUpdate(this.mAddUserWithId, new 2(attributes, login, adapted_password))) {
                        throw new AddUserErrorException(login, attributes);
                    }
                }
                if (attributes.getRoles() == null) break block28;
                DbPreparedStatement ps_add_rolelink = this.getConnection().getPreparedStatement(this.mAddRoleLink);
                try {
                    Iterator<String> iterator = attributes.getRoles().iterator();
                    while (iterator.hasNext()) {
                        String role = iterator.next();
                        ps_add_rolelink.setLong(1, attributes.getUserId());
                        ps_add_rolelink.setInt(2, (int)((Integer)roleids.get(role)));
                        if (0 == ps_add_rolelink.executeUpdate()) {
                            throw new AddUserErrorException(login, attributes);
                        }
                        ps_add_rolelink.clearParameters();
                    }
                }
                finally {
                    ps_add_rolelink.close();
                }
            }
            catch (DatabaseException e) {
                String message;
                if (e.getCause() != null && -1 != (message = e.getCause().getMessage().toUpperCase()).indexOf("DUPLICATE")) {
                    if (-1 != message.indexOf("FOR KEY 1")) {
                        throw new DuplicateUserIdException(attributes.getUserId());
                    }
                    if (-1 != message.indexOf("FOR KEY 2")) {
                        throw new DuplicateLoginException(login);
                    }
                }
                throw new AddUserErrorException(login, attributes, e);
            }
        }
        return this;
    }

    public boolean updateUser(String login, RoleUserAttributes attributes) {
        block23: {
            if (login == null || 0 == login.length() || attributes == null) {
                throw new UpdateUserErrorException(login, attributes);
            }
            try {
                long userid;
                HashMap<String, Integer> roleids = null;
                if (attributes.getRoles() != null) {
                    roleids = new HashMap<String, Integer>();
                    DbPreparedStatement ps_get_roleid = this.getConnection().getPreparedStatement(this.mGetRoleId);
                    int roleid = -1;
                    try {
                        Iterator<String> iterator = attributes.getRoles().iterator();
                        while (iterator.hasNext()) {
                            String role = iterator.next();
                            ps_get_roleid.setString(1, role);
                            ps_get_roleid.executeQuery();
                            if (ps_get_roleid.getResultSet().hasResultRows()) {
                                roleid = ps_get_roleid.getResultSet().getFirstInt();
                            }
                            if (-1 == roleid) {
                                throw new UnknownRoleErrorException(role, login, attributes);
                            }
                            roleids.put(role, new Integer(roleid));
                        }
                    }
                    finally {
                        ps_get_roleid.close();
                    }
                }
                if ((userid = this.getUserId(login)) < (long)0) {
                    throw new UpdateUserErrorException(login, attributes);
                }
                if (attributes.getPassword() != null) {
                    String password = null;
                    if (this.mPasswordEncryptor == null || attributes.getPassword().startsWith(this.mPasswordEncryptor.toString())) {
                        password = attributes.getPassword();
                    } else {
                        try {
                            password = this.mPasswordEncryptor.encrypt(attributes.getPassword());
                        }
                        catch (NoSuchAlgorithmException e) {
                            throw new UpdateUserErrorException(login, attributes, e);
                        }
                    }
                    String adapted_password = password;
                    if (0 == this.executeUpdate(this.mUpdateUser, new 3(adapted_password, login))) {
                        return false;
                    }
                }
                this.executeUpdate(this.mRemoveRoleLinksByUserId, new 4(userid));
                if (attributes.getRoles() == null) break block23;
                DbPreparedStatement ps_add_rolelink = this.getConnection().getPreparedStatement(this.mAddRoleLink);
                try {
                    Iterator<String> iterator = attributes.getRoles().iterator();
                    while (iterator.hasNext()) {
                        String role = iterator.next();
                        ps_add_rolelink.setLong(1, userid);
                        ps_add_rolelink.setInt(2, (int)((Integer)roleids.get(role)));
                        if (0 == ps_add_rolelink.executeUpdate()) {
                            throw new AddUserErrorException(login, attributes);
                        }
                        ps_add_rolelink.clearParameters();
                    }
                }
                finally {
                    ps_add_rolelink.close();
                }
            }
            catch (DatabaseException e) {
                throw new UpdateUserErrorException(login, attributes, e);
            }
        }
        return true;
    }

    public boolean removeUser(String login) {
        if (login == null || 0 == login.length()) {
            return false;
        }
        boolean result = false;
        try {
            long userid = this.executeGetFirstLong(this.mGetUserId, new 5(login));
            if (0 != this.executeUpdate(this.mRemoveUserByLogin, new 6(login))) {
                result = true;
            }
            if (0 != this.executeUpdate(this.mRemoveRoleLinksByUserId, new 7(userid))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new RemoveUserErrorException(login, e);
        }
        return result;
    }

    public boolean removeUser(long userId) {
        if (userId < (long)0) {
            return false;
        }
        boolean result = false;
        try {
            if (0 != this.executeUpdate(this.mRemoveUserByUserId, new 8(userId))) {
                result = true;
            }
            if (0 != this.executeUpdate(this.mRemoveRoleLinksByUserId, new 9(userId))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new RemoveUserErrorException(new Long(userId), e);
        }
        return result;
    }

    public boolean removeRole(String name) {
        if (name == null || 0 == name.length()) {
            return false;
        }
        boolean result = false;
        try {
            int roleid = this.executeGetFirstInt(this.mGetRoleId, new 10(name));
            if (0 != this.executeUpdate(this.mRemoveRole, new 11(name))) {
                result = true;
            }
            if (0 != this.executeUpdate(this.mRemoveRoleLinksByRoleId, new 12(roleid))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new RemoveRoleErrorException(name, e);
        }
        return result;
    }

    static /* synthetic */ StringEncryptor access$Lcom$uwyn$rife$authentication$credentialsmanagers$DatabaseUsers$1(com_mysql_jdbc_Driver com_mysql_jdbc_Driver2) {
        return com_mysql_jdbc_Driver2.mPasswordEncryptor;
    }

    static /* synthetic */ void access$Scom$uwyn$rife$authentication$credentialsmanagers$DatabaseUsers$1(com_mysql_jdbc_Driver com_mysql_jdbc_Driver2, StringEncryptor stringEncryptor) {
        com_mysql_jdbc_Driver2.mPasswordEncryptor = stringEncryptor;
    }

    class 1
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$role;

        1(String string) {
            this.val$role = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("name", this.val$role);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(1 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 2
    extends DbPreparedStatementHandler {
        private final /* synthetic */ RoleUserAttributes val$attributes;
        private final /* synthetic */ String val$login;
        private final /* synthetic */ String val$adapted_password;

        2(RoleUserAttributes roleUserAttributes, String string, String string2) {
            this.val$attributes = roleUserAttributes;
            this.val$login = string;
            this.val$adapted_password = string2;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("userId", this.val$attributes.getUserId()).setString("login", this.val$login).setString("passwd", this.val$adapted_password);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(2 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 3
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$adapted_password;
        private final /* synthetic */ String val$login;

        3(String string, String string2) {
            this.val$adapted_password = string;
            this.val$login = string2;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("passwd", this.val$adapted_password).setString("login", this.val$login);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(3 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 4
    extends DbPreparedStatementHandler {
        private final /* synthetic */ long val$userid;

        4(long l) {
            this.val$userid = l;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("userId", this.val$userid);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(4 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 5
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$login;

        5(String string) {
            this.val$login = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("login", this.val$login);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(5 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 6
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$login;

        6(String string) {
            this.val$login = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("login", this.val$login);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(6 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 7
    extends DbPreparedStatementHandler {
        private final /* synthetic */ long val$userid;

        7(long l) {
            this.val$userid = l;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("userId", this.val$userid);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(7 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 8
    extends DbPreparedStatementHandler {
        private final /* synthetic */ long val$userId;

        8(long l) {
            this.val$userId = l;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("userId", this.val$userId);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(8 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 9
    extends DbPreparedStatementHandler {
        private final /* synthetic */ long val$userId;

        9(long l) {
            this.val$userId = l;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("userId", this.val$userId);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(9 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 10
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$name;

        10(String string) {
            this.val$name = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("role", this.val$name);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(10 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 11
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$name;

        11(String string) {
            this.val$name = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("role", this.val$name);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(11 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }

    class 12
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$roleid;

        12(int n) {
            this.val$roleid = n;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("roleId", this.val$roleid);
        }

        static /* synthetic */ com_mysql_jdbc_Driver access$0(12 var0) {
            return var0.com_mysql_jdbc_Driver.this;
        }
    }
}

