/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.credentialsmanagers;

import com.uwyn.rife.authentication.credentialsmanagers.RoleUserAttributes;
import com.uwyn.rife.xml.Xml2Data;
import com.uwyn.rife.xml.exceptions.XmlErrorException;
import java.util.LinkedHashMap;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Xml2MemoryUsers
extends Xml2Data {
    private LinkedHashMap<String, RoleUserAttributes> mUsers = null;
    private StringBuffer mCharacterData = null;
    private RoleUserAttributes mCurrentAttributes = null;

    public LinkedHashMap<String, RoleUserAttributes> getUsers() {
        return this.mUsers;
    }

    protected void clear() {
        this.mUsers = new LinkedHashMap();
    }

    @Override
    public void startDocument() {
        this.clear();
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        if (!qName.equals("credentials")) {
            if (qName.equals("user")) {
                String login = atts.getValue("login");
                String userid = atts.getValue("userid");
                this.mCurrentAttributes = new RoleUserAttributes();
                if (userid != null && userid.length() > 0) {
                    try {
                        this.mCurrentAttributes.setUserId(Integer.parseInt(userid));
                    }
                    catch (NumberFormatException e) {
                        throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append("Invalid userid '").append(userid).toString()).append("'").toString(), e);
                    }
                }
                this.mUsers.put(login, this.mCurrentAttributes);
            } else if (qName.equals("password")) {
                this.mCharacterData = new StringBuffer();
            } else if (qName.equals("role")) {
                this.mCharacterData = new StringBuffer();
            } else {
                throw new XmlErrorException(new StringBuffer().append(new StringBuffer().append("Unsupport element name '").append(qName).toString()).append("'.").toString());
            }
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (qName.equals("password")) {
            String password = this.mCharacterData.toString();
            this.mCurrentAttributes.setPassword(password);
            this.mCharacterData = new StringBuffer();
        } else if (qName.equals("role")) {
            String role = this.mCharacterData.toString();
            this.mCurrentAttributes.addRole(role);
            this.mCharacterData = new StringBuffer();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (length > 0) {
            this.mCharacterData.append(String.copyValueOf(ch, start, length));
        }
    }
}

