/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.authentication.credentialsmanagers;

import com.uwyn.rife.authentication.Credentials;
import com.uwyn.rife.authentication.CredentialsManager;
import com.uwyn.rife.authentication.credentials.RoleUserCredentials;
import com.uwyn.rife.authentication.credentialsmanagers.ListRoles;
import com.uwyn.rife.authentication.credentialsmanagers.ListUsers;
import com.uwyn.rife.authentication.credentialsmanagers.RoleUserAttributes;
import com.uwyn.rife.authentication.credentialsmanagers.RoleUsersManager;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.AddRoleErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.AddUserErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.ClearUsersErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.ContainsRoleErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.ContainsUserErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.CountRolesErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.CountUsersErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.GetAttributesErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.GetLoginErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.GetUserIdErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.InstallCredentialsErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.IsUserInRoleErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.ListRolesErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.ListUsersErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.RemoveCredentialsErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.RemoveRoleErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.RemoveUserErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.UnknownRoleErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.UnsupportedCredentialsTypeException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.UpdateUserErrorException;
import com.uwyn.rife.authentication.credentialsmanagers.exceptions.VerifyCredentialsErrorException;
import com.uwyn.rife.authentication.exceptions.CredentialsManagerException;
import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbPreparedStatement;
import com.uwyn.rife.database.DbPreparedStatementHandler;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.DbRowProcessor;
import com.uwyn.rife.database.DbTransactionUser;
import com.uwyn.rife.database.DbTransactionUserWithoutResult;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.queries.CreateSequence;
import com.uwyn.rife.database.queries.CreateTable;
import com.uwyn.rife.database.queries.Delete;
import com.uwyn.rife.database.queries.DropSequence;
import com.uwyn.rife.database.queries.DropTable;
import com.uwyn.rife.database.queries.Insert;
import com.uwyn.rife.database.queries.Select;
import com.uwyn.rife.database.queries.SequenceValue;
import com.uwyn.rife.database.queries.Update;
import com.uwyn.rife.tools.InnerClassException;
import com.uwyn.rife.tools.StringEncryptor;
import java.security.NoSuchAlgorithmException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public abstract class DatabaseUsers
extends DbQueryManager
implements CredentialsManager,
RoleUsersManager {
    protected StringEncryptor mPasswordEncryptor = null;
    private static /* synthetic */ boolean $assertionsDisabled;

    protected DatabaseUsers(Datasource datasource) {
        super(datasource);
    }

    public abstract boolean install();

    public abstract boolean remove();

    public StringEncryptor getPasswordEncryptor() {
        return this.mPasswordEncryptor;
    }

    public void setPasswordEncryptor(StringEncryptor passwordEncryptor) {
        this.mPasswordEncryptor = passwordEncryptor;
    }

    protected boolean _install(CreateSequence createSequenceRole, CreateTable createTableRole, CreateTable createTableUser, CreateTable createTableRoleLink) {
        if (!$assertionsDisabled && createSequenceRole == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && createTableRole == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && createTableUser == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && createTableRoleLink == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(createSequenceRole);
            this.executeUpdate(createTableRole);
            this.executeUpdate(createTableUser);
            this.executeUpdate(createTableRoleLink);
        }
        catch (DatabaseException e) {
            throw new InstallCredentialsErrorException(e);
        }
        return true;
    }

    protected boolean _remove(DropSequence dropSequenceRole, DropTable dropTableRole, DropTable dropTableUser, DropTable dropTableRoleLink) {
        if (!$assertionsDisabled && dropSequenceRole == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dropTableRole == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dropTableUser == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && dropTableRoleLink == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(dropTableRoleLink);
            this.executeUpdate(dropTableUser);
            this.executeUpdate(dropTableRole);
            this.executeUpdate(dropSequenceRole);
        }
        catch (DatabaseException e) {
            throw new RemoveCredentialsErrorException(e);
        }
        return true;
    }

    protected long _verifyCredentials(Select verifyCredentialsNoRole, Select verifyCredentialsRole, Credentials credentials) {
        if (!$assertionsDisabled && verifyCredentialsNoRole == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && verifyCredentialsRole == null) {
            throw new AssertionError();
        }
        if (credentials == null) {
            return -1;
        }
        long result = -1;
        RoleUserCredentials role_user = null;
        if (!(credentials instanceof RoleUserCredentials)) {
            throw new UnsupportedCredentialsTypeException(credentials);
        }
        role_user = (RoleUserCredentials)credentials;
        try {
            Select query = null;
            query = role_user.getRole() == null ? verifyCredentialsNoRole : verifyCredentialsRole;
            ProcessVerifyCredentials process_verify_credentials = new ProcessVerifyCredentials();
            if (this.executeFetchFirst(query, process_verify_credentials, new 1(role_user))) {
                result = process_verify_credentials.getUserId();
            }
        }
        catch (DatabaseException e) {
            throw new VerifyCredentialsErrorException(credentials, (Throwable)e);
        }
        return result;
    }

    protected void _addRole(SequenceValue getRoleId, Insert addRole, String role) {
        if (!$assertionsDisabled && getRoleId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && addRole == null) {
            throw new AssertionError();
        }
        if (role == null || 0 == role.length()) {
            throw new AddRoleErrorException(role);
        }
        try {
            try {
                this.inTransaction(new 3(getRoleId, role, addRole));
            }
            catch (InnerClassException e) {
                throw (CredentialsManagerException)e.getCause();
            }
        }
        catch (DatabaseException e) {
            throw new AddRoleErrorException(role, e);
        }
    }

    protected boolean _containsRole(Select containsRole, String role) {
        if (!$assertionsDisabled && containsRole == null) {
            throw new AssertionError();
        }
        if (role == null || 0 == role.length()) {
            return false;
        }
        boolean result = false;
        try {
            result = this.executeHasResultRows(containsRole, new 4(role));
        }
        catch (DatabaseException e) {
            throw new ContainsRoleErrorException(role, e);
        }
        return result;
    }

    protected long _countRoles(Select countRoles) {
        if (!$assertionsDisabled && countRoles == null) {
            throw new AssertionError();
        }
        try {
            return this.executeGetFirstLong(countRoles);
        }
        catch (DatabaseException e) {
            throw new CountRolesErrorException(e);
        }
    }

    protected boolean _listRoles(Select listRolesQuery, ListRoles processor) {
        if (!$assertionsDisabled && listRolesQuery == null) {
            throw new AssertionError();
        }
        if (processor == null) {
            return false;
        }
        boolean result = false;
        try {
            result = this.executeFetchAll(listRolesQuery, new ListDatabaseRoles(processor));
        }
        catch (DatabaseException e) {
            throw new ListRolesErrorException(e);
        }
        return result;
    }

    protected void _addUser(Insert addUserWithId, Select getFreeUserId, Select getRoleId, Insert addRoleLink, String login, RoleUserAttributes attributes) {
        if (!$assertionsDisabled && addUserWithId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && getFreeUserId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && getRoleId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && addRoleLink == null) {
            throw new AssertionError();
        }
        if (login == null || 0 == login.length() || attributes == null) {
            throw new AddUserErrorException(login, attributes);
        }
        try {
            try {
                this.inTransaction(new 8(attributes, login, getFreeUserId, addUserWithId, addRoleLink, getRoleId));
            }
            catch (InnerClassException e) {
                throw (CredentialsManagerException)e.getCause();
            }
        }
        catch (DatabaseException e) {
            throw new AddUserErrorException(login, attributes, e);
        }
    }

    protected RoleUserAttributes _getAttributes(Select getAttributes, Select getUserRoles, String login) {
        if (!$assertionsDisabled && getAttributes == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && getUserRoles == null) {
            throw new AssertionError();
        }
        if (login == null || 0 == login.length()) {
            return null;
        }
        RoleUserAttributes attributes = null;
        try {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.authentication.credentialsmanagers.RoleUserAttributes");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            attributes = (RoleUserAttributes)this.executeFetchFirstBean(getAttributes, clazz, new 9(login));
            if (attributes != null) {
                long userid = attributes.getUserId();
                RoleFetcher fetcher = new RoleFetcher(attributes);
                this.executeFetchAll(getUserRoles, fetcher, new 10(userid));
            }
        }
        catch (DatabaseException e) {
            throw new GetAttributesErrorException(login, e);
        }
        return attributes;
    }

    protected boolean _containsUser(Select containsUser, String login) {
        if (!$assertionsDisabled && containsUser == null) {
            throw new AssertionError();
        }
        if (login == null || 0 == login.length()) {
            return false;
        }
        boolean result = false;
        try {
            result = this.executeHasResultRows(containsUser, new 12(login));
        }
        catch (DatabaseException e) {
            throw new ContainsUserErrorException(login, e);
        }
        return result;
    }

    protected long _countUsers(Select countUsers) {
        if (!$assertionsDisabled && countUsers == null) {
            throw new AssertionError();
        }
        long result = -1;
        try {
            result = this.executeGetFirstLong(countUsers);
        }
        catch (DatabaseException e) {
            throw new CountUsersErrorException(e);
        }
        return result;
    }

    protected String _getLogin(Select getLogin, long userId) {
        if (!$assertionsDisabled && getLogin == null) {
            throw new AssertionError();
        }
        if (userId < (long)0) {
            return null;
        }
        String result = null;
        try {
            result = this.executeGetFirstString(getLogin, new 13(userId));
        }
        catch (DatabaseException e) {
            throw new GetLoginErrorException(e, userId);
        }
        return result;
    }

    protected long _getUserId(Select getUserId, String login) {
        if (!$assertionsDisabled && getUserId == null) {
            throw new AssertionError();
        }
        if (login == null || 0 == login.length()) {
            return -1;
        }
        long result = -1;
        try {
            result = this.executeGetFirstLong(getUserId, new 14(login));
        }
        catch (DatabaseException e) {
            throw new GetUserIdErrorException(e, login);
        }
        return result;
    }

    protected boolean _listUsers(Select listUsersQuery, ListUsers processor) {
        if (!$assertionsDisabled && listUsersQuery == null) {
            throw new AssertionError();
        }
        if (processor == null) {
            return false;
        }
        boolean result = false;
        try {
            ListDatabaseUsers row_processor = new ListDatabaseUsers(processor);
            result = this.executeFetchAll(listUsersQuery, row_processor);
        }
        catch (DatabaseException e) {
            throw new ListUsersErrorException(e);
        }
        return result;
    }

    protected boolean _listUsers(Select listUsersRangedQuery, ListUsers processor, int limit, int offset) {
        if (!$assertionsDisabled && listUsersRangedQuery == null) {
            throw new AssertionError();
        }
        if (processor == null || limit <= 0) {
            return false;
        }
        boolean result = false;
        try {
            ListDatabaseUsers row_processor = new ListDatabaseUsers(processor);
            result = this.executeFetchAll(listUsersRangedQuery, row_processor, new 15(limit, offset));
        }
        catch (DatabaseException e) {
            throw new ListUsersErrorException(e);
        }
        return result;
    }

    protected boolean _isUserInRole(Select isUserInRole, long userId, String role) {
        if (!$assertionsDisabled && isUserInRole == null) {
            throw new AssertionError();
        }
        if (userId < (long)0 || role == null || 0 == role.length()) {
            return false;
        }
        boolean result = false;
        try {
            result = this.executeHasResultRows(isUserInRole, new 16(userId, role));
        }
        catch (DatabaseException e) {
            throw new IsUserInRoleErrorException(userId, role, e);
        }
        return result;
    }

    protected boolean _listUsersInRole(Select listUsersInRole, ListUsers processor, String role) {
        if (!$assertionsDisabled && listUsersInRole == null) {
            throw new AssertionError();
        }
        if (processor == null) {
            return false;
        }
        if (role == null || 0 == role.length()) {
            return false;
        }
        boolean result = false;
        try {
            ListDatabaseUsers row_processor = new ListDatabaseUsers(processor);
            result = this.executeFetchAll(listUsersInRole, row_processor, new 17(role));
        }
        catch (DatabaseException e) {
            throw new ListUsersErrorException(e);
        }
        return result;
    }

    protected boolean _updateUser(Update updateUser, Delete removeRoleLinksByUser, Select getRoleId, Insert addRoleLink, String login, RoleUserAttributes attributes) {
        if (!$assertionsDisabled && updateUser == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && removeRoleLinksByUser == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && getRoleId == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && addRoleLink == null) {
            throw new AssertionError();
        }
        if (login == null || 0 == login.length() || attributes == null) {
            throw new UpdateUserErrorException(login, attributes);
        }
        boolean result = false;
        try {
            try {
                result = (Boolean)this.inTransaction(new 22(login, attributes, updateUser, removeRoleLinksByUser, addRoleLink, getRoleId));
            }
            catch (InnerClassException e) {
                throw (CredentialsManagerException)e.getCause();
            }
        }
        catch (DatabaseException e) {
            throw new UpdateUserErrorException(login, attributes, e);
        }
        return result;
    }

    protected boolean _removeUser(Delete removeUserByLogin, String login) {
        if (!$assertionsDisabled && removeUserByLogin == null) {
            throw new AssertionError();
        }
        if (login == null || 0 == login.length()) {
            return false;
        }
        boolean result = false;
        try {
            if (0 != this.executeUpdate(removeUserByLogin, new 23(login))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new RemoveUserErrorException(login, e);
        }
        return result;
    }

    protected boolean _removeUser(Delete removeUserByUserId, long userId) {
        if (!$assertionsDisabled && removeUserByUserId == null) {
            throw new AssertionError();
        }
        if (userId < (long)0) {
            return false;
        }
        boolean result = false;
        try {
            if (0 != this.executeUpdate(removeUserByUserId, new 24(userId))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new RemoveUserErrorException(new Long(userId), e);
        }
        return result;
    }

    protected boolean _removeRole(Delete removeRole, String name) {
        if (!$assertionsDisabled && removeRole == null) {
            throw new AssertionError();
        }
        if (name == null || 0 == name.length()) {
            return false;
        }
        boolean result = false;
        try {
            if (0 != this.executeUpdate(removeRole, new 25(name))) {
                result = true;
            }
        }
        catch (DatabaseException e) {
            throw new RemoveRoleErrorException(name, e);
        }
        return result;
    }

    protected void _clearUsers(Delete clearUsers) {
        if (!$assertionsDisabled && clearUsers == null) {
            throw new AssertionError();
        }
        try {
            this.executeUpdate(clearUsers);
        }
        catch (DatabaseException e) {
            throw new ClearUsersErrorException(e);
        }
    }

    protected boolean _listUserRoles(Select listUserRolesQuery, String login, ListRoles processor) {
        if (!$assertionsDisabled && listUserRolesQuery == null) {
            throw new AssertionError();
        }
        if (processor == null) {
            return false;
        }
        boolean result = false;
        long userId = this.getUserId(login);
        try {
            result = this.executeFetchAll(listUserRolesQuery, new ListDatabaseRoles(processor), new 26(login));
        }
        catch (DatabaseException e) {
            throw new ListRolesErrorException(e);
        }
        return result;
    }

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("com.uwyn.rife.authentication.credentialsmanagers.DatabaseUsers");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    protected class ProcessVerifyCredentials
    extends DbRowProcessor {
        private long mUserId = -1;
        private static /* synthetic */ boolean $assertionsDisabled;

        public boolean processRow(ResultSet resultSet) throws SQLException {
            if (!$assertionsDisabled && resultSet == null) {
                throw new AssertionError();
            }
            this.mUserId = resultSet.getLong(1);
            return true;
        }

        public long getUserId() {
            return this.mUserId;
        }

        static {
            Class<?> clazz;
            try {
                clazz = Class.forName("com.uwyn.rife.authentication.credentialsmanagers.DatabaseUsers$ProcessVerifyCredentials");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        static /* synthetic */ DatabaseUsers access$0(ProcessVerifyCredentials processVerifyCredentials) {
            return processVerifyCredentials.DatabaseUsers.this;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class 1
    extends DbPreparedStatementHandler<RoleUserCredentials> {
        1(Object object) {
            super(object);
        }

        @Override
        public void setParameters(DbPreparedStatement statement) {
            statement.setString("login", ((RoleUserCredentials)this.mData).getLogin());
            if (DatabaseUsers.this.mPasswordEncryptor == null) {
                statement.setString("passwd", ((RoleUserCredentials)this.mData).getPassword());
            } else {
                try {
                    statement.setString("passwd", DatabaseUsers.this.mPasswordEncryptor.encrypt(((RoleUserCredentials)this.mData).getPassword()));
                }
                catch (NoSuchAlgorithmException e) {
                    throw new DatabaseException(e);
                }
            }
            if (((RoleUserCredentials)this.mData).getRole() != null) {
                statement.setString("role", ((RoleUserCredentials)this.mData).getRole());
            }
        }

        static /* synthetic */ DatabaseUsers access$0(1 var0) {
            return var0.DatabaseUsers.this;
        }

        static /* synthetic */ Object access$Lcom$uwyn$rife$database$DbPreparedStatementHandler$2(1 var0) {
            return var0.mData;
        }

        static /* synthetic */ void access$Scom$uwyn$rife$database$DbPreparedStatementHandler$2(1 var0, Object object) {
            var0.mData = object;
        }
    }

    class 3
    extends DbTransactionUserWithoutResult {
        private final /* synthetic */ SequenceValue val$getRoleId;
        private final /* synthetic */ String val$role;
        private final /* synthetic */ Insert val$addRole;

        3(SequenceValue sequenceValue, String string, Insert insert2) {
            this.val$getRoleId = sequenceValue;
            this.val$role = string;
            this.val$addRole = insert2;
        }

        public void useTransactionWithoutResult() {
            int role_id = DatabaseUsers.this.executeGetFirstInt(this.val$getRoleId);
            if (-1 == role_id) {
                this.throwException(new AddRoleErrorException(this.val$role));
            }
            if (0 == DatabaseUsers.this.executeUpdate(this.val$addRole, new 2(role_id, this.val$role))) {
                this.throwException(new AddRoleErrorException(this.val$role));
            }
        }

        static /* synthetic */ DatabaseUsers access$0(3 var0) {
            return var0.DatabaseUsers.this;
        }

        class 2
        extends DbPreparedStatementHandler {
            private final /* synthetic */ int val$role_id;
            private final /* synthetic */ String val$role;

            2(int n, String string) {
                this.val$role_id = n;
                this.val$role = string;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setInt("roleId", this.val$role_id).setString("name", this.val$role);
            }

            static /* synthetic */ 3 access$0(2 var0) {
                return var0.3.this;
            }
        }
    }

    class 4
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$role;

        4(String string) {
            this.val$role = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("name", this.val$role);
        }

        static /* synthetic */ DatabaseUsers access$0(4 var0) {
            return var0.DatabaseUsers.this;
        }
    }

    protected static class ListDatabaseRoles
    extends DbRowProcessor {
        private ListRoles mListRoles = null;

        public ListDatabaseRoles(ListRoles listRoles) {
            this.mListRoles = listRoles;
        }

        public boolean processRow(ResultSet resultSet) throws SQLException {
            return this.mListRoles.foundRole(resultSet.getString("name"));
        }
    }

    class 8
    extends DbTransactionUserWithoutResult {
        private final /* synthetic */ RoleUserAttributes val$attributes;
        private final /* synthetic */ String val$login;
        private final /* synthetic */ Select val$getFreeUserId;
        private final /* synthetic */ Insert val$addUserWithId;
        private final /* synthetic */ Insert val$addRoleLink;
        private final /* synthetic */ Select val$getRoleId;

        8(RoleUserAttributes roleUserAttributes, String string, Select select2, Insert insert2, Insert insert3, Select select3) {
            this.val$attributes = roleUserAttributes;
            this.val$login = string;
            this.val$getFreeUserId = select2;
            this.val$addUserWithId = insert2;
            this.val$addRoleLink = insert3;
            this.val$getRoleId = select3;
        }

        public void useTransactionWithoutResult() {
            String password = null;
            if (DatabaseUsers.this.mPasswordEncryptor == null || this.val$attributes.getPassword().startsWith(DatabaseUsers.this.mPasswordEncryptor.toString())) {
                password = this.val$attributes.getPassword();
            } else {
                try {
                    password = DatabaseUsers.this.mPasswordEncryptor.encrypt(this.val$attributes.getPassword());
                }
                catch (NoSuchAlgorithmException e) {
                    this.throwException(new AddUserErrorException(this.val$login, this.val$attributes, e));
                }
            }
            Select select2 = this.val$getFreeUserId;
            synchronized (select2) {
                String adapted_password = password;
                if (this.val$attributes.getUserId() < (long)0) {
                    this.val$attributes.setUserId(DatabaseUsers.this.executeGetFirstLong(this.val$getFreeUserId));
                }
                long user_id = this.val$attributes.getUserId();
                if (0 == DatabaseUsers.this.executeUpdate(this.val$addUserWithId, new 5(this.val$attributes, this.val$login, adapted_password))) {
                    this.throwException(new AddUserErrorException(this.val$login, this.val$attributes));
                }
            }
            if (this.val$attributes.getRoles() != null && 0 == DatabaseUsers.this.executeUpdate(this.val$addRoleLink, new 7(this.val$attributes, this.val$getRoleId, this.val$login))) {
                this.throwException(new AddUserErrorException(this.val$login, this.val$attributes));
            }
        }

        class 5
        extends DbPreparedStatementHandler {
            private final /* synthetic */ RoleUserAttributes val$attributes;
            private final /* synthetic */ String val$login;
            private final /* synthetic */ String val$adapted_password;

            5(RoleUserAttributes roleUserAttributes, String string, String string2) {
                this.val$attributes = roleUserAttributes;
                this.val$login = string;
                this.val$adapted_password = string2;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setLong("userId", this.val$attributes.getUserId()).setString("login", this.val$login).setString("passwd", this.val$adapted_password);
            }

            static /* synthetic */ 8 access$0(5 var0) {
                return var0.8.this;
            }
        }

        class 7
        extends DbPreparedStatementHandler {
            private final /* synthetic */ RoleUserAttributes val$attributes;
            private final /* synthetic */ Select val$getRoleId;
            private final /* synthetic */ String val$login;

            7(RoleUserAttributes roleUserAttributes, Select select2, String string) {
                this.val$attributes = roleUserAttributes;
                this.val$getRoleId = select2;
                this.val$login = string;
            }

            public int performUpdate(DbPreparedStatement statement) {
                boolean result = false;
                Iterator<String> iterator = this.val$attributes.getRoles().iterator();
                while (iterator.hasNext()) {
                    String role = iterator.next();
                    int roleid = DatabaseUsers.this.executeGetFirstInt(this.val$getRoleId, new 6(role));
                    if (-1 == roleid) {
                        throw new UnknownRoleErrorException(role, this.val$login, this.val$attributes);
                    }
                    statement.setLong("userId", this.val$attributes.getUserId()).setInt("roleId", roleid);
                    if (0 == statement.executeUpdate()) {
                        return 0;
                    }
                    statement.clearParameters();
                }
                return 1;
            }

            static /* synthetic */ 8 access$0(7 var0) {
                return var0.8.this;
            }

            /*
             * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class 6
            extends DbPreparedStatementHandler<String> {
                6(Object object) {
                    super(object);
                }

                @Override
                public void setParameters(DbPreparedStatement statement) {
                    statement.setString("name", (String)this.mData);
                }

                static /* synthetic */ 7 access$0(6 var0) {
                    return var0.7.this;
                }

                static /* synthetic */ Object access$Lcom$uwyn$rife$database$DbPreparedStatementHandler$2(6 var0) {
                    return var0.mData;
                }

                static /* synthetic */ void access$Scom$uwyn$rife$database$DbPreparedStatementHandler$2(6 var0, Object object) {
                    var0.mData = object;
                }
            }
        }
    }

    class 9
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$login;

        9(String string) {
            this.val$login = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("login", this.val$login);
        }

        static /* synthetic */ DatabaseUsers access$0(9 var0) {
            return var0.DatabaseUsers.this;
        }
    }

    protected class RoleFetcher
    extends DbRowProcessor {
        private RoleUserAttributes mAttributes = null;

        public RoleFetcher(RoleUserAttributes attributes) {
            this.mAttributes = attributes;
        }

        public boolean processRow(ResultSet resultSet) throws SQLException {
            this.mAttributes.addRole(resultSet.getString("name"));
            return true;
        }

        static /* synthetic */ DatabaseUsers access$0(RoleFetcher roleFetcher) {
            return roleFetcher.DatabaseUsers.this;
        }
    }

    class 10
    extends DbPreparedStatementHandler {
        private final /* synthetic */ long val$userid;

        10(long l) {
            this.val$userid = l;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("userId", this.val$userid);
        }

        static /* synthetic */ DatabaseUsers access$0(10 var0) {
            return var0.DatabaseUsers.this;
        }
    }

    class 12
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$login;

        12(String string) {
            this.val$login = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("login", this.val$login);
        }

        static /* synthetic */ DatabaseUsers access$0(12 var0) {
            return var0.DatabaseUsers.this;
        }
    }

    class 13
    extends DbPreparedStatementHandler {
        private final /* synthetic */ long val$userId;

        13(long l) {
            this.val$userId = l;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("userId", this.val$userId);
        }

        static /* synthetic */ DatabaseUsers access$0(13 var0) {
            return var0.DatabaseUsers.this;
        }
    }

    class 14
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$login;

        14(String string) {
            this.val$login = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("login", this.val$login);
        }

        static /* synthetic */ DatabaseUsers access$0(14 var0) {
            return var0.DatabaseUsers.this;
        }
    }

    protected static class ListDatabaseUsers
    extends DbRowProcessor {
        private ListUsers mListUsers = null;

        public ListDatabaseUsers(ListUsers listUsers) {
            this.mListUsers = listUsers;
        }

        public boolean processRow(ResultSet resultSet) throws SQLException {
            return this.mListUsers.foundUser(resultSet.getLong("userId"), resultSet.getString("login"), resultSet.getString("passwd"));
        }
    }

    class 15
    extends DbPreparedStatementHandler {
        private final /* synthetic */ int val$limit;
        private final /* synthetic */ int val$offset;

        15(int n, int n2) {
            this.val$limit = n;
            this.val$offset = n2;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setInt("limit", this.val$limit).setInt("offset", this.val$offset);
        }

        static /* synthetic */ DatabaseUsers access$0(15 var0) {
            return var0.DatabaseUsers.this;
        }
    }

    class 16
    extends DbPreparedStatementHandler {
        private final /* synthetic */ long val$userId;
        private final /* synthetic */ String val$role;

        16(long l, String string) {
            this.val$userId = l;
            this.val$role = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("userId", this.val$userId).setString("role", this.val$role);
        }

        static /* synthetic */ DatabaseUsers access$0(16 var0) {
            return var0.DatabaseUsers.this;
        }
    }

    class 17
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$role;

        17(String string) {
            this.val$role = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("role", this.val$role);
        }

        static /* synthetic */ DatabaseUsers access$0(17 var0) {
            return var0.DatabaseUsers.this;
        }
    }

    class 22
    extends DbTransactionUser {
        private final /* synthetic */ String val$login;
        private final /* synthetic */ RoleUserAttributes val$attributes;
        private final /* synthetic */ Update val$updateUser;
        private final /* synthetic */ Delete val$removeRoleLinksByUser;
        private final /* synthetic */ Insert val$addRoleLink;
        private final /* synthetic */ Select val$getRoleId;

        22(String string, RoleUserAttributes roleUserAttributes, Update update2, Delete delete2, Insert insert2, Select select2) {
            this.val$login = string;
            this.val$attributes = roleUserAttributes;
            this.val$updateUser = update2;
            this.val$removeRoleLinksByUser = delete2;
            this.val$addRoleLink = insert2;
            this.val$getRoleId = select2;
        }

        public Boolean useTransaction() {
            try {
                long userid = DatabaseUsers.this.getUserId(this.val$login);
                if (userid < (long)0) {
                    this.throwException(new UpdateUserErrorException(this.val$login, this.val$attributes));
                }
                if (this.val$attributes.getPassword() != null) {
                    String password = null;
                    if (DatabaseUsers.this.mPasswordEncryptor == null || this.val$attributes.getPassword().startsWith(DatabaseUsers.this.mPasswordEncryptor.toString())) {
                        password = this.val$attributes.getPassword();
                    } else {
                        try {
                            password = DatabaseUsers.this.mPasswordEncryptor.encrypt(this.val$attributes.getPassword());
                        }
                        catch (NoSuchAlgorithmException e) {
                            this.throwException(new UpdateUserErrorException(this.val$login, this.val$attributes, e));
                        }
                    }
                    String adapted_password = password;
                    if (0 == DatabaseUsers.this.executeUpdate(this.val$updateUser, new 18(adapted_password, this.val$login))) {
                        return new Boolean(false);
                    }
                }
                DatabaseUsers.this.executeUpdate(this.val$removeRoleLinksByUser, new 19(userid));
                if (this.val$attributes.getRoles() != null && 0 == DatabaseUsers.this.executeUpdate(this.val$addRoleLink, new 21(this.val$attributes, this.val$getRoleId, this.val$login, userid))) {
                    this.throwException(new UpdateUserErrorException(this.val$login, this.val$attributes));
                }
            }
            catch (CredentialsManagerException e) {
                this.throwException(new UpdateUserErrorException(this.val$login, this.val$attributes, e));
            }
            return new Boolean(true);
        }

        public /* synthetic */ Object useTransaction() {
            return this.useTransaction();
        }

        class 18
        extends DbPreparedStatementHandler {
            private final /* synthetic */ String val$adapted_password;
            private final /* synthetic */ String val$login;

            18(String string, String string2) {
                this.val$adapted_password = string;
                this.val$login = string2;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setString("passwd", this.val$adapted_password).setString("login", this.val$login);
            }

            static /* synthetic */ 22 access$0(18 var0) {
                return var0.22.this;
            }
        }

        class 19
        extends DbPreparedStatementHandler {
            private final /* synthetic */ long val$userid;

            19(long l) {
                this.val$userid = l;
            }

            public void setParameters(DbPreparedStatement statement) {
                statement.setLong("userId", this.val$userid);
            }

            static /* synthetic */ 22 access$0(19 var0) {
                return var0.22.this;
            }
        }

        class 21
        extends DbPreparedStatementHandler {
            private final /* synthetic */ RoleUserAttributes val$attributes;
            private final /* synthetic */ Select val$getRoleId;
            private final /* synthetic */ String val$login;
            private final /* synthetic */ long val$userid;

            21(RoleUserAttributes roleUserAttributes, Select select2, String string, long l) {
                this.val$attributes = roleUserAttributes;
                this.val$getRoleId = select2;
                this.val$login = string;
                this.val$userid = l;
            }

            public int performUpdate(DbPreparedStatement statement) {
                boolean result = false;
                Iterator<String> iterator = this.val$attributes.getRoles().iterator();
                while (iterator.hasNext()) {
                    String role = iterator.next();
                    int roleid = DatabaseUsers.this.executeGetFirstInt(this.val$getRoleId, new 20(role));
                    if (-1 == roleid) {
                        22.this.throwException(new UnknownRoleErrorException(role, this.val$login, this.val$attributes));
                    }
                    statement.setLong("userId", this.val$userid).setInt("roleId", roleid);
                    if (0 == statement.executeUpdate()) {
                        return 0;
                    }
                    statement.clearParameters();
                }
                return 1;
            }

            static /* synthetic */ 22 access$0(21 var0) {
                return var0.22.this;
            }

            /*
             * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class 20
            extends DbPreparedStatementHandler<String> {
                20(Object object) {
                    super(object);
                }

                @Override
                public void setParameters(DbPreparedStatement statement) {
                    statement.setString("name", (String)this.mData);
                }

                static /* synthetic */ 21 access$0(20 var0) {
                    return var0.21.this;
                }

                static /* synthetic */ Object access$Lcom$uwyn$rife$database$DbPreparedStatementHandler$2(20 var0) {
                    return var0.mData;
                }

                static /* synthetic */ void access$Scom$uwyn$rife$database$DbPreparedStatementHandler$2(20 var0, Object object) {
                    var0.mData = object;
                }
            }
        }
    }

    class 23
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$login;

        23(String string) {
            this.val$login = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("login", this.val$login);
        }

        static /* synthetic */ DatabaseUsers access$0(23 var0) {
            return var0.DatabaseUsers.this;
        }
    }

    class 24
    extends DbPreparedStatementHandler {
        private final /* synthetic */ long val$userId;

        24(long l) {
            this.val$userId = l;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setLong("userId", this.val$userId);
        }

        static /* synthetic */ DatabaseUsers access$0(24 var0) {
            return var0.DatabaseUsers.this;
        }
    }

    class 25
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$name;

        25(String string) {
            this.val$name = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("role", this.val$name);
        }

        static /* synthetic */ DatabaseUsers access$0(25 var0) {
            return var0.DatabaseUsers.this;
        }
    }

    class 26
    extends DbPreparedStatementHandler {
        private final /* synthetic */ String val$login;

        26(String string) {
            this.val$login = string;
        }

        public void setParameters(DbPreparedStatement statement) {
            statement.setString("login", this.val$login);
        }

        static /* synthetic */ DatabaseUsers access$0(26 var0) {
            return var0.DatabaseUsers.this;
        }
    }
}

