/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.asm.attrs;

import com.uwyn.rife.asm.ByteVector;
import com.uwyn.rife.asm.ClassReader;
import com.uwyn.rife.asm.ClassWriter;
import com.uwyn.rife.asm.Label;
import com.uwyn.rife.asm.attrs.StackMapType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class StackMapFrame {
    public Label label;
    public List locals = new ArrayList();
    public List stack = new ArrayList();

    public int read(ClassReader cr, int off, char[] buf, int codeOff, Label[] labels) {
        int n = cr.readUnsignedShort(off);
        off += 2;
        if (labels[n] == null) {
            labels[n] = new Label();
        }
        this.label = labels[n];
        off = this.readTypeInfo(cr, off, this.locals, labels, buf, cr.readUnsignedShort(codeOff + 2));
        off = this.readTypeInfo(cr, off, this.stack, labels, buf, cr.readUnsignedShort(codeOff));
        return off;
    }

    public void write(ClassWriter cw, int maxStack, int maxLocals, ByteVector bv) {
        bv.putShort(this.label.getOffset());
        this.writeTypeInfo(bv, cw, this.locals, maxLocals);
        this.writeTypeInfo(bv, cw, this.stack, maxStack);
    }

    public void getLabels(Set labels) {
        labels.add(this.label);
        this.getTypeInfoLabels(labels, this.locals);
        this.getTypeInfoLabels(labels, this.stack);
    }

    private void getTypeInfoLabels(Set labels, List info) {
        Iterator it = info.iterator();
        while (it.hasNext()) {
            StackMapType typeInfo = (StackMapType)it.next();
            if (typeInfo.getType() != 8) continue;
            labels.add(typeInfo.getLabel());
        }
    }

    private int readTypeInfo(ClassReader cr, int off, List info, Label[] labels, char[] buf, int max) {
        int n = 0;
        if (max > 65535) {
            n = cr.readInt(off);
            off += 4;
        } else {
            n = cr.readUnsignedShort(off);
            off += 2;
        }
        int j = 0;
        while (j < n) {
            int itemType = cr.readByte(off++);
            StackMapType typeInfo = StackMapType.getTypeInfo(itemType);
            info.add(typeInfo);
            switch (itemType) {
                case 7: {
                    typeInfo.setObject(cr.readClass(off, buf));
                    off += 2;
                    break;
                }
                case 8: {
                    int o = cr.readUnsignedShort(off);
                    off += 2;
                    if (labels[o] == null) {
                        labels[o] = new Label();
                    }
                    typeInfo.setLabel(labels[o]);
                    break;
                }
            }
            ++j;
        }
        return off;
    }

    private void writeTypeInfo(ByteVector bv, ClassWriter cw, List info, int max) {
        if (max > 65535) {
            bv.putInt(info.size());
        } else {
            bv.putShort(info.size());
        }
        int j = 0;
        while (j < info.size()) {
            StackMapType typeInfo = (StackMapType)info.get(j);
            bv.putByte(typeInfo.getType());
            switch (typeInfo.getType()) {
                case 7: {
                    bv.putShort(cw.newClass(typeInfo.getObject()));
                    break;
                }
                case 8: {
                    bv.putShort(typeInfo.getLabel().getOffset());
                    break;
                }
            }
            ++j;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Frame:L");
        sb.append(System.identityHashCode(this.label));
        sb.append(" locals").append(this.locals);
        sb.append(" stack").append(this.stack);
        return sb.toString();
    }
}

