/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.search.participants;

import com.uwyn.rife.config.Config;
import com.uwyn.rife.rep.BlockingParticipant;
import com.uwyn.rife.tools.ExceptionUtils;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import org.apache.lucene.util.Constants;

public class LuceneLockCleanerParticipant
extends BlockingParticipant {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final String LOCK_DIR = System.getProperty("org.apache.lucene.lockDir", System.getProperty("java.io.tmpdir"));
    private static final boolean DISABLE_LOCKS = Boolean.getBoolean("disableLuceneLocks") || Constants.JAVA_1_1;
    public static final String WRITE_LOCK_NAME = "write.lock";
    public static final String COMMIT_LOCK_NAME = "commit.lock";
    private static MessageDigest sDigester = null;

    public LuceneLockCleanerParticipant() {
        this.setInitializationMessage("Cleaning up stale locks...");
    }

    protected void initialize() {
        if (DISABLE_LOCKS) {
            return;
        }
        File lockDir = new File(LOCK_DIR);
        File luceneDir = new File(Config.getRepInstance().getString("LUCENE_DIR"));
        File[] files = luceneDir.listFiles();
        if (files == null || 0 == files.length) {
            return;
        }
        File[] fileArray = files;
        int n = 0;
        while (n < fileArray.length) {
            File file = fileArray[n];
            if (file.isDirectory()) {
                StringBuffer write_lock_filename = this.getLockPrefix(file).append("-").append(WRITE_LOCK_NAME);
                StringBuffer commit_lock_filename = this.getLockPrefix(file).append("-").append(COMMIT_LOCK_NAME);
                File wLock = null;
                File cLock = null;
                try {
                    wLock = new File(lockDir.getCanonicalPath(), write_lock_filename.toString());
                    cLock = new File(lockDir.getCanonicalPath(), commit_lock_filename.toString());
                }
                catch (IOException e) {
                    Logger.getLogger("com.uwyn.rife.search.participants").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e));
                    return;
                }
                if (wLock != null && wLock.exists()) {
                    wLock.delete();
                }
                if (cLock != null && cLock.exists()) {
                    cLock.delete();
                }
            }
            ++n;
        }
    }

    private StringBuffer getLockPrefix(File directory) {
        String dirName = null;
        byte[] digest = null;
        StringBuffer buf = new StringBuffer();
        buf.append("lucene-");
        try {
            dirName = directory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        MessageDigest e = sDigester;
        synchronized (e) {
            digest = sDigester.digest(dirName.getBytes());
        }
        int i = 0;
        while (i < digest.length) {
            byte b = digest[i];
            buf.append(HEX_DIGITS[b >> 4 & 0xF]);
            buf.append(HEX_DIGITS[b & 0xF]);
            ++i;
        }
        return buf;
    }

    static {
        try {
            sDigester = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

