/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.search.dam.indexqueuequerymanagers;

import com.uwyn.rife.database.Datasource;
import com.uwyn.rife.database.DbQueryManager;
import com.uwyn.rife.database.DbTransactionUser;
import com.uwyn.rife.database.DbTransactionUserWithoutResult;
import com.uwyn.rife.database.exceptions.DatabaseException;
import com.uwyn.rife.database.querymanagers.generic.GenericQueryManager;
import com.uwyn.rife.database.querymanagers.generic.GenericQueryManagerFactory;
import com.uwyn.rife.search.dam.indexqueuequerymanagers.IndexQueue;
import com.uwyn.rife.search.dam.indexqueuequerymanagers.exceptions.IndexQueryManagerInstallationException;
import com.uwyn.rife.search.dam.indexqueuequerymanagers.exceptions.IndexQueryManagerRemovalException;
import com.uwyn.rife.search.dao.IndexDocument;
import com.uwyn.rife.search.dao.IndexField;
import com.uwyn.rife.tools.ExceptionUtils;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public abstract class AbstractIndexQueue
extends DbQueryManager
implements IndexQueue {
    private GenericQueryManager<IndexDocument> mIndexDocumentManager = null;
    private GenericQueryManager<IndexField> mIndexFieldManager = null;

    static /* synthetic */ void access$S1000000(AbstractIndexQueue abstractIndexQueue, GenericQueryManager genericQueryManager) {
        abstractIndexQueue.mIndexDocumentManager = genericQueryManager;
    }

    static /* synthetic */ void access$S1000001(AbstractIndexQueue abstractIndexQueue, GenericQueryManager genericQueryManager) {
        abstractIndexQueue.mIndexFieldManager = genericQueryManager;
    }

    public AbstractIndexQueue(Datasource datasource) {
        super(datasource);
        Class<?> clazz;
        Class<?> clazz2;
        try {
            clazz2 = Class.forName("com.uwyn.rife.search.dao.IndexDocument");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mIndexDocumentManager = GenericQueryManagerFactory.getInstance((Datasource)this.getDatasource(), clazz2);
        try {
            clazz = Class.forName("com.uwyn.rife.search.dao.IndexField");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        this.mIndexFieldManager = GenericQueryManagerFactory.getInstance((Datasource)this.getDatasource(), clazz);
    }

    public void create() throws IndexQueryManagerInstallationException {
        try {
            this.mIndexDocumentManager.install();
            this.mIndexFieldManager.install();
        }
        catch (DatabaseException e) {
            throw new IndexQueryManagerInstallationException(e);
        }
    }

    public void remove() throws IndexQueryManagerRemovalException {
        try {
            this.mIndexFieldManager.remove();
            this.mIndexDocumentManager.remove();
        }
        catch (DatabaseException e) {
            throw new IndexQueryManagerRemovalException(e);
        }
    }

    public boolean saveDocument(String indexName, Document doc) {
        try {
            this.inTransaction((DbTransactionUser)new 1(indexName, doc));
        }
        catch (Exception e) {
            Logger.getLogger("com.uwyn.rife.search.dam").severe(ExceptionUtils.getExceptionStackTrace((Throwable)e));
            return false;
        }
        return true;
    }

    class 1
    extends DbTransactionUserWithoutResult {
        private final /* synthetic */ String val$indexName;
        private final /* synthetic */ Document val$doc;

        1(String string, Document document) {
            this.val$indexName = string;
            this.val$doc = document;
        }

        public void useTransactionWithoutResult() {
            IndexDocument index_document = new IndexDocument();
            index_document.setIndexName(this.val$indexName);
            int documentId = AbstractIndexQueue.this.mIndexDocumentManager.save((Object)index_document);
            Enumeration enumeration = this.val$doc.fields();
            while (enumeration.hasMoreElements()) {
                Field field = (Field)enumeration.nextElement();
                IndexField index_field = new IndexField().indexDocumentId(documentId).name(field.name()).value(field.stringValue()).isStore(field.isStored()).isIndex(field.isIndexed()).isToken(field.isTokenized());
                AbstractIndexQueue.this.mIndexFieldManager.save((Object)index_field);
            }
        }

        static /* synthetic */ AbstractIndexQueue access$0(1 var0) {
            return var0.AbstractIndexQueue.this;
        }
    }
}

