/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.0.0).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package dev.crashteam.openapi.kerepricer.api;

import dev.crashteam.openapi.kerepricer.model.AddKeAccountRequest;
import dev.crashteam.openapi.kerepricer.model.AddKeAccountShopItemCompetitorRequest;
import dev.crashteam.openapi.kerepricer.model.AddKeAccountShopItemPoolRequest;
import dev.crashteam.openapi.kerepricer.model.Error;
import dev.crashteam.openapi.kerepricer.model.GetKeAccountShopItemPoolCount200Response;
import dev.crashteam.openapi.kerepricer.model.GetKeAccounts400Response;
import dev.crashteam.openapi.kerepricer.model.KeAccount;
import dev.crashteam.openapi.kerepricer.model.KeAccountCompetitorShopItem;
import dev.crashteam.openapi.kerepricer.model.KeAccountShop;
import dev.crashteam.openapi.kerepricer.model.KeAccountShopItem;
import dev.crashteam.openapi.kerepricer.model.PatchKeAccount;
import dev.crashteam.openapi.kerepricer.model.PatchKeAccountMonitoringState;
import dev.crashteam.openapi.kerepricer.model.RemoveKeAccountShopItemPoolRequest;
import dev.crashteam.openapi.kerepricer.model.SimilarItem;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import org.springframework.http.codec.multipart.Part;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-08-03T11:50:55.652978393Z[Etc/UTC]")
@Validated
@Tag(name = "accounts", description = "the accounts API")
public interface AccountsApi {

    /**
     * POST /accounts : Добавить KazanExpress аккаунт
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param addKeAccountRequest  (optional)
     * @return Аккаунт добавлен (status code 201)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     */
    @Operation(
        operationId = "addKeAccount",
        summary = "Добавить KazanExpress аккаунт",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Аккаунт добавлен", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccount.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/accounts",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<KeAccount>> addKeAccount(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "AddKeAccountRequest", description = "") @Valid @RequestBody(required = false) Mono<AddKeAccountRequest> addKeAccountRequest,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\", \"name\" : \"name\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\" }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * POST /accounts/{id}/shop-item-competitor : Добавить конкурентный товар для отслеживания
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param addKeAccountShopItemCompetitorRequest  (optional)
     * @return Конкурентный товар добавлен (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Достигнуто максимальное кол-во товаров в пуле (status code 409)
     */
    @Operation(
        operationId = "addKeAccountShopItemCompetitor",
        summary = "Добавить конкурентный товар для отслеживания",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Конкурентный товар добавлен"),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "409", description = "Достигнуто максимальное кол-во товаров в пуле")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/accounts/{id}/shop-item-competitor",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> addKeAccountShopItemCompetitor(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "AddKeAccountShopItemCompetitorRequest", description = "") @Valid @RequestBody(required = false) Mono<AddKeAccountShopItemCompetitorRequest> addKeAccountShopItemCompetitorRequest,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * POST /accounts/{id}/pool-items : Добавить товар в пул для отслеживания
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param addKeAccountShopItemPoolRequest  (optional)
     * @return Товар добавлен (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Достигнуто максимальное кол-во товаров в пуле (status code 409)
     */
    @Operation(
        operationId = "addKeAccountShopItemPool",
        summary = "Добавить товар в пул для отслеживания",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Товар добавлен"),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "409", description = "Достигнуто максимальное кол-во товаров в пуле")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/accounts/{id}/pool-items",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> addKeAccountShopItemPool(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "AddKeAccountShopItemPoolRequest", description = "") @Valid @RequestBody(required = false) Mono<AddKeAccountShopItemPoolRequest> addKeAccountShopItemPoolRequest,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * DELETE /accounts/{id} : Удалить аккаунт KazanExpress
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @return Аккаунт KazanExpress удален. (status code 204)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Resource was not found (status code 404)
     */
    @Operation(
        operationId = "deleteKeAccount",
        summary = "Удалить аккаунт KazanExpress",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "204", description = "Аккаунт KazanExpress удален."),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Resource was not found", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/accounts/{id}",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> deleteKeAccount(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id} : Получить данные аккаунта KazanExpress
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @return Получены данные аккаунта KazanExpress (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Аккаунт не найден (status code 404)
     */
    @Operation(
        operationId = "getKeAccount",
        summary = "Получить данные аккаунта KazanExpress",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получены данные аккаунта KazanExpress", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccount.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Аккаунт не найден")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<KeAccount>> getKeAccount(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\", \"name\" : \"name\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\" }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id}/shop/{shopId}/competitor-items : Получение списка назначенных конкурентов товара
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param shopId  (required)
     * @param limit The collection items limit. (optional)
     * @param offset The collection items offset. (optional)
     * @param filter The collection items filter requires a special format. Use \&quot;,\&quot; for multiple allowed values.  Use \&quot;;\&quot; for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format.  (optional)
     * @param sort The collection items sort field and order (prefix with \&quot;-\&quot; for descending sort). (optional)
     * @return Получен список товаров магазина пользователя (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Товары не найдены (status code 404)
     */
    @Operation(
        operationId = "getKeAccountCompetitorShopItems",
        summary = "Получение списка назначенных конкурентов товара",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список товаров магазина пользователя", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccountCompetitorShopItem.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Товары не найдены")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}/shop/{shopId}/competitor-items",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<KeAccountCompetitorShopItem>>> getKeAccountCompetitorShopItems(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "shopId", description = "", required = true) @PathVariable("shopId") UUID shopId,
        @Min(0) @Max(1000) @Parameter(name = "limit", description = "The collection items limit.") @Valid @RequestParam(value = "limit", required = false) Integer limit,
        @Min(0) @Parameter(name = "offset", description = "The collection items offset.") @Valid @RequestParam(value = "offset", required = false) Integer offset,
        @Parameter(name = "filter", description = "The collection items filter requires a special format. Use \",\" for multiple allowed values.  Use \";\" for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format. ") @Valid @RequestParam(value = "filter", required = false) String filter,
        @Parameter(name = "sort", description = "The collection items sort field and order (prefix with \"-\" for descending sort).") @Valid @RequestParam(value = "sort", required = false) List<String> sort,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"productId\" : 0.8008281904610115, \"availableAmount\" : 1.4658129805029452, \"name\" : \"name\", \"sellPrice\" : 10, \"fullPrice\" : 10, \"skuId\" : 6.027456183070403 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id}/pool-items-count : Получить кол-во товаров в пуле
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @return Кол-во товаров в пуле (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     */
    @Operation(
        operationId = "getKeAccountShopItemPoolCount",
        summary = "Получить кол-во товаров в пуле",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Кол-во товаров в пуле", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccountShopItemPoolCount200Response.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}/pool-items-count",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<GetKeAccountShopItemPoolCount200Response>> getKeAccountShopItemPoolCount(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"count\" : 0.8008281904610115 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id}/shop/{shopId}/similar : Получение списка возможных конкурентных товаров
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param shopId  (required)
     * @return Получен список возможных конкурентных товаров (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Товары не найдены (status code 404)
     */
    @Operation(
        operationId = "getKeAccountShopItemSimilar",
        summary = "Получение списка возможных конкурентных товаров",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список возможных конкурентных товаров", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SimilarItem.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Товары не найдены")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}/shop/{shopId}/similar",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<SimilarItem>>> getKeAccountShopItemSimilar(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "shopId", description = "", required = true) @PathVariable("shopId") UUID shopId,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"productId\" : 0.8008281904610115, \"photoKey\" : \"photoKey\", \"name\" : \"name\", \"skuId\" : 6.027456183070403 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id}/shop/{shopId}/items : Получение списка товаров магазина пользователя
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param shopId  (required)
     * @param limit The collection items limit. (optional)
     * @param offset The collection items offset. (optional)
     * @param filter The collection items filter requires a special format. Use \&quot;,\&quot; for multiple allowed values.  Use \&quot;;\&quot; for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format.  (optional)
     * @param sort The collection items sort field and order (prefix with \&quot;-\&quot; for descending sort). (optional)
     * @return Получен список товаров магазина пользователя (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Товары не найдены (status code 404)
     */
    @Operation(
        operationId = "getKeAccountShopItems",
        summary = "Получение списка товаров магазина пользователя",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список товаров магазина пользователя", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccountShopItem.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Товары не найдены")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}/shop/{shopId}/items",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<KeAccountShopItem>>> getKeAccountShopItems(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "shopId", description = "", required = true) @PathVariable("shopId") UUID shopId,
        @Min(0) @Max(1000) @Parameter(name = "limit", description = "The collection items limit.") @Valid @RequestParam(value = "limit", required = false) Integer limit,
        @Min(0) @Parameter(name = "offset", description = "The collection items offset.") @Valid @RequestParam(value = "offset", required = false) Integer offset,
        @Parameter(name = "filter", description = "The collection items filter requires a special format. Use \",\" for multiple allowed values.  Use \";\" for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format. ") @Valid @RequestParam(value = "filter", required = false) String filter,
        @Parameter(name = "sort", description = "The collection items sort field and order (prefix with \"-\" for descending sort).") @Valid @RequestParam(value = "sort", required = false) List<String> sort,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"productId\" : \"productId\", \"availableAmount\" : 6.027456183070403, \"photoKey\" : \"photoKey\", \"name\" : \"name\", \"sellPrice\" : 10, \"step\" : 1.4658129805029452, \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"minimumThreshold\" : 10, \"fullPrice\" : 10, \"barcode\" : 0.8008281904610115, \"skuId\" : \"skuId\", \"maximumThreshold\" : 10 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id}/shop/{shopId}/pool-items : Получение списка товаров магазина пользователя в пуле для отслеживания
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param shopId  (required)
     * @param limit The collection items limit. (optional)
     * @param offset The collection items offset. (optional)
     * @param filter The collection items filter requires a special format. Use \&quot;,\&quot; for multiple allowed values.  Use \&quot;;\&quot; for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format.  (optional)
     * @param sort The collection items sort field and order (prefix with \&quot;-\&quot; for descending sort). (optional)
     * @return Получен список товаров магазина пользователя (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Товары не найдены (status code 404)
     */
    @Operation(
        operationId = "getKeAccountShopItemsPool",
        summary = "Получение списка товаров магазина пользователя в пуле для отслеживания",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список товаров магазина пользователя", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccountShopItem.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Товары не найдены")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}/shop/{shopId}/pool-items",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<KeAccountShopItem>>> getKeAccountShopItemsPool(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "shopId", description = "", required = true) @PathVariable("shopId") UUID shopId,
        @Min(0) @Max(1000) @Parameter(name = "limit", description = "The collection items limit.") @Valid @RequestParam(value = "limit", required = false) Integer limit,
        @Min(0) @Parameter(name = "offset", description = "The collection items offset.") @Valid @RequestParam(value = "offset", required = false) Integer offset,
        @Parameter(name = "filter", description = "The collection items filter requires a special format. Use \",\" for multiple allowed values.  Use \";\" for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format. ") @Valid @RequestParam(value = "filter", required = false) String filter,
        @Parameter(name = "sort", description = "The collection items sort field and order (prefix with \"-\" for descending sort).") @Valid @RequestParam(value = "sort", required = false) List<String> sort,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"productId\" : \"productId\", \"availableAmount\" : 6.027456183070403, \"photoKey\" : \"photoKey\", \"name\" : \"name\", \"sellPrice\" : 10, \"step\" : 1.4658129805029452, \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"minimumThreshold\" : 10, \"fullPrice\" : 10, \"barcode\" : 0.8008281904610115, \"skuId\" : \"skuId\", \"maximumThreshold\" : 10 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id}/shops : Получение списка магазинов аккаунта
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @return Получен список магазинов KazanExpress для указанного аккаунта (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Аккаунты не найдены (status code 404)
     */
    @Operation(
        operationId = "getKeAccountShops",
        summary = "Получение списка магазинов аккаунта",
        tags = { "shop" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список магазинов KazanExpress для указанного аккаунта", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccountShop.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Аккаунты не найдены")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}/shops",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<KeAccountShop>>> getKeAccountShops(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"name\" : \"name\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\" }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts : Получение списка KazanExpress аккаунтов
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @return Получен список KazanExpress аккаунтов (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Аккаунты не найдены (status code 404)
     */
    @Operation(
        operationId = "getKeAccounts",
        summary = "Получение списка KazanExpress аккаунтов",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список KazanExpress аккаунтов", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccount.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Аккаунты не найдены")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<KeAccount>>> getKeAccounts(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\", \"name\" : \"name\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\" }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * PATCH /accounts/{id} : Обновить данные аккаунта KazanExpress
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param patchKeAccount  (optional)
     * @return Данные аккаунта KazanExpress обновлены. (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Аккаунт не найден (status code 404)
     */
    @Operation(
        operationId = "patchKeAccount",
        summary = "Обновить данные аккаунта KazanExpress",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Данные аккаунта KazanExpress обновлены."),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Аккаунт не найден")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.PATCH,
        value = "/accounts/{id}",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> patchKeAccount(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "PatchKeAccount", description = "") @Valid @RequestBody(required = false) Mono<PatchKeAccount> patchKeAccount,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * PATCH /accounts/{id}/monitor : Переключить состояние мониторинга аккаунта KazanExpress
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param patchKeAccountMonitoringState  (optional)
     * @return Состояние мониторинга изменено (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Аккаунт не найден (status code 404)
     */
    @Operation(
        operationId = "patchKeAccountMonitoringState",
        summary = "Переключить состояние мониторинга аккаунта KazanExpress",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Состояние мониторинга изменено"),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Аккаунт не найден")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.PATCH,
        value = "/accounts/{id}/monitor",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> patchKeAccountMonitoringState(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "PatchKeAccountMonitoringState", description = "") @Valid @RequestBody(required = false) Mono<PatchKeAccountMonitoringState> patchKeAccountMonitoringState,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * DELETE /accounts/{id}/shop-item-competitor : Удалить конкурентный товар из списка отслеживаемых
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param addKeAccountShopItemCompetitorRequest  (optional)
     * @return Конкурентный товар удален (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     */
    @Operation(
        operationId = "removeKeAccountShopItemCompetitor",
        summary = "Удалить конкурентный товар из списка отслеживаемых",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Конкурентный товар удален"),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/accounts/{id}/shop-item-competitor",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> removeKeAccountShopItemCompetitor(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "AddKeAccountShopItemCompetitorRequest", description = "") @Valid @RequestBody(required = false) Mono<AddKeAccountShopItemCompetitorRequest> addKeAccountShopItemCompetitorRequest,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * DELETE /accounts/{id}/pool-items : Удалить товар из пула для отслеживания
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param removeKeAccountShopItemPoolRequest  (optional)
     * @return Товар удален (status code 204)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     */
    @Operation(
        operationId = "removeKeAccountShopItemPool",
        summary = "Удалить товар из пула для отслеживания",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "204", description = "Товар удален"),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/accounts/{id}/pool-items",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> removeKeAccountShopItemPool(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "RemoveKeAccountShopItemPoolRequest", description = "") @Valid @RequestBody(required = false) Mono<RemoveKeAccountShopItemPoolRequest> removeKeAccountShopItemPoolRequest,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * POST /accounts/{id}/update : Обновить данные аккунта в системе (исходя из данных в KazanExpress)
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param addKeAccountRequest  (optional)
     * @return Задача на обновление аккаунта добавлена (status code 200)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     */
    @Operation(
        operationId = "updateKeAccountData",
        summary = "Обновить данные аккунта в системе (исходя из данных в KazanExpress)",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Задача на обновление аккаунта добавлена"),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/accounts/{id}/update",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> updateKeAccountData(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "AddKeAccountRequest", description = "") @Valid @RequestBody(required = false) Mono<AddKeAccountRequest> addKeAccountRequest,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }

}
