/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.0.0).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package dev.crashteam.openapi.kerepricer.api;

import dev.crashteam.openapi.kerepricer.model.Error;
import dev.crashteam.openapi.kerepricer.model.GetKeAccounts400Response;
import dev.crashteam.openapi.kerepricer.model.KeAccountPriceChangeHistory;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import org.springframework.http.codec.multipart.Part;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-08-03T11:50:55.652978393Z[Etc/UTC]")
@Validated
@Tag(name = "account", description = "the account API")
public interface AccountApi {

    /**
     * GET /account/{id}/price-history : Получение истории изменений цены товаров на KazanExpress аккаунте
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param limit The collection items limit. (optional)
     * @param offset The collection items offset. (optional)
     * @param filter The collection items filter requires a special format. Use \&quot;,\&quot; for multiple allowed values.  Use \&quot;;\&quot; for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format.  (optional)
     * @param sort The collection items sort field and order (prefix with \&quot;-\&quot; for descending sort). (optional)
     * @return Получен список истории изменений цены товаров (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or История не найдена (status code 404)
     */
    @Operation(
        operationId = "getKeAccountShopItemPriceChangeHistory",
        summary = "Получение истории изменений цены товаров на KazanExpress аккаунте",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список истории изменений цены товаров", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccountPriceChangeHistory.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "История не найдена")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/account/{id}/price-history",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<KeAccountPriceChangeHistory>>> getKeAccountShopItemPriceChangeHistory(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Min(0) @Max(1000) @Parameter(name = "limit", description = "The collection items limit.") @Valid @RequestParam(value = "limit", required = false) Integer limit,
        @Min(0) @Parameter(name = "offset", description = "The collection items offset.") @Valid @RequestParam(value = "offset", required = false) Integer offset,
        @Parameter(name = "filter", description = "The collection items filter requires a special format. Use \",\" for multiple allowed values.  Use \";\" for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format. ") @Valid @RequestParam(value = "filter", required = false) String filter,
        @Parameter(name = "sort", description = "The collection items sort field and order (prefix with \"-\" for descending sort).") @Valid @RequestParam(value = "sort", required = false) List<String> sort,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"itemName\" : \"itemName\", \"oldPrice\" : 10, \"shopName\" : \"shopName\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"newPrice\" : 10, \"barcode\" : 0.8008281904610115 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }

}
