/*
 * Decompiled with CFR 0.152.
 */
package dev.crashteam.openapi.kerepricer.api;

import dev.crashteam.openapi.kerepricer.api.ApiUtil;
import dev.crashteam.openapi.kerepricer.model.Error;
import dev.crashteam.openapi.kerepricer.model.GetKeAccounts400Response;
import dev.crashteam.openapi.kerepricer.model.Subscription;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.UUID;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Validated
@Tag(name="subscriptions", description="the subscriptions API")
public interface SubscriptionsApi {
    @Operation(operationId="getSubscriptions", summary="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a", tags={"subscription"}, responses={@ApiResponse(responseCode="200", description="\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u043f\u043e\u0434\u043f\u0438\u0441\u043e\u043a", content={@Content(mediaType="application/json", schema=@Schema(implementation=Subscription.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.GET}, value={"/subscriptions"}, produces={"application/json"})
    default public Mono<ResponseEntity<Flux<Subscription>>> getSubscriptions(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"price\" : 0, \"name\" : \"name\" }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }
}

