package dev.crashteam.openapi.kerepricer.model;

import java.net.URI;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import dev.crashteam.openapi.kerepricer.model.SubscriptionPlan;
import org.openapitools.jackson.nullable.JsonNullable;
import java.time.OffsetDateTime;
import javax.validation.Valid;
import javax.validation.constraints.*;
import io.swagger.v3.oas.annotations.media.Schema;


import java.util.*;
import javax.annotation.Generated;

/**
 * CreateSubsriptionPaymentRequest
 */

@JsonTypeName("createSubsriptionPayment_request")
@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-09-20T19:20:31.401001698Z[Etc/UTC]")
public class CreateSubsriptionPaymentRequest {

  @JsonProperty("subscriptionPlan")
  private SubscriptionPlan subscriptionPlan;

  @JsonProperty("multiply")
  private Integer multiply;

  @JsonProperty("redirectUrl")
  private String redirectUrl;

  public CreateSubsriptionPaymentRequest subscriptionPlan(SubscriptionPlan subscriptionPlan) {
    this.subscriptionPlan = subscriptionPlan;
    return this;
  }

  /**
   * Get subscriptionPlan
   * @return subscriptionPlan
  */
  @NotNull @Valid 
  @Schema(name = "subscriptionPlan", required = true)
  public SubscriptionPlan getSubscriptionPlan() {
    return subscriptionPlan;
  }

  public void setSubscriptionPlan(SubscriptionPlan subscriptionPlan) {
    this.subscriptionPlan = subscriptionPlan;
  }

  public CreateSubsriptionPaymentRequest multiply(Integer multiply) {
    this.multiply = multiply;
    return this;
  }

  /**
   * Срок на который приобретается подписка. Наприме 1 = 1 месяц
   * minimum: 1
   * maximum: 6
   * @return multiply
  */
  @NotNull @Min(1) @Max(6) 
  @Schema(name = "multiply", description = "Срок на который приобретается подписка. Наприме 1 = 1 месяц", required = true)
  public Integer getMultiply() {
    return multiply;
  }

  public void setMultiply(Integer multiply) {
    this.multiply = multiply;
  }

  public CreateSubsriptionPaymentRequest redirectUrl(String redirectUrl) {
    this.redirectUrl = redirectUrl;
    return this;
  }

  /**
   * Куда перенаправлять пользователя после проведения платежа
   * @return redirectUrl
  */
  @NotNull 
  @Schema(name = "redirectUrl", description = "Куда перенаправлять пользователя после проведения платежа", required = true)
  public String getRedirectUrl() {
    return redirectUrl;
  }

  public void setRedirectUrl(String redirectUrl) {
    this.redirectUrl = redirectUrl;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CreateSubsriptionPaymentRequest createSubsriptionPaymentRequest = (CreateSubsriptionPaymentRequest) o;
    return Objects.equals(this.subscriptionPlan, createSubsriptionPaymentRequest.subscriptionPlan) &&
        Objects.equals(this.multiply, createSubsriptionPaymentRequest.multiply) &&
        Objects.equals(this.redirectUrl, createSubsriptionPaymentRequest.redirectUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(subscriptionPlan, multiply, redirectUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CreateSubsriptionPaymentRequest {\n");
    sb.append("    subscriptionPlan: ").append(toIndentedString(subscriptionPlan)).append("\n");
    sb.append("    multiply: ").append(toIndentedString(multiply)).append("\n");
    sb.append("    redirectUrl: ").append(toIndentedString(redirectUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

