/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech) (6.0.0).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */
package dev.crashteam.openapi.kerepricer.api;

import dev.crashteam.openapi.kerepricer.model.AddKeAccountRequest;
import dev.crashteam.openapi.kerepricer.model.AddKeAccountShopItemCompetitorRequest;
import dev.crashteam.openapi.kerepricer.model.AddKeAccountShopItemPoolRequest;
import dev.crashteam.openapi.kerepricer.model.Error;
import dev.crashteam.openapi.kerepricer.model.GetAccountShopItemPoolCount200Response;
import dev.crashteam.openapi.kerepricer.model.GetKeAccounts400Response;
import dev.crashteam.openapi.kerepricer.model.KeAccount;
import dev.crashteam.openapi.kerepricer.model.KeAccountCompetitorShopItem;
import dev.crashteam.openapi.kerepricer.model.KeAccountPriceChangeHistory;
import dev.crashteam.openapi.kerepricer.model.KeAccountShop;
import dev.crashteam.openapi.kerepricer.model.KeAccountShopItem;
import dev.crashteam.openapi.kerepricer.model.PatchKeAccount;
import dev.crashteam.openapi.kerepricer.model.PatchKeAccount409Response;
import dev.crashteam.openapi.kerepricer.model.PatchKeAccountMonitoringState;
import dev.crashteam.openapi.kerepricer.model.PatchKeAccountShopItem;
import dev.crashteam.openapi.kerepricer.model.RemoveKeAccountShopItemCompetitorRequest;
import dev.crashteam.openapi.kerepricer.model.SimilarItem;
import java.util.UUID;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import org.springframework.http.codec.multipart.Part;

import javax.validation.Valid;
import javax.validation.constraints.*;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Generated;

@Generated(value = "org.openapitools.codegen.languages.SpringCodegen", date = "2022-09-20T19:20:31.401001698Z[Etc/UTC]")
@Validated
@Tag(name = "accounts", description = "the accounts API")
public interface AccountsApi {

    /**
     * POST /accounts : Добавить KazanExpress аккаунт
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param addKeAccountRequest  (optional)
     * @return Аккаунт добавлен (status code 201)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     */
    @Operation(
        operationId = "addKeAccount",
        summary = "Добавить KazanExpress аккаунт",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "201", description = "Аккаунт добавлен", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccount.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/accounts",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<KeAccount>> addKeAccount(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "AddKeAccountRequest", description = "") @Valid @RequestBody(required = false) Mono<AddKeAccountRequest> addKeAccountRequest,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\", \"name\" : \"name\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"email\" : \"email\" }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * POST /accounts/{id}/shop-item-competitor : Добавить конкурентный товар для отслеживания
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param addKeAccountShopItemCompetitorRequest  (optional)
     * @return Конкурентный товар добавлен (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Достигнуто максимальное кол-во товаров в пуле (status code 409)
     */
    @Operation(
        operationId = "addKeAccountShopItemCompetitor",
        summary = "Добавить конкурентный товар для отслеживания",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Конкурентный товар добавлен"),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "409", description = "Достигнуто максимальное кол-во товаров в пуле")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/accounts/{id}/shop-item-competitor",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> addKeAccountShopItemCompetitor(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "AddKeAccountShopItemCompetitorRequest", description = "") @Valid @RequestBody(required = false) Mono<AddKeAccountShopItemCompetitorRequest> addKeAccountShopItemCompetitorRequest,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * POST /accounts/{id}/pool-items : Добавить товар в пул для отслеживания
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param addKeAccountShopItemPoolRequest  (optional)
     * @return Товар добавлен (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Достигнуто максимальное кол-во товаров в пуле (status code 409)
     */
    @Operation(
        operationId = "addKeAccountShopItemPool",
        summary = "Добавить товар в пул для отслеживания",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Товар добавлен"),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "409", description = "Достигнуто максимальное кол-во товаров в пуле")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/accounts/{id}/pool-items",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> addKeAccountShopItemPool(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "AddKeAccountShopItemPoolRequest", description = "") @Valid @RequestBody(required = false) Mono<AddKeAccountShopItemPoolRequest> addKeAccountShopItemPoolRequest,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * DELETE /accounts/{id} : Удалить аккаунт KazanExpress
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @return Аккаунт KazanExpress удален. (status code 204)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Resource was not found (status code 404)
     */
    @Operation(
        operationId = "deleteKeAccount",
        summary = "Удалить аккаунт KazanExpress",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "204", description = "Аккаунт KazanExpress удален."),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Resource was not found", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/accounts/{id}",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> deleteKeAccount(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/pool-items-count : Получить общее кол-во товаров в пуле на отслеживание
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @return Кол-во товаров в пуле (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     */
    @Operation(
        operationId = "getAccountShopItemPoolCount",
        summary = "Получить общее кол-во товаров в пуле на отслеживание",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Кол-во товаров в пуле", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetAccountShopItemPoolCount200Response.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/pool-items-count",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<GetAccountShopItemPoolCount200Response>> getAccountShopItemPoolCount(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"count\" : 0 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id} : Получить данные аккаунта KazanExpress
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @return Получены данные аккаунта KazanExpress (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Аккаунт не найден (status code 404)
     */
    @Operation(
        operationId = "getKeAccount",
        summary = "Получить данные аккаунта KazanExpress",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получены данные аккаунта KazanExpress", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccount.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Аккаунт не найден")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<KeAccount>> getKeAccount(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\", \"name\" : \"name\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"email\" : \"email\" }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id}/shops/{shopId}/items/{shopItemId}/competitor-items : Получение списка назначенных конкурентов товара
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param shopId  (required)
     * @param shopItemId  (required)
     * @param limit The collection items limit. (optional)
     * @param offset The collection items offset. (optional)
     * @param filter The collection items filter requires a special format. Use \&quot;,\&quot; for multiple allowed values.  Use \&quot;;\&quot; for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format.  (optional)
     * @param sort The collection items sort field and order (prefix with \&quot;-\&quot; for descending sort). (optional)
     * @return Получен список назначенных конкурентов товара (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Товары не найдены (status code 404)
     */
    @Operation(
        operationId = "getKeAccountCompetitorShopItems",
        summary = "Получение списка назначенных конкурентов товара",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список назначенных конкурентов товара", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccountCompetitorShopItem.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Товары не найдены")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}/shops/{shopId}/items/{shopItemId}/competitor-items",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<KeAccountCompetitorShopItem>>> getKeAccountCompetitorShopItems(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "shopId", description = "", required = true) @PathVariable("shopId") UUID shopId,
        @Parameter(name = "shopItemId", description = "", required = true) @PathVariable("shopItemId") UUID shopItemId,
        @Min(0) @Max(1000) @Parameter(name = "limit", description = "The collection items limit.") @Valid @RequestParam(value = "limit", required = false) Integer limit,
        @Min(0) @Parameter(name = "offset", description = "The collection items offset.") @Valid @RequestParam(value = "offset", required = false) Integer offset,
        @Parameter(name = "filter", description = "The collection items filter requires a special format. Use \",\" for multiple allowed values.  Use \";\" for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format. ") @Valid @RequestParam(value = "filter", required = false) String filter,
        @Parameter(name = "sort", description = "The collection items sort field and order (prefix with \"-\" for descending sort).") @Valid @RequestParam(value = "sort", required = false) List<String> sort,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"productId\" : 0, \"availableAmount\" : 1, \"price\" : 10, \"name\" : \"name\", \"skuId\" : 6 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id}/items/{shopItemId} : Получить информацию по товару пользователя
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param shopItemId  (required)
     * @return Получена информация о товаре пользователя (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Resource was not found (status code 404)
     */
    @Operation(
        operationId = "getKeAccountShopItem",
        summary = "Получить информацию по товару пользователя",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получена информация о товаре пользователя", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccountShopItem.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Resource was not found", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}/items/{shopItemId}",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<KeAccountShopItem>> getKeAccountShopItem(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "shopItemId", description = "", required = true) @PathVariable("shopItemId") UUID shopItemId,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"productId\" : 0, \"availableAmount\" : 5, \"photoKey\" : \"photoKey\", \"price\" : 10, \"name\" : \"name\", \"step\" : 5, \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"minimumThreshold\" : 10, \"barcode\" : 1, \"skuId\" : 6, \"maximumThreshold\" : 10 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id}/price-history : Получение истории изменений цены товаров на KazanExpress аккаунте
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param limit The collection items limit. (optional)
     * @param offset The collection items offset. (optional)
     * @param filter The collection items filter requires a special format. Use \&quot;,\&quot; for multiple allowed values.  Use \&quot;;\&quot; for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format.  (optional)
     * @param sort The collection items sort field and order (prefix with \&quot;-\&quot; for descending sort). (optional)
     * @return Получен список истории изменений цены товаров (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or История не найдена (status code 404)
     */
    @Operation(
        operationId = "getKeAccountShopItemPriceChangeHistory",
        summary = "Получение истории изменений цены товаров на KazanExpress аккаунте",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список истории изменений цены товаров", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccountPriceChangeHistory.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "История не найдена")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}/price-history",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<KeAccountPriceChangeHistory>>> getKeAccountShopItemPriceChangeHistory(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Min(0) @Max(1000) @Parameter(name = "limit", description = "The collection items limit.") @Valid @RequestParam(value = "limit", required = false) Integer limit,
        @Min(0) @Parameter(name = "offset", description = "The collection items offset.") @Valid @RequestParam(value = "offset", required = false) Integer offset,
        @Parameter(name = "filter", description = "The collection items filter requires a special format. Use \",\" for multiple allowed values.  Use \";\" for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format. ") @Valid @RequestParam(value = "filter", required = false) String filter,
        @Parameter(name = "sort", description = "The collection items sort field and order (prefix with \"-\" for descending sort).") @Valid @RequestParam(value = "sort", required = false) List<String> sort,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"itemName\" : \"itemName\", \"productId\" : 0, \"oldPrice\" : 10, \"shopName\" : \"shopName\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"newPrice\" : 10, \"barcode\" : 1, \"skuId\" : 6 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id}/shops/{shopId}/items/{shopItemId}/similar : Получение списка возможных конкурентных товаров
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param shopId  (required)
     * @param shopItemId  (required)
     * @return Получен список возможных конкурентных товаров (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Товары не найдены (status code 404)
     */
    @Operation(
        operationId = "getKeAccountShopItemSimilar",
        summary = "Получение списка возможных конкурентных товаров",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список возможных конкурентных товаров", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = SimilarItem.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Товары не найдены")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}/shops/{shopId}/items/{shopItemId}/similar",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<SimilarItem>>> getKeAccountShopItemSimilar(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "shopId", description = "", required = true) @PathVariable("shopId") UUID shopId,
        @Parameter(name = "shopItemId", description = "", required = true) @PathVariable("shopItemId") UUID shopItemId,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"productId\" : 0, \"photoKey\" : \"photoKey\", \"name\" : \"name\", \"skuId\" : 6 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id}/shops/{shopId}/items : Получение списка товаров магазина пользователя
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param shopId  (required)
     * @param limit The collection items limit. (optional)
     * @param offset The collection items offset. (optional)
     * @param filter The collection items filter requires a special format. Use \&quot;,\&quot; for multiple allowed values.  Use \&quot;;\&quot; for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format.  (optional)
     * @param sort The collection items sort field and order (prefix with \&quot;-\&quot; for descending sort). (optional)
     * @return Получен список товаров магазина пользователя (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Товары не найдены (status code 404)
     */
    @Operation(
        operationId = "getKeAccountShopItems",
        summary = "Получение списка товаров магазина пользователя",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список товаров магазина пользователя", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccountShopItem.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Товары не найдены")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}/shops/{shopId}/items",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<KeAccountShopItem>>> getKeAccountShopItems(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "shopId", description = "", required = true) @PathVariable("shopId") UUID shopId,
        @Min(0) @Max(1000) @Parameter(name = "limit", description = "The collection items limit.") @Valid @RequestParam(value = "limit", required = false) Integer limit,
        @Min(0) @Parameter(name = "offset", description = "The collection items offset.") @Valid @RequestParam(value = "offset", required = false) Integer offset,
        @Parameter(name = "filter", description = "The collection items filter requires a special format. Use \",\" for multiple allowed values.  Use \";\" for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format. ") @Valid @RequestParam(value = "filter", required = false) String filter,
        @Parameter(name = "sort", description = "The collection items sort field and order (prefix with \"-\" for descending sort).") @Valid @RequestParam(value = "sort", required = false) List<String> sort,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"productId\" : 0, \"availableAmount\" : 5, \"photoKey\" : \"photoKey\", \"price\" : 10, \"name\" : \"name\", \"step\" : 5, \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"minimumThreshold\" : 10, \"barcode\" : 1, \"skuId\" : 6, \"maximumThreshold\" : 10 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id}/shops/{shopId}/pool-items : Получение списка товаров магазина пользователя в пуле для отслеживания
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param shopId  (required)
     * @param limit The collection items limit. (optional)
     * @param offset The collection items offset. (optional)
     * @param filter The collection items filter requires a special format. Use \&quot;,\&quot; for multiple allowed values.  Use \&quot;;\&quot; for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format.  (optional)
     * @param sort The collection items sort field and order (prefix with \&quot;-\&quot; for descending sort). (optional)
     * @return Получен список товаров магазина пользователя (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Товары не найдены (status code 404)
     */
    @Operation(
        operationId = "getKeAccountShopItemsPool",
        summary = "Получение списка товаров магазина пользователя в пуле для отслеживания",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список товаров магазина пользователя", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccountShopItem.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Товары не найдены")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}/shops/{shopId}/pool-items",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<KeAccountShopItem>>> getKeAccountShopItemsPool(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "shopId", description = "", required = true) @PathVariable("shopId") UUID shopId,
        @Min(0) @Max(1000) @Parameter(name = "limit", description = "The collection items limit.") @Valid @RequestParam(value = "limit", required = false) Integer limit,
        @Min(0) @Parameter(name = "offset", description = "The collection items offset.") @Valid @RequestParam(value = "offset", required = false) Integer offset,
        @Parameter(name = "filter", description = "The collection items filter requires a special format. Use \",\" for multiple allowed values.  Use \";\" for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format. ") @Valid @RequestParam(value = "filter", required = false) String filter,
        @Parameter(name = "sort", description = "The collection items sort field and order (prefix with \"-\" for descending sort).") @Valid @RequestParam(value = "sort", required = false) List<String> sort,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"productId\" : 0, \"availableAmount\" : 5, \"photoKey\" : \"photoKey\", \"price\" : 10, \"name\" : \"name\", \"step\" : 5, \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"minimumThreshold\" : 10, \"barcode\" : 1, \"skuId\" : 6, \"maximumThreshold\" : 10 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts/{id}/shops : Получение списка магазинов аккаунта
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @return Получен список магазинов KazanExpress для указанного аккаунта (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Аккаунты не найдены (status code 404)
     */
    @Operation(
        operationId = "getKeAccountShops",
        summary = "Получение списка магазинов аккаунта",
        tags = { "shop" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список магазинов KazanExpress для указанного аккаунта", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccountShop.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Аккаунты не найдены")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts/{id}/shops",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<KeAccountShop>>> getKeAccountShops(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"name\" : \"name\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\" }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * GET /accounts : Получение списка KazanExpress аккаунтов
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @return Получен список KazanExpress аккаунтов (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Аккаунты не найдены (status code 404)
     */
    @Operation(
        operationId = "getKeAccounts",
        summary = "Получение списка KazanExpress аккаунтов",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Получен список KazanExpress аккаунтов", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccount.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Аккаунты не найдены")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.GET,
        value = "/accounts",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Flux<KeAccount>>> getKeAccounts(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\", \"name\" : \"name\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"email\" : \"email\" }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * PATCH /accounts/{id} : Обновить данные аккаунта KazanExpress
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param patchKeAccount  (optional)
     * @return Данные аккаунта KazanExpress обновлены. (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Аккаунт не найден (status code 404)
     *         or Conflict. (status code 409)
     */
    @Operation(
        operationId = "patchKeAccount",
        summary = "Обновить данные аккаунта KazanExpress",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Данные аккаунта KazanExpress обновлены."),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Аккаунт не найден"),
            @ApiResponse(responseCode = "409", description = "Conflict.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = PatchKeAccount409Response.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.PATCH,
        value = "/accounts/{id}",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> patchKeAccount(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "PatchKeAccount", description = "") @Valid @RequestBody(required = false) Mono<PatchKeAccount> patchKeAccount,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * PATCH /accounts/{id}/initialization : Запустить работу по инициализации аккаунта KazanExpress
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @return Инициализация аккаунта запущена в работу (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Аккаунт не найден (status code 404)
     */
    @Operation(
        operationId = "patchKeAccountInitializationState",
        summary = "Запустить работу по инициализации аккаунта KazanExpress",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Инициализация аккаунта запущена в работу"),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Аккаунт не найден")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.PATCH,
        value = "/accounts/{id}/initialization",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> patchKeAccountInitializationState(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * PATCH /accounts/{id}/monitor : Переключить состояние мониторинга аккаунта KazanExpress
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param patchKeAccountMonitoringState  (optional)
     * @return Состояние мониторинга изменено (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Аккаунт не найден (status code 404)
     */
    @Operation(
        operationId = "patchKeAccountMonitoringState",
        summary = "Переключить состояние мониторинга аккаунта KazanExpress",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Состояние мониторинга изменено"),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Аккаунт не найден")
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.PATCH,
        value = "/accounts/{id}/monitor",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> patchKeAccountMonitoringState(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "PatchKeAccountMonitoringState", description = "") @Valid @RequestBody(required = false) Mono<PatchKeAccountMonitoringState> patchKeAccountMonitoringState,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * PATCH /accounts/{id}/items/{shopItemId} : Редактировать параметры изменения цены товара
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param shopItemId  (required)
     * @param patchKeAccountShopItem  (required)
     * @return Параметры успешно отредактированы (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Resource was not found (status code 404)
     */
    @Operation(
        operationId = "patchKeAccountShopitem",
        summary = "Редактировать параметры изменения цены товара",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Параметры успешно отредактированы", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = KeAccountShopItem.class))
            }),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "404", description = "Resource was not found", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.PATCH,
        value = "/accounts/{id}/items/{shopItemId}",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<KeAccountShopItem>> patchKeAccountShopitem(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "shopItemId", description = "", required = true) @PathVariable("shopItemId") UUID shopItemId,
        @Parameter(name = "PatchKeAccountShopItem", description = "", required = true) @Valid @RequestBody Mono<PatchKeAccountShopItem> patchKeAccountShopItem,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (mediaType.isCompatibleWith(MediaType.valueOf("application/json"))) {
                String exampleString = "{ \"productId\" : 0, \"availableAmount\" : 5, \"photoKey\" : \"photoKey\", \"price\" : 10, \"name\" : \"name\", \"step\" : 5, \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"minimumThreshold\" : 10, \"barcode\" : 1, \"skuId\" : 6, \"maximumThreshold\" : 10 }";
                result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
                break;
            }
        }
        return result.then(Mono.empty());

    }


    /**
     * DELETE /accounts/{id}/shop-item-competitor : Удалить конкурентный товар из списка отслеживаемых
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param removeKeAccountShopItemCompetitorRequest  (optional)
     * @return Конкурентный товар удален (status code 200)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     */
    @Operation(
        operationId = "removeKeAccountShopItemCompetitor",
        summary = "Удалить конкурентный товар из списка отслеживаемых",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Конкурентный товар удален"),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/accounts/{id}/shop-item-competitor",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> removeKeAccountShopItemCompetitor(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "RemoveKeAccountShopItemCompetitorRequest", description = "") @Valid @RequestBody(required = false) Mono<RemoveKeAccountShopItemCompetitorRequest> removeKeAccountShopItemCompetitorRequest,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * DELETE /accounts/{id}/pool-items : Удалить товар из пула для отслеживания
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @param addKeAccountShopItemPoolRequest  (optional)
     * @return Товар удален (status code 204)
     *         or Переданы ошибочные данные (status code 400)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     */
    @Operation(
        operationId = "removeKeAccountShopItemFromPool",
        summary = "Удалить товар из пула для отслеживания",
        tags = { "item" },
        responses = {
            @ApiResponse(responseCode = "204", description = "Товар удален"),
            @ApiResponse(responseCode = "400", description = "Переданы ошибочные данные", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = GetKeAccounts400Response.class))
            }),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.DELETE,
        value = "/accounts/{id}/pool-items",
        produces = { "application/json" },
        consumes = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> removeKeAccountShopItemFromPool(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(name = "AddKeAccountShopItemPoolRequest", description = "") @Valid @RequestBody(required = false) Mono<AddKeAccountShopItemPoolRequest> addKeAccountShopItemPoolRequest,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }


    /**
     * POST /accounts/{id}/update : Обновить данные аккунта в системе (в соответствии с данными в KazanExpress)
     *
     * @param xRequestID Уникальный идентификатор запроса к системе (required)
     * @param id  (required)
     * @return Задача на обновление аккаунта добавлена (status code 200)
     *         or Несанкционированный доступ, использовались неверные учетные данные. (status code 401)
     *         or Доступ запрещен. (status code 403)
     *         or Conflict. (status code 409)
     */
    @Operation(
        operationId = "updateKeAccountData",
        summary = "Обновить данные аккунта в системе (в соответствии с данными в KazanExpress)",
        tags = { "account" },
        responses = {
            @ApiResponse(responseCode = "200", description = "Задача на обновление аккаунта добавлена"),
            @ApiResponse(responseCode = "401", description = "Несанкционированный доступ, использовались неверные учетные данные.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "403", description = "Доступ запрещен.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = Error.class))
            }),
            @ApiResponse(responseCode = "409", description = "Conflict.", content = {
                @Content(mediaType = "application/json", schema = @Schema(implementation = PatchKeAccount409Response.class))
            })
        },
        security = {
            @SecurityRequirement(name = "bearer")
        }
    )
    @RequestMapping(
        method = RequestMethod.POST,
        value = "/accounts/{id}/update",
        produces = { "application/json" }
    )
    default Mono<ResponseEntity<Void>> updateKeAccountData(
        @Parameter(name = "X-Request-ID", description = "Уникальный идентификатор запроса к системе", required = true) @RequestHeader(value = "X-Request-ID", required = true) UUID xRequestID,
        @Parameter(name = "id", description = "", required = true) @PathVariable("id") UUID id,
        @Parameter(hidden = true) final ServerWebExchange exchange
    ) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());

    }

}
