/*
 * Decompiled with CFR 0.152.
 */
package dev.crashteam.openapi.kerepricer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;

public class Error {
    @JsonProperty(value="status")
    private Integer status;
    @JsonProperty(value="error")
    private String error;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="title")
    private String title;

    public Error status(Integer status) {
        this.status = status;
        return this;
    }

    @Min(value=100L)
    @Max(value=600L)
    @Schema(name="status", description="The HTTP status code.", required=false)
    public @Min(value=100L) @Max(value=600L) Integer getStatus() {
        return this.status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Error error(String error) {
        this.error = error;
        return this;
    }

    @Schema(name="error", required=false)
    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Error type(String type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", description="A URI reference [[RFC3986](https://tools.ietf.org/html/rfc3986)] that identifies the problem type. It should provide human-readable documentation for the problem type. When this member is not present, its value is assumed to be \"about:blank\".", required=false)
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Error title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="A short, human-readable summary of the problem type. It SHOULD NOT change from occurrence to occurrence of the problem, except for purposes of localization.", required=false)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Error error = (Error)o;
        return Objects.equals(this.status, error.status) && Objects.equals(this.error, error.error) && Objects.equals(this.type, error.type) && Objects.equals(this.title, error.title);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.error, this.type, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Error {\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    error: ").append(this.toIndentedString(this.error)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

