/*
 * Decompiled with CFR 0.152.
 */
package dev.crashteam.openapi.kerepricer.api;

import dev.crashteam.openapi.kerepricer.api.ApiUtil;
import dev.crashteam.openapi.kerepricer.model.AddKeAccountRequest;
import dev.crashteam.openapi.kerepricer.model.AddKeAccountShopItemCompetitorRequest;
import dev.crashteam.openapi.kerepricer.model.AddKeAccountShopItemPoolRequest;
import dev.crashteam.openapi.kerepricer.model.Error;
import dev.crashteam.openapi.kerepricer.model.GetAccountShopItemPoolCount200Response;
import dev.crashteam.openapi.kerepricer.model.GetKeAccounts400Response;
import dev.crashteam.openapi.kerepricer.model.KeAccount;
import dev.crashteam.openapi.kerepricer.model.KeAccountCompetitorShopItem;
import dev.crashteam.openapi.kerepricer.model.KeAccountPriceChangeHistory;
import dev.crashteam.openapi.kerepricer.model.KeAccountShop;
import dev.crashteam.openapi.kerepricer.model.KeAccountShopItem;
import dev.crashteam.openapi.kerepricer.model.PatchKeAccount;
import dev.crashteam.openapi.kerepricer.model.PatchKeAccountMonitoringState;
import dev.crashteam.openapi.kerepricer.model.RemoveKeAccountShopItemCompetitorRequest;
import dev.crashteam.openapi.kerepricer.model.SimilarItem;
import dev.crashteam.openapi.kerepricer.model.UpdateKeAccountData409Response;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Validated
@Tag(name="accounts", description="the accounts API")
public interface AccountsApi {
    @Operation(operationId="addKeAccount", summary="\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c KazanExpress \u0430\u043a\u043a\u0430\u0443\u043d\u0442", tags={"account"}, responses={@ApiResponse(responseCode="201", description="\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d", content={@Content(mediaType="application/json", schema=@Schema(implementation=KeAccount.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.POST}, value={"/accounts"}, produces={"application/json"}, consumes={"application/json"})
    default public Mono<ResponseEntity<KeAccount>> addKeAccount(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="AddKeAccountRequest", description="") @Valid @RequestBody(required=false) Mono<AddKeAccountRequest> addKeAccountRequest, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\", \"name\" : \"name\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\" }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="addKeAccountShopItemCompetitor", summary="\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043a\u043e\u043d\u043a\u0443\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u0442\u043e\u0432\u0430\u0440 \u0434\u043b\u044f \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u044f", tags={"item"}, responses={@ApiResponse(responseCode="200", description="\u041a\u043e\u043d\u043a\u0443\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u0442\u043e\u0432\u0430\u0440 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d"), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="409", description="\u0414\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b-\u0432\u043e \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0432 \u043f\u0443\u043b\u0435")}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.POST}, value={"/accounts/{id}/shop-item-competitor"}, produces={"application/json"}, consumes={"application/json"})
    default public Mono<ResponseEntity<Void>> addKeAccountShopItemCompetitor(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(name="AddKeAccountShopItemCompetitorRequest", description="") @Valid @RequestBody(required=false) Mono<AddKeAccountShopItemCompetitorRequest> addKeAccountShopItemCompetitorRequest, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }

    @Operation(operationId="addKeAccountShopItemPool", summary="\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u0442\u043e\u0432\u0430\u0440 \u0432 \u043f\u0443\u043b \u0434\u043b\u044f \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u044f", tags={"item"}, responses={@ApiResponse(responseCode="200", description="\u0422\u043e\u0432\u0430\u0440 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d"), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="409", description="\u0414\u043e\u0441\u0442\u0438\u0433\u043d\u0443\u0442\u043e \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b-\u0432\u043e \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0432 \u043f\u0443\u043b\u0435")}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.POST}, value={"/accounts/{id}/pool-items"}, produces={"application/json"}, consumes={"application/json"})
    default public Mono<ResponseEntity<Void>> addKeAccountShopItemPool(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(name="AddKeAccountShopItemPoolRequest", description="") @Valid @RequestBody(required=false) Mono<AddKeAccountShopItemPoolRequest> addKeAccountShopItemPoolRequest, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }

    @Operation(operationId="deleteKeAccount", summary="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442 KazanExpress", tags={"account"}, responses={@ApiResponse(responseCode="204", description="\u0410\u043a\u043a\u0430\u0443\u043d\u0442 KazanExpress \u0443\u0434\u0430\u043b\u0435\u043d."), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="Resource was not found", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/accounts/{id}"}, produces={"application/json"})
    default public Mono<ResponseEntity<Void>> deleteKeAccount(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }

    @Operation(operationId="getAccountShopItemPoolCount", summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043e\u0431\u0449\u0435\u0435 \u043a\u043e\u043b-\u0432\u043e \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0432 \u043f\u0443\u043b\u0435 \u043d\u0430 \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u0435", tags={"item"}, responses={@ApiResponse(responseCode="200", description="\u041a\u043e\u043b-\u0432\u043e \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u0432 \u043f\u0443\u043b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetAccountShopItemPoolCount200Response.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.GET}, value={"/accounts/pool-items-count"}, produces={"application/json"})
    default public Mono<ResponseEntity<GetAccountShopItemPoolCount200Response>> getAccountShopItemPoolCount(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"count\" : 0 }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="getKeAccount", summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 KazanExpress", tags={"account"}, responses={@ApiResponse(responseCode="200", description="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u044b \u0434\u0430\u043d\u043d\u044b\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 KazanExpress", content={@Content(mediaType="application/json", schema=@Schema(implementation=KeAccount.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.GET}, value={"/accounts/{id}"}, produces={"application/json"})
    default public Mono<ResponseEntity<KeAccount>> getKeAccount(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\", \"name\" : \"name\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\" }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="getKeAccountCompetitorShopItems", summary="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044b\u0445 \u043a\u043e\u043d\u043a\u0443\u0440\u0435\u043d\u0442\u043e\u0432 \u0442\u043e\u0432\u0430\u0440\u0430", tags={"item"}, responses={@ApiResponse(responseCode="200", description="\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044b\u0445 \u043a\u043e\u043d\u043a\u0443\u0440\u0435\u043d\u0442\u043e\u0432 \u0442\u043e\u0432\u0430\u0440\u0430", content={@Content(mediaType="application/json", schema=@Schema(implementation=KeAccountCompetitorShopItem.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="\u0422\u043e\u0432\u0430\u0440\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b")}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.GET}, value={"/accounts/{id}/shops/{shopId}/items/{shopItemId}/competitor-items"}, produces={"application/json"})
    default public Mono<ResponseEntity<Flux<KeAccountCompetitorShopItem>>> getKeAccountCompetitorShopItems(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(name="shopId", description="", required=true) @PathVariable(value="shopId") UUID shopId, @Parameter(name="shopItemId", description="", required=true) @PathVariable(value="shopItemId") UUID shopItemId, @Min(value=0L) @Max(value=1000L) @Parameter(name="limit", description="The collection items limit.") @Valid @RequestParam(value="limit", required=false) @Min(value=0L) @Max(value=1000L) @Valid Integer limit, @Min(value=0L) @Parameter(name="offset", description="The collection items offset.") @Valid @RequestParam(value="offset", required=false) @Min(value=0L) @Valid Integer offset, @Parameter(name="filter", description="The collection items filter requires a special format. Use \",\" for multiple allowed values.  Use \";\" for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format. ") @Valid @RequestParam(value="filter", required=false) String filter, @Parameter(name="sort", description="The collection items sort field and order (prefix with \"-\" for descending sort).") @Valid @RequestParam(value="sort", required=false) List<String> sort, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"productId\" : 0, \"availableAmount\" : 1, \"price\" : 10, \"name\" : \"name\", \"skuId\" : 6 }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="getKeAccountShopItem", summary="\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043f\u043e \u0442\u043e\u0432\u0430\u0440\u0443 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", tags={"item"}, responses={@ApiResponse(responseCode="200", description="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u0442\u043e\u0432\u0430\u0440\u0435 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", content={@Content(mediaType="application/json", schema=@Schema(implementation=KeAccountShopItem.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="\u0422\u043e\u0432\u0430\u0440 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.GET}, value={"/accounts/{id}/items/{shopItemId}"}, produces={"application/json"})
    default public Mono<ResponseEntity<KeAccountShopItem>> getKeAccountShopItem(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(name="shopItemId", description="", required=true) @PathVariable(value="shopItemId") UUID shopItemId, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"productId\" : 0, \"availableAmount\" : 5, \"photoKey\" : \"photoKey\", \"name\" : \"name\", \"sellPrice\" : 10, \"step\" : 5, \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"minimumThreshold\" : 10, \"fullPrice\" : 10, \"barcode\" : 1, \"skuId\" : 6, \"maximumThreshold\" : 10 }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="getKeAccountShopItemPriceChangeHistory", summary="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0440\u0438\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0446\u0435\u043d\u044b \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u043d\u0430 KazanExpress \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0435", tags={"item"}, responses={@ApiResponse(responseCode="200", description="\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u0438\u0441\u0442\u043e\u0440\u0438\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0446\u0435\u043d\u044b \u0442\u043e\u0432\u0430\u0440\u043e\u0432", content={@Content(mediaType="application/json", schema=@Schema(implementation=KeAccountPriceChangeHistory.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430")}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.GET}, value={"/accounts/{id}/price-history"}, produces={"application/json"})
    default public Mono<ResponseEntity<Flux<KeAccountPriceChangeHistory>>> getKeAccountShopItemPriceChangeHistory(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Min(value=0L) @Max(value=1000L) @Parameter(name="limit", description="The collection items limit.") @Valid @RequestParam(value="limit", required=false) @Min(value=0L) @Max(value=1000L) @Valid Integer limit, @Min(value=0L) @Parameter(name="offset", description="The collection items offset.") @Valid @RequestParam(value="offset", required=false) @Min(value=0L) @Valid Integer offset, @Parameter(name="sort", description="The collection items sort field and order (prefix with \"-\" for descending sort).") @Valid @RequestParam(value="sort", required=false) List<String> sort, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"itemName\" : \"itemName\", \"productId\" : 0, \"oldPrice\" : 10, \"shopName\" : \"shopName\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"newPrice\" : 10, \"barcode\" : 1, \"skuId\" : 6 }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="getKeAccountShopItemSimilar", summary="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0445 \u043a\u043e\u043d\u043a\u0443\u0440\u0435\u043d\u0442\u043d\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432", tags={"item"}, responses={@ApiResponse(responseCode="200", description="\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b\u0445 \u043a\u043e\u043d\u043a\u0443\u0440\u0435\u043d\u0442\u043d\u044b\u0445 \u0442\u043e\u0432\u0430\u0440\u043e\u0432", content={@Content(mediaType="application/json", schema=@Schema(implementation=SimilarItem.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="\u0422\u043e\u0432\u0430\u0440\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b")}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.GET}, value={"/accounts/{id}/shops/{shopId}/items/{shopItemId}/similar"}, produces={"application/json"})
    default public Mono<ResponseEntity<Flux<SimilarItem>>> getKeAccountShopItemSimilar(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(name="shopId", description="", required=true) @PathVariable(value="shopId") UUID shopId, @Parameter(name="shopItemId", description="", required=true) @PathVariable(value="shopItemId") UUID shopItemId, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"productId\" : 0, \"photoKey\" : \"photoKey\", \"name\" : \"name\", \"skuId\" : 6 }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="getKeAccountShopItems", summary="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", tags={"item"}, responses={@ApiResponse(responseCode="200", description="\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", content={@Content(mediaType="application/json", schema=@Schema(implementation=KeAccountShopItem.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="\u0422\u043e\u0432\u0430\u0440\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b")}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.GET}, value={"/accounts/{id}/shops/{shopId}/items"}, produces={"application/json"})
    default public Mono<ResponseEntity<Flux<KeAccountShopItem>>> getKeAccountShopItems(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(name="shopId", description="", required=true) @PathVariable(value="shopId") UUID shopId, @Min(value=0L) @Max(value=1000L) @Parameter(name="limit", description="The collection items limit.") @Valid @RequestParam(value="limit", required=false) @Min(value=0L) @Max(value=1000L) @Valid Integer limit, @Min(value=0L) @Parameter(name="offset", description="The collection items offset.") @Valid @RequestParam(value="offset", required=false) @Min(value=0L) @Valid Integer offset, @Parameter(name="filter", description="The collection items filter requires a special format. Use \",\" for multiple allowed values.  Use \";\" for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format. ") @Valid @RequestParam(value="filter", required=false) String filter, @Parameter(name="sort", description="The collection items sort field and order (prefix with \"-\" for descending sort).") @Valid @RequestParam(value="sort", required=false) List<String> sort, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"productId\" : 0, \"availableAmount\" : 5, \"photoKey\" : \"photoKey\", \"name\" : \"name\", \"sellPrice\" : 10, \"step\" : 5, \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"minimumThreshold\" : 10, \"fullPrice\" : 10, \"barcode\" : 1, \"skuId\" : 6, \"maximumThreshold\" : 10 }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="getKeAccountShopItemsPool", summary="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u0432 \u043f\u0443\u043b\u0435 \u0434\u043b\u044f \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u044f", tags={"item"}, responses={@ApiResponse(responseCode="200", description="\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u0442\u043e\u0432\u0430\u0440\u043e\u0432 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u0430 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f", content={@Content(mediaType="application/json", schema=@Schema(implementation=KeAccountShopItem.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="\u0422\u043e\u0432\u0430\u0440\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b")}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.GET}, value={"/accounts/{id}/shops/{shopId}/pool-items"}, produces={"application/json"})
    default public Mono<ResponseEntity<Flux<KeAccountShopItem>>> getKeAccountShopItemsPool(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(name="shopId", description="", required=true) @PathVariable(value="shopId") UUID shopId, @Min(value=0L) @Max(value=1000L) @Parameter(name="limit", description="The collection items limit.") @Valid @RequestParam(value="limit", required=false) @Min(value=0L) @Max(value=1000L) @Valid Integer limit, @Min(value=0L) @Parameter(name="offset", description="The collection items offset.") @Valid @RequestParam(value="offset", required=false) @Min(value=0L) @Valid Integer offset, @Parameter(name="filter", description="The collection items filter requires a special format. Use \",\" for multiple allowed values.  Use \";\" for multiple fields. See the [filter guide](https://api-reference.rebilly.com/#section/Using-filter-with-collections) for more options and examples about this format. ") @Valid @RequestParam(value="filter", required=false) String filter, @Parameter(name="sort", description="The collection items sort field and order (prefix with \"-\" for descending sort).") @Valid @RequestParam(value="sort", required=false) List<String> sort, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"productId\" : 0, \"availableAmount\" : 5, \"photoKey\" : \"photoKey\", \"name\" : \"name\", \"sellPrice\" : 10, \"step\" : 5, \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\", \"minimumThreshold\" : 10, \"fullPrice\" : 10, \"barcode\" : 1, \"skuId\" : 6, \"maximumThreshold\" : 10 }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="getKeAccountShops", summary="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", tags={"shop"}, responses={@ApiResponse(responseCode="200", description="\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u043c\u0430\u0433\u0430\u0437\u0438\u043d\u043e\u0432 KazanExpress \u0434\u043b\u044f \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u043e\u0433\u043e \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", content={@Content(mediaType="application/json", schema=@Schema(implementation=KeAccountShop.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="\u0410\u043a\u043a\u0430\u0443\u043d\u0442\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b")}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.GET}, value={"/accounts/{id}/shops"}, produces={"application/json"})
    default public Mono<ResponseEntity<Flux<KeAccountShop>>> getKeAccountShops(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"name\" : \"name\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\" }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="getKeAccounts", summary="\u041f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u043f\u0438\u0441\u043a\u0430 KazanExpress \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432", tags={"account"}, responses={@ApiResponse(responseCode="200", description="\u041f\u043e\u043b\u0443\u0447\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a KazanExpress \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432", content={@Content(mediaType="application/json", schema=@Schema(implementation=KeAccount.class))}), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="\u0410\u043a\u043a\u0430\u0443\u043d\u0442\u044b \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b")}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.GET}, value={"/accounts"}, produces={"application/json"})
    default public Mono<ResponseEntity<Flux<KeAccount>>> getKeAccounts(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono<Void> result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        for (MediaType mediaType : exchange.getRequest().getHeaders().getAccept()) {
            if (!mediaType.isCompatibleWith(MediaType.valueOf((String)"application/json"))) continue;
            String exampleString = "{ \"lastUpdate\" : \"2000-01-23T04:56:07.000+00:00\", \"name\" : \"name\", \"id\" : \"046b6c7f-0b8a-43b9-b35d-6489e6daee91\" }";
            result = ApiUtil.getExampleResponse(exchange, mediaType, exampleString);
            break;
        }
        return result.then(Mono.empty());
    }

    @Operation(operationId="patchKeAccount", summary="\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 KazanExpress", tags={"account"}, responses={@ApiResponse(responseCode="200", description="\u0414\u0430\u043d\u043d\u044b\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 KazanExpress \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u044b."), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/accounts/{id}"}, produces={"application/json"}, consumes={"application/json"})
    default public Mono<ResponseEntity<Void>> patchKeAccount(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(name="PatchKeAccount", description="") @Valid @RequestBody(required=false) Mono<PatchKeAccount> patchKeAccount, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }

    @Operation(operationId="patchKeAccountMonitoringState", summary="\u041f\u0435\u0440\u0435\u043a\u043b\u044e\u0447\u0438\u0442\u044c \u0441\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0438\u043d\u0433\u0430 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 KazanExpress", tags={"account"}, responses={@ApiResponse(responseCode="200", description="\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043c\u043e\u043d\u0438\u0442\u043e\u0440\u0438\u043d\u0433\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e"), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="404", description="\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d")}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.PATCH}, value={"/accounts/{id}/monitor"}, produces={"application/json"}, consumes={"application/json"})
    default public Mono<ResponseEntity<Void>> patchKeAccountMonitoringState(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(name="PatchKeAccountMonitoringState", description="") @Valid @RequestBody(required=false) Mono<PatchKeAccountMonitoringState> patchKeAccountMonitoringState, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }

    @Operation(operationId="removeKeAccountShopItemCompetitor", summary="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u043a\u043e\u043d\u043a\u0443\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u0442\u043e\u0432\u0430\u0440 \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430 \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0445", tags={"item"}, responses={@ApiResponse(responseCode="200", description="\u041a\u043e\u043d\u043a\u0443\u0440\u0435\u043d\u0442\u043d\u044b\u0439 \u0442\u043e\u0432\u0430\u0440 \u0443\u0434\u0430\u043b\u0435\u043d"), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/accounts/{id}/shop-item-competitor"}, produces={"application/json"}, consumes={"application/json"})
    default public Mono<ResponseEntity<Void>> removeKeAccountShopItemCompetitor(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(name="RemoveKeAccountShopItemCompetitorRequest", description="") @Valid @RequestBody(required=false) Mono<RemoveKeAccountShopItemCompetitorRequest> removeKeAccountShopItemCompetitorRequest, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }

    @Operation(operationId="removeKeAccountShopItemFromPool", summary="\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0442\u043e\u0432\u0430\u0440 \u0438\u0437 \u043f\u0443\u043b\u0430 \u0434\u043b\u044f \u043e\u0442\u0441\u043b\u0435\u0436\u0438\u0432\u0430\u043d\u0438\u044f", tags={"item"}, responses={@ApiResponse(responseCode="204", description="\u0422\u043e\u0432\u0430\u0440 \u0443\u0434\u0430\u043b\u0435\u043d"), @ApiResponse(responseCode="400", description="\u041f\u0435\u0440\u0435\u0434\u0430\u043d\u044b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetKeAccounts400Response.class))}), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))})}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.DELETE}, value={"/accounts/{id}/pool-items"}, produces={"application/json"}, consumes={"application/json"})
    default public Mono<ResponseEntity<Void>> removeKeAccountShopItemFromPool(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(name="AddKeAccountShopItemPoolRequest", description="") @Valid @RequestBody(required=false) Mono<AddKeAccountShopItemPoolRequest> addKeAccountShopItemPoolRequest, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }

    @Operation(operationId="updateKeAccountData", summary="\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u044b\u0435 \u0430\u043a\u043a\u0443\u043d\u0442\u0430 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 (\u0432 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0438\u0438 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c\u0438 \u0432 KazanExpress)", tags={"account"}, responses={@ApiResponse(responseCode="200", description="\u0417\u0430\u0434\u0430\u0447\u0430 \u043d\u0430 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430 \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430"), @ApiResponse(responseCode="401", description="\u041d\u0435\u0441\u0430\u043d\u043a\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u0434\u043e\u0441\u0442\u0443\u043f, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043b\u0438\u0441\u044c \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0435 \u0443\u0447\u0435\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="403", description="\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d.", content={@Content(mediaType="application/json", schema=@Schema(implementation=Error.class))}), @ApiResponse(responseCode="409", description="Conflict.", content={@Content(mediaType="application/json", schema=@Schema(implementation=UpdateKeAccountData409Response.class))})}, security={@SecurityRequirement(name="bearer")})
    @RequestMapping(method={RequestMethod.POST}, value={"/accounts/{id}/update"}, produces={"application/json"})
    default public Mono<ResponseEntity<Void>> updateKeAccountData(@Parameter(name="X-Request-ID", description="\u0423\u043d\u0438\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0441\u0438\u0441\u0442\u0435\u043c\u0435", required=true) @RequestHeader(value="X-Request-ID", required=true) UUID xRequestID, @Parameter(name="id", description="", required=true) @PathVariable(value="id") UUID id, @Parameter(hidden=true) ServerWebExchange exchange) {
        Mono result = Mono.empty();
        exchange.getResponse().setStatusCode(HttpStatus.NOT_IMPLEMENTED);
        return result.then(Mono.empty());
    }
}

