/*
 * Decompiled with CFR 0.152.
 */
package dev.crashteam.openapi.kerepricer.api;

import dev.crashteam.openapi.kerepricer.ApiClient;
import dev.crashteam.openapi.kerepricer.model.AccountSubscription;
import dev.crashteam.openapi.kerepricer.model.Subscription;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

@Component(value="dev.crashteam.openapi.kerepricer.api.SubscriptionApi")
public class SubscriptionApi {
    private ApiClient apiClient;

    public SubscriptionApi() {
        this(new ApiClient());
    }

    @Autowired
    public SubscriptionApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public List<Subscription> getSubscriptions(UUID xRequestID) throws RestClientException {
        return (List)this.getSubscriptionsWithHttpInfo(xRequestID).getBody();
    }

    public ResponseEntity<List<Subscription>> getSubscriptionsWithHttpInfo(UUID xRequestID) throws RestClientException {
        Object localVarPostBody = null;
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getSubscriptions");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (xRequestID != null) {
            localVarHeaderParams.add("X-Request-ID", this.apiClient.parameterToString(xRequestID));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearer"};
        ParameterizedTypeReference<List<Subscription>> localReturnType = new ParameterizedTypeReference<List<Subscription>>(){};
        return this.apiClient.invokeAPI("/subscriptions", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }

    public AccountSubscription getUserSubscription(UUID xRequestID) throws RestClientException {
        return (AccountSubscription)this.getUserSubscriptionWithHttpInfo(xRequestID).getBody();
    }

    public ResponseEntity<AccountSubscription> getUserSubscriptionWithHttpInfo(UUID xRequestID) throws RestClientException {
        Object localVarPostBody = null;
        if (xRequestID == null) {
            throw new HttpClientErrorException(HttpStatus.BAD_REQUEST, "Missing the required parameter 'xRequestID' when calling getUserSubscription");
        }
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarCookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (xRequestID != null) {
            localVarHeaderParams.add("X-Request-ID", this.apiClient.parameterToString(xRequestID));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"bearer"};
        ParameterizedTypeReference<AccountSubscription> localReturnType = new ParameterizedTypeReference<AccountSubscription>(){};
        return this.apiClient.invokeAPI("/user/subscription", HttpMethod.GET, Collections.emptyMap(), (MultiValueMap<String, String>)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap<String, String>)localVarCookieParams, (MultiValueMap<String, Object>)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, localReturnType);
    }
}

