/*
 * Decompiled with CFR 0.152.
 */
package dev.costas.minicli.models;

import java.util.HashMap;
import java.util.Map;

public class Invocation {
    private String command;
    private final Map<String, String> params;
    private final Map<String, Boolean> flags;

    public Invocation() {
        this.command = null;
        this.params = new HashMap<String, String>();
        this.flags = new HashMap<String, Boolean>();
    }

    public Invocation(String command) {
        this.command = command;
        this.params = new HashMap<String, String>();
        this.flags = new HashMap<String, Boolean>();
    }

    public Invocation(String command, Map<String, String> params, Map<String, Boolean> flags) {
        this.command = command;
        this.params = params;
        this.flags = flags;
    }

    public static String normalize(String str) {
        return str.toLowerCase().trim();
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = Invocation.normalize(command);
    }

    public Boolean getFlag(String key) {
        return this.flags.getOrDefault(Invocation.normalize(key), null);
    }

    public void putFlag(String key, Boolean value) {
        this.flags.put(key, value);
    }

    public String getParameter(String key) {
        return this.params.getOrDefault(Invocation.normalize(key), null);
    }

    public void putParameter(String key, String value) {
        this.params.put(key, value);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, Boolean> getFlags() {
        return this.flags;
    }
}

