/*
 * Decompiled with CFR 0.152.
 */
package dev.costas.minicli.defaults;

import dev.costas.minicli.annotation.Command;
import dev.costas.minicli.annotation.Flag;
import dev.costas.minicli.annotation.Parameter;
import dev.costas.minicli.framework.HelpGenerator;
import dev.costas.minicli.models.ApplicationParams;
import dev.costas.minicli.models.CommandOutput;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class LinearHelpGenerator
implements HelpGenerator {
    private static final String SPACES = " ".repeat(4);
    private static final String SEPARATOR = " - ";

    @Override
    public CommandOutput show(ApplicationParams application, List<Class<?>> classes) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nUsage: ").append(application.executable()).append(" [command] [options]\n");
        sb.append("===== Available commands =====").append("\n");
        for (Class<?> clazz : classes) {
            sb.append("\n").append(this.showCommand(clazz));
        }
        sb.append("\n").append(SPACES).append("h, help").append(SEPARATOR).append("Shows this help").append("\n").append(SPACES).append("q, quit").append(SEPARATOR).append("Quits the application").append("\n").append(SPACES).append("v, version").append(SEPARATOR).append("Shows the application version").append("\n").append("\n").append(application.name()).append(" ").append(application.version()).append("\n");
        return new CommandOutput(true, sb.toString());
    }

    @Override
    public CommandOutput show(ApplicationParams application, Class<?> clazz) {
        return new CommandOutput(false, this.showCommand(clazz));
    }

    private String showCommand(Class<?> clazz) {
        Command commandAnnotation = clazz.getAnnotation(Command.class);
        List<Parameter> parameters = this.getParameters(clazz);
        List<Flag> flags = this.getFlags(clazz);
        StringBuilder sb = new StringBuilder(SPACES);
        sb.append(commandAnnotation.name());
        if (!commandAnnotation.shortname().isEmpty()) {
            sb.append(", ").append(commandAnnotation.shortname());
        }
        sb.append(SEPARATOR).append(commandAnnotation.description());
        sb.append(this.printFlags(flags));
        sb.append(this.printParameters(parameters));
        return sb.toString();
    }

    private String printFlags(List<Flag> flags) {
        StringBuilder sb = new StringBuilder("\n");
        if (flags.size() > 0) {
            sb.append(SPACES.repeat(2)).append("Flags:").append("\n");
            for (Flag flag : flags) {
                sb.append(this.printOption(flag.name(), flag.shortName(), flag.description())).append("\n");
            }
        }
        return sb.toString();
    }

    private String printParameters(List<Parameter> parameters) {
        StringBuilder sb = new StringBuilder("\n");
        if (parameters.size() > 0) {
            sb.append(SPACES.repeat(2)).append("Parameters:").append("\n");
            for (Parameter parameter : parameters) {
                sb.append(this.printOption(parameter.name(), parameter.shortName(), parameter.description())).append("\n");
            }
        }
        return sb.toString();
    }

    private String printOption(String name, String shortName, String description) {
        StringBuilder line = new StringBuilder(SPACES.repeat(3));
        if (!shortName.equals("")) {
            line.append("-").append(shortName).append(", ");
        }
        line.append("--").append(name);
        line.append(SPACES).append(description);
        return line.toString();
    }

    private <T extends Annotation> List<T> getArgs(Class<?> clazz, Class<T> type) {
        return Arrays.stream(clazz.getDeclaredFields()).filter(f -> f.isAnnotationPresent(type)).sorted(Comparator.comparing(Field::getName)).map(f -> f.getAnnotation(type)).toList();
    }

    private List<Parameter> getParameters(Class<?> clazz) {
        return this.getArgs(clazz, Parameter.class);
    }

    private List<Flag> getFlags(Class<?> clazz) {
        return this.getArgs(clazz, Flag.class);
    }
}

