/*
 * Decompiled with CFR 0.152.
 */
package dev.costas.minicli.defaults;

import dev.costas.minicli.models.Invocation;
import org.jetbrains.annotations.NotNull;

public final class ArgumentParser {
    @NotNull
    public Invocation parse(String @NotNull [] args) {
        Invocation invocation = new Invocation();
        if (args.length == 0) {
            return invocation;
        }
        invocation.setCommand(args[0]);
        for (int i = 1; i < args.length; ++i) {
            String arg = args[i].toLowerCase();
            if (!arg.startsWith("-") && !arg.startsWith("--")) continue;
            String next = i + 1 < args.length ? args[i + 1].toLowerCase() : "";
            this.parseArg(arg, next, invocation);
        }
        return invocation;
    }

    private void parseArg(@NotNull String arg, @NotNull String value, Invocation invocation) {
        String key = arg.startsWith("--") ? arg.substring(2) : arg.substring(1);
        key = Invocation.normalize(key);
        String normalizedValue = value.toLowerCase().trim();
        if (value.startsWith("-") || value.startsWith("--") || value.equals("")) {
            invocation.putFlag(key, true);
        } else if (normalizedValue.equals("true")) {
            invocation.putFlag(key, true);
        } else if (normalizedValue.equals("false")) {
            invocation.putFlag(key, false);
        } else {
            invocation.putParameter(key, value);
        }
    }
}

