/*
 * Decompiled with CFR 0.152.
 */
package dev.costas.minicli;

import dev.costas.minicli.MinicliApplicationBuilder;
import dev.costas.minicli.RunnableCommand;
import dev.costas.minicli.annotation.Command;
import dev.costas.minicli.annotation.Flag;
import dev.costas.minicli.annotation.Parameter;
import dev.costas.minicli.defaults.ArgumentParser;
import dev.costas.minicli.exceptions.HelpException;
import dev.costas.minicli.exceptions.QuitException;
import dev.costas.minicli.framework.CommandExecutor;
import dev.costas.minicli.framework.HelpGenerator;
import dev.costas.minicli.framework.Instantiator;
import dev.costas.minicli.models.ApplicationParams;
import dev.costas.minicli.models.CommandOutput;
import dev.costas.minicli.models.Invocation;
import java.lang.reflect.Field;
import java.util.List;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class MinicliApplication {
    private final CommandExecutor commandExecutor;
    private final HelpGenerator helpGenerator;
    private final ApplicationParams application;
    private final Instantiator instantiator;

    protected MinicliApplication(CommandExecutor commandExecutor, HelpGenerator helpGenerator, ApplicationParams application, Instantiator instantiator) {
        this.commandExecutor = commandExecutor;
        this.helpGenerator = helpGenerator;
        this.application = application;
        this.instantiator = instantiator;
    }

    public static MinicliApplicationBuilder builder() {
        return new MinicliApplicationBuilder();
    }

    public CommandOutput run(Class<?> clazz, String[] args) throws QuitException {
        try {
            return this.actuallyRun(clazz, args);
        }
        catch (IllegalAccessException e) {
            return new CommandOutput(false, e.getMessage());
        }
    }

    private CommandOutput actuallyRun(Class<?> clazz, String[] args) throws QuitException, IllegalAccessException {
        List<Class<?>> classes = this.getCommands(clazz.getPackageName());
        if (args.length == 0) {
            return this.helpGenerator.show(this.application, classes);
        }
        if (args[0].equals("v") || args[0].equals("version")) {
            return new CommandOutput(true, this.application.formatted());
        }
        if (args[0].equals("quit") || args[0].equals("q") || args[0].equals("exit")) {
            throw new QuitException();
        }
        List<Class<?>> candidades = this.getCandidates(args[0], classes);
        if (args[0].equals("h") || args[0].equals("help")) {
            if (args.length == 2) {
                candidades = this.getCandidates(args[1], classes);
                return this.helpGenerator.show(this.application, candidades.get(0));
            }
            return this.helpGenerator.show(this.application, classes);
        }
        switch (candidades.size()) {
            case 0: {
                throw new RuntimeException("Command not found.");
            }
            case 1: {
                Object instance = this.instantiator.getInstance(candidades.get(0));
                if (!(instance instanceof RunnableCommand)) {
                    throw new RuntimeException("Command class must implement RunnableCommand");
                }
                try {
                    this.inflateInstance(instance, args);
                }
                catch (HelpException e) {
                    return this.helpGenerator.show(this.application, e.getClazz());
                }
                return this.commandExecutor.execute((RunnableCommand)instance);
            }
        }
        throw new RuntimeException("Multiple commands with the same name found.");
    }

    private void inflateInstance(Object instance, String[] args) throws IllegalAccessException, NumberFormatException, HelpException {
        ArgumentParser argumentParser = new ArgumentParser();
        Invocation invocation = argumentParser.parse(args);
        Class<?> clazz = instance.getClass();
        if (invocation.getFlags().containsKey("help") || invocation.getFlags().containsKey("h")) {
            throw new HelpException(clazz);
        }
        for (Field field : clazz.getDeclaredFields()) {
            Flag flagAnnotation = field.getAnnotation(Flag.class);
            if (flagAnnotation != null) {
                if (flagAnnotation.name().equals("")) {
                    throw new RuntimeException("Flag name cannot be empty.");
                }
                if (flagAnnotation.name().equals("help")) {
                    throw new RuntimeException("Flag name cannot be 'help'.");
                }
                this.inflateFlag(field, instance, invocation);
                continue;
            }
            Parameter parameterAnnotation = field.getAnnotation(Parameter.class);
            if (parameterAnnotation == null) continue;
            if (parameterAnnotation.name().equals("")) {
                throw new RuntimeException("Parameter name cannot be empty.");
            }
            if (parameterAnnotation.name().equals("help") || parameterAnnotation.name().equals("h") || parameterAnnotation.shortName().equals("h")) {
                throw new RuntimeException("Parameter name cannot be 'help'.");
            }
            this.inflateParameter(field, instance, invocation);
        }
    }

    private void inflateFlag(Field field, Object instance, Invocation invocation) throws IllegalAccessException {
        Flag flag = field.getAnnotation(Flag.class);
        if (field.getType() != Boolean.TYPE && field.getType() != Boolean.class) {
            throw new RuntimeException("Flag " + field.getName() + " must be a boolean.");
        }
        Boolean value = invocation.getFlag(flag.name());
        if (value == null) {
            value = invocation.getFlag(flag.shortName());
        }
        if (value == null) {
            value = flag.defaultValue();
        }
        field.setAccessible(true);
        field.set(instance, value);
        field.setAccessible(false);
    }

    private void inflateParameter(Field field, Object instance, Invocation invocation) throws IllegalAccessException, NumberFormatException {
        Parameter parameterAnnotation = field.getAnnotation(Parameter.class);
        String value = invocation.getParameter(parameterAnnotation.name());
        if (value == null) {
            value = invocation.getParameter(parameterAnnotation.shortName());
        }
        if (value == null) {
            if (parameterAnnotation.required()) {
                throw new RuntimeException("Required parameter " + parameterAnnotation.name() + " not found.");
            }
            value = invocation.getParameter(parameterAnnotation.defaultValue());
        }
        field.setAccessible(true);
        switch (field.getType().getName()) {
            case "java.lang.String": {
                field.set(instance, value);
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                field.set(instance, Integer.parseInt(value));
                break;
            }
            case "long": 
            case "java.lang.Long": {
                field.set(instance, Long.parseLong(value));
                break;
            }
            case "float": 
            case "java.lang.Float": {
                field.set(instance, Float.valueOf(Float.parseFloat(value)));
                break;
            }
            case "double": 
            case "java.lang.Double": {
                field.set(instance, Double.parseDouble(value));
                break;
            }
            default: {
                throw new RuntimeException("Unsupported parameter type " + field.getType().getName());
            }
        }
        field.setAccessible(false);
    }

    private List<Class<?>> getCommands(String prefix) {
        Reflections reflections = new Reflections(prefix, new Scanner[0]);
        List<String> forbiddenCommands = List.of("h", "help", "q", "quit", "exit", "v", "version");
        return reflections.getTypesAnnotatedWith(Command.class).stream().filter(c -> {
            String name = c.getAnnotation(Command.class).name().toLowerCase();
            String shortName = c.getAnnotation(Command.class).shortname().toLowerCase();
            return !forbiddenCommands.contains(name) && !forbiddenCommands.contains(shortName);
        }).toList();
    }

    private List<Class<?>> getCandidates(String arg, List<Class<?>> classes) {
        return classes.stream().filter(c -> {
            String name = c.getAnnotation(Command.class).name().toLowerCase();
            String shortName = c.getAnnotation(Command.class).shortname().toLowerCase();
            return name.equals(arg) || shortName.equals(arg);
        }).toList();
    }
}

