/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.AMPValidatorManager;
import dev.amp.validator.ParsedAttrSpec;
import dev.amp.validator.ValidatorProtos;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ParsedAttrSpecs {
    private final AMPValidatorManager validatorManager;
    private Map<String, ParsedAttrSpec> parsedAttrSpecs;

    public ParsedAttrSpecs(@Nonnull AMPValidatorManager validatorManager) {
        this.validatorManager = validatorManager;
        this.parsedAttrSpecs = new HashMap<String, ParsedAttrSpec>();
    }

    public ParsedAttrSpec getParsedAttrSpec(@Nonnull String tagName, @Nonnull String attrName, @Nonnull String value, @Nonnull ValidatorProtos.AttrSpec attrSpec) {
        String key = tagName + attrName + value;
        if (this.parsedAttrSpecs.containsKey(key)) {
            return this.parsedAttrSpecs.get(key);
        }
        ParsedAttrSpec parsed = new ParsedAttrSpec(attrSpec, attrName);
        this.parsedAttrSpecs.put(key, parsed);
        return parsed;
    }

    public List<ValidatorProtos.AttrSpec> getAttrListByName(@Nonnull String name) {
        ValidatorProtos.AttrList attrList = this.validatorManager.getAttrListMap().get(name);
        if (attrList != null) {
            return attrList.getAttrsList();
        }
        return Collections.emptyList();
    }

    public List<ValidatorProtos.AttrSpec> getGlobalAttrs() {
        return this.validatorManager.getGlobalAttrs();
    }

    public List<ValidatorProtos.AttrSpec> getAmpLayoutAttrs() {
        return this.validatorManager.getAmpLayoutAttrs();
    }

    public void cleanup() {
        this.parsedAttrSpecs = null;
    }
}

