/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.parser;

import com.yahoo.tagchowder.Parser;
import com.yahoo.tagchowder.templates.HTMLSchema;
import dev.amp.validator.AMPHtmlHandler;
import dev.amp.validator.AMPValidatorManager;
import dev.amp.validator.ExitCondition;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.parser.ParserException;
import dev.amp.validator.utils.ByteUtils;
import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import javax.annotation.Nonnull;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AMPHtmlParser {
    @Nonnull
    private final AMPValidatorManager validatorManager = new AMPValidatorManager();

    public AMPHtmlParser() throws ParserException {
        try {
            this.validatorManager.loadRule();
        }
        catch (IOException | URISyntaxException ex) {
            throw new ParserException("Unable to load AMP validation rules.", ex);
        }
    }

    public ValidatorProtos.ValidationResult parse(@Nonnull String inputHtml, @Nonnull ValidatorProtos.HtmlFormat.Code htmlFormat, @Nonnull ExitCondition condition) {
        return this.parse(inputHtml, htmlFormat, condition, 0);
    }

    public ValidatorProtos.ValidationResult parse(@Nonnull String inputHtml, @Nonnull ValidatorProtos.HtmlFormat.Code htmlFormat, @Nonnull ExitCondition condition, int maxNodes) {
        AMPHtmlHandler handler;
        block2: {
            Parser parser = new Parser();
            handler = new AMPHtmlHandler(this.validatorManager, htmlFormat, condition, maxNodes, ByteUtils.byteLength(inputHtml));
            try {
                parser.setContentHandler((ContentHandler)handler);
                parser.setProperty("schema", (Object)new HTMLSchema(true));
                parser.setFeature("default-attributes", false);
                parser.setFeature("https://github.com/ampproject/validator-java", true);
                parser.parse(new InputSource(new StringReader(inputHtml)));
            }
            catch (IOException | SAXException ex) {
                ValidatorProtos.ValidationResult.Builder result = handler.validationResult();
                result.setStatus(ValidatorProtos.ValidationResult.Status.FAIL);
                if (result.getErrorsCount() != 0) break block2;
                ValidatorProtos.ValidationError.Builder error = ValidatorProtos.ValidationError.newBuilder();
                error.setSeverity(ValidatorProtos.ValidationError.Severity.ERROR);
                error.setCode(ValidatorProtos.ValidationError.Code.UNKNOWN_CODE);
                String message = ex.getMessage() != null ? ex.getMessage() : "Unable to parse input HTML document";
                error.addParams(message);
                result.addErrors(error);
            }
        }
        return handler.validationResult().build();
    }
}

