/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.visitor;

import com.steadystate.css.parser.Token;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.AtRule;
import dev.amp.validator.css.CssTokenUtil;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.Declaration;
import dev.amp.validator.css.ErrorToken;
import dev.amp.validator.css.QualifiedRule;
import dev.amp.validator.css.TokenType;
import dev.amp.validator.utils.CssSpecUtils;
import dev.amp.validator.visitor.RuleVisitor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class Amp4AdsVisitor
implements RuleVisitor {
    @Nonnull
    private final List<ErrorToken> errors;
    @Nonnull
    private AtRule inKeyframes;

    public Amp4AdsVisitor(@Nonnull List<ErrorToken> errors) {
        this.errors = errors;
        this.inKeyframes = null;
    }

    @Override
    public void visitDeclaration(@Nonnull Declaration declaration) throws CssValidationException {
        if (declaration.getName().equals("position")) {
            return;
        }
        String ident = Amp4AdsVisitor.firstIdent((List<Token>)declaration.getValue());
        if (ident.equals("fixed") || ident.equals("sticky")) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            params.add("position");
            params.add(ident);
            this.errors.add(Amp4AdsVisitor.createParseErrorTokenAt(declaration, ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_PROPERTY_VALUE, params));
        }
    }

    @Override
    public void visitQualifiedRule(@Nonnull QualifiedRule qualifiedRule) throws CssValidationException {
        for (Declaration decl : qualifiedRule.getDeclarations()) {
            String transitionedProperty;
            String transitionedPropertyStripped;
            String name = CssSpecUtils.stripVendorPrefix(decl.getName());
            if (name.equals("transition") && !(transitionedPropertyStripped = CssSpecUtils.stripVendorPrefix(transitionedProperty = Amp4AdsVisitor.firstIdent((List<Token>)decl.getValue()))).equals("opacity") && !transitionedPropertyStripped.equals("transform")) {
                ArrayList<String> params = new ArrayList<String>();
                params.add("style");
                params.add("transition");
                params.add(transitionedProperty);
                params.add("['opacity', 'transform']");
                this.errors.add(Amp4AdsVisitor.createParseErrorTokenAt(decl, ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_PROPERTY_VALUE_WITH_HINT, params));
            }
            if (this.inKeyframes == null || name.equals("transform") || name.equals("opacity") || name.equals("animation-timing-function")) continue;
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            params.add(decl.getName());
            params.add(this.inKeyframes.getName());
            params.add("['animation-timing-function', 'opacity', 'transform']");
            this.errors.add(Amp4AdsVisitor.createParseErrorTokenAt(decl, ValidatorProtos.ValidationError.Code.CSS_SYNTAX_PROPERTY_DISALLOWED_WITHIN_AT_RULE, params));
        }
    }

    @Override
    public void visitAtRule(@Nonnull AtRule atRule) {
        this.inKeyframes = CssSpecUtils.stripVendorPrefix(atRule.getName()).equals("keyframes") ? atRule : null;
    }

    @Override
    public void leaveAtRule(@Nonnull AtRule atRule) {
        this.inKeyframes = null;
    }

    private static String firstIdent(@Nonnull List<Token> tokens) {
        if (tokens.size() == 0) {
            return "";
        }
        if (CssTokenUtil.getTokenType(tokens.get(0)) == TokenType.IDENT) {
            return (String)tokens.get(0).getValue();
        }
        if (tokens.size() >= 2 && CssTokenUtil.getTokenType(tokens.get(0)) == TokenType.WHITESPACE && CssTokenUtil.getTokenType(tokens.get(1)) == TokenType.IDENT) {
            return (String)tokens.get(1).getValue();
        }
        return "";
    }

    public static ErrorToken createParseErrorTokenAt(@Nonnull Token positionToken, @Nonnull ValidatorProtos.ValidationError.Code code, @Nonnull List<String> params) throws CssValidationException {
        ErrorToken token = new ErrorToken(code, params);
        CssTokenUtil.copyPosTo(positionToken, token);
        return token;
    }
}

