/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.css;

import dev.amp.validator.ParsedUrlSpec;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.utils.CssSpecUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ParsedDocCssSpec {
    private final ValidatorProtos.DocCssSpec spec;
    private final Map<String, ValidatorProtos.CssDeclaration> cssDeclarationByName;
    private final HashMap<String, ValidatorProtos.CssDeclaration> cssDeclarationSvgByName;
    private ParsedUrlSpec parsedImageUrlSpec;
    private ParsedUrlSpec parsedFontUrlSpec;

    public ParsedDocCssSpec(ValidatorProtos.DocCssSpec spec, List<ValidatorProtos.DeclarationList> declLists) {
        this.spec = spec;
        this.cssDeclarationByName = new HashMap<String, ValidatorProtos.CssDeclaration>();
        this.cssDeclarationSvgByName = new HashMap();
        for (ValidatorProtos.CssDeclaration declaration : spec.getDeclarationList()) {
            if (!declaration.hasName()) continue;
            this.cssDeclarationByName.put(declaration.getName(), declaration);
            this.cssDeclarationSvgByName.put(declaration.getName(), declaration);
        }
        for (ValidatorProtos.CssDeclaration declaration : spec.getDeclarationSvgList()) {
            if (!declaration.hasName()) continue;
            this.cssDeclarationSvgByName.put(declaration.getName(), declaration);
        }
        for (String declListName : spec.getDeclarationListList()) {
            for (ValidatorProtos.DeclarationList declList : declLists) {
                if (!declList.hasName() || !declList.getName().equals(declListName)) continue;
                for (ValidatorProtos.CssDeclaration declaration : declList.getDeclarationList()) {
                    if (!declaration.hasName()) continue;
                    this.cssDeclarationByName.put(declaration.getName(), declaration);
                    this.cssDeclarationSvgByName.put(declaration.getName(), declaration);
                }
            }
        }
        for (String declListName : spec.getDeclarationListSvgList()) {
            for (ValidatorProtos.DeclarationList declList : declLists) {
                if (!declList.hasName() || !declList.getName().equals(declListName)) continue;
                for (ValidatorProtos.CssDeclaration declaration : declList.getDeclarationList()) {
                    if (!declaration.hasName()) continue;
                    this.cssDeclarationSvgByName.put(declaration.getName(), declaration);
                }
            }
        }
        this.parsedImageUrlSpec = new ParsedUrlSpec(spec.getImageUrlSpec());
        this.parsedFontUrlSpec = new ParsedUrlSpec(spec.getFontUrlSpec());
    }

    public ValidatorProtos.CssDeclaration getCssDeclarationSvgByName(@Nonnull String candidate) {
        ValidatorProtos.CssDeclaration cssDeclaration;
        String key = candidate.toLowerCase();
        if (this.getSpec().getExpandVendorPrefixes()) {
            key = CssSpecUtils.stripVendorPrefix(key);
        }
        if ((cssDeclaration = this.cssDeclarationSvgByName.get(key)) != null) {
            return cssDeclaration;
        }
        return null;
    }

    public ValidatorProtos.CssDeclaration getCssDeclarationByName(@Nonnull String candidate) {
        ValidatorProtos.CssDeclaration cssDeclaration;
        String key = candidate.toLowerCase();
        if (this.getSpec().getExpandVendorPrefixes()) {
            key = CssSpecUtils.stripVendorPrefix(key);
        }
        if ((cssDeclaration = this.cssDeclarationByName.get(key)) != null) {
            return cssDeclaration;
        }
        return null;
    }

    public Map<String, ValidatorProtos.CssDeclaration> getCssDeclarationByName() {
        return this.cssDeclarationByName;
    }

    public ValidatorProtos.DocCssSpec getSpec() {
        return this.spec;
    }

    public List<String> enabledBy() {
        return this.spec.getEnabledByList();
    }

    public List<String> disabledBy() {
        return this.spec.getDisabledByList();
    }

    public ParsedUrlSpec getFontUrlSpec() {
        return this.parsedFontUrlSpec;
    }

    public ParsedUrlSpec getImageUrlSpec() {
        return this.parsedImageUrlSpec;
    }
}

