/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.Context;
import dev.amp.validator.UrlErrorAdapter;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.utils.TagSpecUtils;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class UrlErrorInStylesheetAdapter
implements UrlErrorAdapter {
    private final int lineNumber;
    private final int columnNumber;

    public UrlErrorInStylesheetAdapter(int lineNumber, int columnNumber) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    @Override
    public void missingUrl(@Nonnull Context context, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(TagSpecUtils.getTagSpecName(tagSpec));
        context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_MISSING_URL, this.lineNumber, this.columnNumber, params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
    }

    @Override
    public void invalidUrl(@Nonnull Context context, @Nonnull String url, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(TagSpecUtils.getTagSpecName(tagSpec));
        params.add(url);
        context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_INVALID_URL, this.lineNumber, this.columnNumber, params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
    }

    @Override
    public void invalidUrlProtocol(@Nonnull Context context, @Nonnull String protocol, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(TagSpecUtils.getTagSpecName(tagSpec));
        params.add(protocol);
        context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_INVALID_URL_PROTOCOL, this.lineNumber, this.columnNumber, params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
    }

    @Override
    public void disallowedRelativeUrl(@Nonnull Context context, @Nonnull String url, @Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        ArrayList<String> params = new ArrayList<String>();
        params.add(TagSpecUtils.getTagSpecName(tagSpec));
        params.add(url);
        context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_RELATIVE_URL, this.lineNumber, this.columnNumber, params, TagSpecUtils.getTagSpecUrl(tagSpec), result);
    }
}

