/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.css;

import com.steadystate.css.parser.Token;
import dev.amp.validator.css.CssTokenUtil;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.Rule;
import dev.amp.validator.css.TokenType;
import dev.amp.validator.visitor.RuleVisitor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class Declaration
extends Rule {
    private boolean important;
    @Nonnull
    private final String name;
    @Nonnull
    private final List<Token> value;

    public Declaration(@Nonnull String name) {
        this.name = name;
        this.value = new ArrayList<Token>();
        this.important = false;
    }

    @Override
    public void accept(@Nonnull RuleVisitor visitor) throws CssValidationException {
        visitor.visitDeclaration(this);
        visitor.leaveDeclaration(this);
    }

    @Override
    public TokenType getTokenType() {
        return TokenType.DECLARATION;
    }

    public String firstIdent() {
        if (this.value.size() == 0) {
            return "";
        }
        if (CssTokenUtil.getTokenType(this.value.get(0)) == TokenType.IDENT) {
            return this.value.get(0).toString();
        }
        if (CssTokenUtil.getTokenType(this.value.get(0)) == TokenType.NUMBER) {
            return this.value.get((int)0).image;
        }
        if (this.value.size() >= 2 && CssTokenUtil.getTokenType(this.value.get(0)) == TokenType.WHITESPACE) {
            if (CssTokenUtil.getTokenType(this.value.get(1)) == TokenType.IDENT) {
                return this.value.get(1).toString();
            }
            if (CssTokenUtil.getTokenType(this.value.get(1)) == TokenType.NUMBER) {
                return this.value.get((int)1).image;
            }
        }
        return "";
    }

    @Override
    public List<Token> getValue() {
        return this.value;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean getImportant() {
        return this.important;
    }

    public void setImportant(boolean important) {
        this.important = important;
    }
}

