/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.ScriptTag;
import dev.amp.validator.utils.ExtensionsUtils;
import java.util.HashMap;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.xml.sax.Attributes;

public class ParsedHtmlTag {
    @Nonnull
    private String tagName;
    @Nonnull
    private final Attributes attrs;
    @Nonnull
    private final ScriptTag scriptTag;
    private HashMap<String, String> attrsByKey;
    private static final Pattern MODULE_LTS_SCRIPT_SRC_REGEX = Pattern.compile("^https:\\/\\/cdn\\.ampproject\\.org\\/lts\\/(v0|v0/amp-[a-z0-9-]*-[a-z0-9.]*)\\.mjs$", 2);
    private static final Pattern NOMODULE_LTS_SCRIPT_SRC_REGEX = Pattern.compile("^https:\\/\\/cdn\\.ampproject\\.org\\/lts\\/(v0|v0/amp-[a-z0-9-]*-[a-z0-9.]*)\\.js$", 2);
    private static final Pattern MODULE_SCRIPT_SRC_REGEX = Pattern.compile("^https://cdn\\.ampproject\\.org\\/(v0|v0/amp-[a-z0-9-]*-[a-z0-9.]*)\\.mjs$", 2);
    private static final Pattern NOMODULE_SCRIPT_SRC_REGEX = Pattern.compile("^https:\\/\\/cdn\\.ampproject\\.org\\/(v0|v0/amp-[a-z0-9-]*-[a-z0-9.]*)\\.js$", 2);
    private static final Pattern LTS_SCRIPT_SRC_REGEX = Pattern.compile("/lts\\/(v0|v0/amp-[a-z0-9-]*-[a-z0-9.]*)\\.js$", 2);

    public ParsedHtmlTag(@Nonnull String tagName, @Nonnull Attributes attributes) {
        this.tagName = tagName.toUpperCase();
        this.attrs = attributes;
        this.scriptTag = new ScriptTag(this.tagName, this.attrs);
        this.attrsByKey = null;
    }

    public String lowerName() {
        return this.tagName.toLowerCase();
    }

    public Attributes attrs() {
        return this.attrs;
    }

    public HashMap<String, String> attrsByKey() {
        if (this.attrsByKey == null) {
            this.attrsByKey = new HashMap();
            for (int i = 0; i < this.attrs.getLength(); ++i) {
                this.attrsByKey.put(this.attrs.getLocalName(i), this.attrs.getValue(i));
            }
        }
        return this.attrsByKey;
    }

    public String hasDuplicateAttrs() {
        String lastAttrName = "";
        String lastAttrValue = "";
        for (int i = 0; i < this.attrs.getLength(); ++i) {
            if (lastAttrName.equals(this.attrs.getLocalName(i)) && !lastAttrValue.equals(this.attrs.getValue(i))) {
                return this.attrs.getLocalName(i);
            }
            lastAttrName = this.attrs.getLocalName(i);
            lastAttrValue = this.attrs.getValue(i);
        }
        return null;
    }

    public String getValue(@Nonnull String attrName, int index) {
        String val = this.attrs.getValue(index);
        if (val != null && val.equals(attrName.toLowerCase())) {
            return "";
        }
        return val;
    }

    private String extensionScriptNameAttribute() {
        if ("SCRIPT".equals(this.upperName())) {
            for (String attribute : ExtensionsUtils.EXTENSION_SCRIPT_NAMES) {
                if (!this.attrsByKey().containsKey(attribute)) continue;
                return attribute;
            }
        }
        return "";
    }

    public boolean isExtensionScript() {
        return !this.extensionScriptNameAttribute().isEmpty();
    }

    public boolean isAmpCacheDomain(@Nonnull String src) {
        return src.startsWith("https://cdn.ampproject.org/");
    }

    private String getAttrValueOrNull(@Nonnull String name) {
        return this.attrsByKey().get(name);
    }

    public boolean isAmpDomain() {
        return this.scriptTag.isAmpDomain();
    }

    public boolean isAmpRuntimeScript() {
        return this.scriptTag.isRuntime();
    }

    private boolean isAsyncScriptTag(String src) {
        return "SCRIPT".equals(this.upperName()) && this.attrsByKey().containsKey("async") && src != null;
    }

    public void cleanup() {
        this.tagName = null;
        this.attrsByKey = null;
    }

    public String upperName() {
        return this.tagName.toUpperCase();
    }

    public boolean isEmpty() {
        return this.tagName.length() == 0;
    }

    public String getExtensionName() {
        return this.scriptTag.getExtensionName();
    }

    public String getExtensionVersion() {
        return this.scriptTag.getExtensionVersion();
    }

    public boolean hasValidAmpScriptPath() {
        return this.scriptTag.hasValidPath();
    }

    public String getAmpScriptPath() {
        return this.scriptTag.getPath();
    }

    public ExtensionsUtils.ScriptReleaseVersion getScriptReleaseVersion() {
        return this.scriptTag.getReleaseVersion();
    }
}

