/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import dev.amp.validator.ExtensionsContext;
import dev.amp.validator.ParsedAttrSpec;
import dev.amp.validator.ParsedDocSpec;
import dev.amp.validator.ParsedHtmlTag;
import dev.amp.validator.ParsedTagSpec;
import dev.amp.validator.ParsedValidatorRules;
import dev.amp.validator.RecordValidated;
import dev.amp.validator.TagStack;
import dev.amp.validator.ValidateTagResult;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.ParsedDocCssSpec;
import dev.amp.validator.exception.TagValidationException;
import dev.amp.validator.utils.AttributeSpecUtils;
import dev.amp.validator.utils.ExtensionsUtils;
import dev.amp.validator.utils.TagSpecUtils;
import dev.amp.validator.utils.ValidationErrorUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.xml.sax.Locator;

public class Context {
    private ParsedValidatorRules rules;
    private List<String> mandatoryAlternativesSatisfied;
    private Locator docLocator = null;
    private TagStack tagStack = null;
    private Map<Integer, Boolean> tagspecsValidated;
    private int styleTagByteSize = 0;
    private int inlineStyleByteSize = 0;
    private List<String> typeIdentifiers;
    private Set<String> valueSetsProvided;
    private Map<String, List<ValidatorProtos.ValidationError>> valueSetsRequired;
    private Map<String, Boolean> conditionsSatisfied;
    private ValidatorProtos.TagSpec firstUrlSeenTag = null;
    private ExtensionsContext extensions;
    private ExtensionsUtils.ScriptReleaseVersion scriptReleaseVersion;
    private int docByteSize;

    public Context(@Nonnull ParsedValidatorRules parsedValidatorRules, int docByteSize) {
        this.rules = parsedValidatorRules;
        this.mandatoryAlternativesSatisfied = new ArrayList<String>();
        this.docLocator = null;
        this.tagStack = new TagStack();
        this.tagspecsValidated = new HashMap<Integer, Boolean>();
        this.tagspecsValidated.put(0, true);
        this.styleTagByteSize = 0;
        this.inlineStyleByteSize = 0;
        this.typeIdentifiers = new ArrayList<String>();
        this.valueSetsProvided = new HashSet<String>();
        this.valueSetsRequired = new HashMap<String, List<ValidatorProtos.ValidationError>>();
        this.conditionsSatisfied = new HashMap<String, Boolean>();
        this.firstUrlSeenTag = null;
        this.extensions = new ExtensionsContext();
        this.scriptReleaseVersion = ExtensionsUtils.ScriptReleaseVersion.UNKNOWN;
        this.docByteSize = docByteSize;
    }

    public void updateFromTagResults(@Nonnull ParsedHtmlTag encounteredTag, @Nonnull ValidateTagResult referencePointResult, @Nonnull ValidateTagResult tagResult) throws TagValidationException {
        this.tagStack.updateFromTagResults(encounteredTag, referencePointResult, tagResult, this.getRules(), this.getLineCol());
        this.recordAttrRequiresExtension(encounteredTag, referencePointResult);
        this.recordAttrRequiresExtension(encounteredTag, tagResult);
        this.updateFromTagResult(referencePointResult);
        this.updateFromTagResult(tagResult);
        this.recordScriptReleaseVersionFromTagResult(encounteredTag);
        this.addInlineStyleByteSize(tagResult.getInlineStyleCssBytes());
    }

    private void updateFromTagResult(@Nonnull ValidateTagResult result) {
        if (result.getBestMatchTagSpec() == null) {
            return;
        }
        ParsedTagSpec parsedTagSpec = result.getBestMatchTagSpec();
        boolean isPassing = result.getValidationResult().getStatus() == ValidatorProtos.ValidationResult.Status.PASS;
        this.extensions.updateFromTagResult(result);
        if (this.tagStack.hasAncestor("HEAD")) {
            this.extensions.recordFutureErrorsIfMissing(parsedTagSpec, this.getLineCol());
        }
        this.satisfyConditionsFromTagSpec(parsedTagSpec);
        this.satisfyMandatoryAlternativesFromTagSpec(parsedTagSpec);
        this.recordValidatedFromTagSpec(isPassing, parsedTagSpec);
        ValidatorProtos.ValidationResult.Builder validationResult = result.getValidationResult();
        for (ValidatorProtos.ValueSetProvision provision : validationResult.getValueSetProvisionsList()) {
            this.valueSetsProvided.add(this.keyFromValueSetProvision(provision));
        }
        for (ValidatorProtos.ValueSetRequirement requirement : validationResult.getValueSetRequirementsList()) {
            if (!requirement.hasProvision()) continue;
            String key = this.keyFromValueSetProvision(requirement.getProvision());
            List<ValidatorProtos.ValidationError> errors = this.valueSetsRequired.get(key);
            if (errors == null) {
                errors = new ArrayList<ValidatorProtos.ValidationError>();
                this.valueSetsRequired.put(key, errors);
            }
            errors.add(requirement.getErrorIfUnsatisfied());
        }
        if (isPassing) {
            this.markUrlSeenFromMatchingTagSpec(parsedTagSpec);
        }
    }

    private void recordScriptReleaseVersionFromTagResult(@Nonnull ParsedHtmlTag parsedTag) {
        if (this.getScriptReleaseVersion() == ExtensionsUtils.ScriptReleaseVersion.UNKNOWN && (parsedTag.isExtensionScript() || parsedTag.isAmpRuntimeScript())) {
            this.scriptReleaseVersion = parsedTag.getScriptReleaseVersion();
        }
    }

    public void markUrlSeenFromMatchingTagSpec(@Nonnull ParsedTagSpec parsedTagSpec) {
        if (!this.hasSeenUrl() && parsedTagSpec.containsUrl()) {
            this.firstUrlSeenTag = parsedTagSpec.getSpec();
        }
    }

    public Set<String> valueSetsProvided() {
        return this.valueSetsProvided;
    }

    public Map<String, List<ValidatorProtos.ValidationError>> valueSetsRequired() {
        return this.valueSetsRequired;
    }

    private void recordValidatedFromTagSpec(boolean isPassing, @Nonnull ParsedTagSpec parsedTagSpec) {
        RecordValidated recordValidated = parsedTagSpec.shouldRecordTagspecValidated();
        if (recordValidated == RecordValidated.ALWAYS) {
            this.tagspecsValidated.put(parsedTagSpec.id(), true);
        } else if (isPassing && recordValidated == RecordValidated.IF_PASSING) {
            this.tagspecsValidated.put(parsedTagSpec.id(), true);
        }
    }

    private void satisfyConditionsFromTagSpec(@Nonnull ParsedTagSpec parsedTagSpec) {
        for (String condition : parsedTagSpec.getSpec().getSatisfiesList()) {
            this.conditionsSatisfied.put(condition, true);
        }
    }

    public void satisfyMandatoryAlternativesFromTagSpec(@Nonnull ParsedTagSpec parsedTagSpec) {
        ValidatorProtos.TagSpec tagSpec = parsedTagSpec.getSpec();
        if (tagSpec.hasMandatoryAlternatives()) {
            this.mandatoryAlternativesSatisfied.add(tagSpec.getMandatoryAlternatives());
        }
    }

    private void recordAttrRequiresExtension(@Nonnull ParsedHtmlTag encounteredTag, @Nonnull ValidateTagResult tagResult) {
        if (tagResult.getBestMatchTagSpec() == null) {
            return;
        }
        ParsedTagSpec parsedTagSpec = tagResult.getBestMatchTagSpec();
        if (!parsedTagSpec.attrsCanSatisfyExtension()) {
            return;
        }
        Map<String, ValidatorProtos.AttrSpec> attrsByName = parsedTagSpec.getAttrsByName();
        ExtensionsContext extensionsCtx = this.extensions;
        for (int i = 0; i < encounteredTag.attrs().getLength(); ++i) {
            ParsedAttrSpec parsedAttrSpec;
            ValidatorProtos.AttrSpec attrSpec;
            String attrValue;
            String attrName = encounteredTag.attrs().getLocalName(i);
            if (attrName.equals(attrValue = encounteredTag.attrs().getValue(i))) {
                attrValue = "";
            }
            if (!attrsByName.containsKey(attrName) || (attrSpec = attrsByName.get(attrName)) == null || (parsedAttrSpec = this.rules.getParsedAttrSpecs().getParsedAttrSpec(parsedTagSpec.getSpec().getTagName(), attrName, attrValue, attrSpec)) == null || parsedAttrSpec.getSpec().getRequiresExtensionCount() <= 0) continue;
            extensionsCtx.recordUsedExtensions((List<String>)parsedAttrSpec.getSpec().getRequiresExtensionList());
        }
    }

    public void addBuiltError(@Nonnull ValidatorProtos.ValidationError error, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) {
        if (error.getSeverity() != ValidatorProtos.ValidationError.Severity.WARNING) {
            validationResult.setStatus(ValidatorProtos.ValidationResult.Status.FAIL);
        }
        validationResult.addErrors(error);
    }

    public void addError(@Nonnull ValidatorProtos.ValidationError.Code validationErrorCode, @Nonnull Locator lineCol, List<String> params, String specUrl, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) {
        this.addError(validationErrorCode, lineCol.getLineNumber(), lineCol.getColumnNumber(), params, specUrl, validationResult);
    }

    public void addError(@Nonnull ValidatorProtos.ValidationError.Code validationErrorCode, int line, int column, List<String> params, String specUrl, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) {
        this.addBuiltError(ValidationErrorUtils.populateError(ValidatorProtos.ValidationError.Severity.ERROR, validationErrorCode, line, column, params, specUrl), validationResult);
        validationResult.setStatus(ValidatorProtos.ValidationResult.Status.FAIL);
    }

    public void addWarning(@Nonnull ValidatorProtos.ValidationError.Code validationErrorCode, @Nonnull Locator lineCol, List<String> params, String specUrl, @Nonnull ValidatorProtos.ValidationResult.Builder validationResult) {
        this.addBuiltError(ValidationErrorUtils.populateError(ValidatorProtos.ValidationError.Severity.WARNING, validationErrorCode, lineCol, params, specUrl), validationResult);
    }

    public Locator getLineCol() {
        return this.docLocator;
    }

    public void setLineCol(@Nonnull Locator lineCol) {
        this.docLocator = lineCol;
    }

    public ParsedValidatorRules getRules() {
        return this.rules;
    }

    public TagStack getTagStack() {
        return this.tagStack;
    }

    public void recordTypeIdentifier(@Nonnull String typeIdentifier) {
        this.typeIdentifiers.add(typeIdentifier);
    }

    public List<String> getTypeIdentifiers() {
        return this.typeIdentifiers;
    }

    public boolean isDocSpecValidForTypeIdentifiers(@Nonnull ParsedDocSpec spec) {
        return AttributeSpecUtils.isUsedForTypeIdentifiers(this.getTypeIdentifiers(), spec.enabledBy(), spec.disabledBy());
    }

    public ParsedDocSpec matchingDocSpec() {
        for (ParsedDocSpec spec : this.rules.getDoc()) {
            if (!this.rules.isDocSpecCorrectHtmlFormat(spec.spec()) || !this.isDocSpecValidForTypeIdentifiers(spec)) continue;
            return spec;
        }
        return null;
    }

    public ExtensionsContext getExtensions() {
        return this.extensions;
    }

    public Map<Integer, Boolean> getTagspecsValidated() {
        return this.tagspecsValidated;
    }

    public boolean hasTagspecsValidated(int id) {
        Boolean b = this.tagspecsValidated.get(id);
        if (b == null) {
            return false;
        }
        return b;
    }

    public void addStyleTagByteSize(int byteSize) {
        this.styleTagByteSize += byteSize;
    }

    public void addInlineStyleByteSize(int byteSize) {
        this.inlineStyleByteSize += byteSize;
    }

    public int getInlineStyleByteSize() {
        return this.inlineStyleByteSize;
    }

    public int getStyleTagByteSize() {
        return this.styleTagByteSize;
    }

    public boolean isTransformed() {
        return this.typeIdentifiers.contains("transformed");
    }

    public boolean hasSeenUrl() {
        return this.firstUrlSeenTag != null;
    }

    public boolean satisfiesCondition(@Nonnull String condition) {
        return this.conditionsSatisfied.containsKey(condition);
    }

    public String firstSeenUrlTagName() {
        return TagSpecUtils.getTagSpecName(this.firstUrlSeenTag);
    }

    public List<String> getMandatoryAlternativesSatisfied() {
        return this.mandatoryAlternativesSatisfied;
    }

    public ExtensionsUtils.ScriptReleaseVersion getScriptReleaseVersion() {
        return this.scriptReleaseVersion;
    }

    private String keyFromValueSetProvision(@Nonnull ValidatorProtos.ValueSetProvision provision) {
        return (Serializable)(provision.hasSet() ? provision.getSet() : "") + ">" + (provision.hasValue() ? provision.getValue() : "");
    }

    public ParsedDocCssSpec matchingDocCssSpec() {
        for (ParsedDocCssSpec spec : this.rules.getCss()) {
            if (!this.rules.isDocCssSpecCorrectHtmlFormat(spec.getSpec()) || !this.isDocCssSpecValidForTypeIdentifiers(spec)) continue;
            return spec;
        }
        return null;
    }

    private boolean isDocCssSpecValidForTypeIdentifiers(ParsedDocCssSpec spec) {
        return AttributeSpecUtils.isUsedForTypeIdentifiers(this.getTypeIdentifiers(), spec.enabledBy(), spec.disabledBy());
    }

    public int getDocByteSize() {
        return this.docByteSize;
    }
}

