/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.visitor;

import com.steadystate.css.parser.Token;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.AtRule;
import dev.amp.validator.css.CssTokenUtil;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.ErrorToken;
import dev.amp.validator.css.Stylesheet;
import dev.amp.validator.css.TokenStream;
import dev.amp.validator.css.TokenType;
import dev.amp.validator.utils.CssSpecUtils;
import dev.amp.validator.visitor.RuleVisitor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class MediaQueryVisitor
implements RuleVisitor {
    @Nonnull
    private final List<Token> mediaTypes;
    @Nonnull
    private final List<Token> mediaFeatures;
    @Nonnull
    private final List<ErrorToken> errors;

    public MediaQueryVisitor(@Nonnull List<Token> mediaTypes, @Nonnull List<Token> mediaFeatures, @Nonnull List<ErrorToken> errors) {
        this.mediaTypes = mediaTypes;
        this.mediaFeatures = mediaFeatures;
        this.errors = errors;
    }

    @Override
    public void visitAtRule(@Nonnull AtRule atRule) throws CssValidationException {
        if (!atRule.getName().toLowerCase().equals("media")) {
            return;
        }
        TokenStream tokenStream = new TokenStream(atRule.getPrelude());
        tokenStream.consume();
        if (!this.parseAMediaQueryList(tokenStream)) {
            ArrayList<String> params = new ArrayList<String>();
            params.add("style");
            this.errors.add((ErrorToken)CssTokenUtil.copyPosTo(atRule, new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_MALFORMED_MEDIA_QUERY, params)));
        }
    }

    private void maybeConsumeAWhitespaceToken(@Nonnull TokenStream tokenStream) {
        if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.WHITESPACE) {
            tokenStream.consume();
        }
    }

    private boolean parseAMediaQueryList(@Nonnull TokenStream tokenStream) {
        this.maybeConsumeAWhitespaceToken(tokenStream);
        if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.EOF_TOKEN) {
            if (!this.parseAMediaQuery(tokenStream)) {
                return false;
            }
            while (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.COMMA) {
                tokenStream.consume();
                this.maybeConsumeAWhitespaceToken(tokenStream);
                if (this.parseAMediaQuery(tokenStream)) continue;
                return false;
            }
        }
        return CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.EOF_TOKEN;
    }

    private boolean parseAMediaQuery(@Nonnull TokenStream tokenStream) {
        if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.OPEN_PAREN) {
            if (!this.parseAMediaExpression(tokenStream)) {
                return false;
            }
        } else {
            if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.IDENT && (CssSpecUtils.asciiMatch(tokenStream.current(), "only") || CssSpecUtils.asciiMatch(tokenStream.current(), "not"))) {
                tokenStream.consume();
            }
            this.maybeConsumeAWhitespaceToken(tokenStream);
            if (!this.parseAMediaType(tokenStream)) {
                return false;
            }
            this.maybeConsumeAWhitespaceToken(tokenStream);
        }
        while (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.IDENT && CssSpecUtils.asciiMatch(tokenStream.current(), "and")) {
            tokenStream.consume();
            this.maybeConsumeAWhitespaceToken(tokenStream);
            if (this.parseAMediaExpression(tokenStream)) continue;
            return false;
        }
        return true;
    }

    private boolean parseAMediaExpression(@Nonnull TokenStream tokenStream) {
        if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.OPEN_PAREN) {
            return false;
        }
        tokenStream.consume();
        this.maybeConsumeAWhitespaceToken(tokenStream);
        if (!this.parseAMediaFeature(tokenStream)) {
            return false;
        }
        this.maybeConsumeAWhitespaceToken(tokenStream);
        if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.COLON) {
            tokenStream.consume();
            this.maybeConsumeAWhitespaceToken(tokenStream);
            while (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.EOF_TOKEN && CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.CLOSE_PAREN) {
                tokenStream.consume();
            }
        }
        if (CssTokenUtil.getTokenType(tokenStream.current()) != TokenType.CLOSE_PAREN) {
            return false;
        }
        tokenStream.consume();
        this.maybeConsumeAWhitespaceToken(tokenStream);
        return true;
    }

    private boolean parseAMediaFeature(@Nonnull TokenStream tokenStream) {
        if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.IDENT) {
            this.mediaFeatures.add(tokenStream.current());
            tokenStream.consume();
            return true;
        }
        return false;
    }

    private boolean parseAMediaType(@Nonnull TokenStream tokenStream) {
        if (CssTokenUtil.getTokenType(tokenStream.current()) == TokenType.IDENT) {
            this.mediaTypes.add(tokenStream.current());
            tokenStream.consume();
            return true;
        }
        return false;
    }

    public static void parseMediaQueries(@Nonnull Stylesheet stylesheet, @Nonnull List<Token> mediaTypes, @Nonnull List<Token> mediaFeatures, @Nonnull List<ErrorToken> errors) throws CssValidationException {
        MediaQueryVisitor visitor = new MediaQueryVisitor(mediaTypes, mediaFeatures, errors);
        stylesheet.accept(visitor);
    }
}

