/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.visitor;

import dev.amp.validator.Context;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.Declaration;
import dev.amp.validator.css.ParsedDocCssSpec;
import dev.amp.validator.visitor.RuleVisitor;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class InvalidDeclVisitor
implements RuleVisitor {
    private final ParsedDocCssSpec spec;
    private final String tagDescriptiveName;
    private final Context context;
    private final ValidatorProtos.ValidationResult.Builder result;

    public InvalidDeclVisitor(@Nonnull ParsedDocCssSpec spec, @Nonnull Context context, String tagDescriptiveName, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        this.spec = spec;
        this.context = context;
        this.result = result;
        this.tagDescriptiveName = tagDescriptiveName;
    }

    @Override
    public void visitDeclaration(@Nonnull Declaration declaration) {
        ValidatorProtos.CssDeclaration cssDeclaration = this.spec.getCssDeclarationByName().get(declaration.getName().toLowerCase());
        String firstIdent = declaration.firstIdent();
        if (cssDeclaration == null) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(declaration.getName());
            params.add("style amp-custom");
            this.context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_INVALID_PROPERTY_NOLIST, this.context.getLineCol().getLineNumber() + declaration.getLine(), this.context.getLineCol().getColumnNumber() + declaration.getCol(), params, this.spec.getSpec().getSpecUrl(), this.result);
            return;
        }
        if (cssDeclaration.getValueCaseiList().size() > 0) {
            Pattern valueRegex;
            boolean hasValidValue = false;
            for (String value : cssDeclaration.getValueCaseiList()) {
                if (!firstIdent.toLowerCase().equals(value)) continue;
                hasValidValue = true;
                break;
            }
            if (!hasValidValue) {
                ArrayList<String> params = new ArrayList<String>();
                params.add(this.tagDescriptiveName);
                params.add(declaration.getName());
                params.add(firstIdent);
                this.context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_PROPERTY_VALUE, this.context.getLineCol().getLineNumber() + declaration.getLine(), this.context.getLineCol().getColumnNumber() + declaration.getCol(), params, this.spec.getSpec().getSpecUrl(), this.result);
            } else if (StringUtils.isNotBlank((CharSequence)cssDeclaration.getValueRegexCasei()) && !(valueRegex = this.context.getRules().getFullMatchCaseiRegex(cssDeclaration.getValueRegexCasei())).matcher(firstIdent).matches()) {
                ArrayList<String> params = new ArrayList<String>();
                params.add(this.tagDescriptiveName);
                params.add(declaration.getName());
                params.add(firstIdent);
                this.context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_DISALLOWED_PROPERTY_VALUE, this.context.getLineCol().getLineNumber() + declaration.getLine(), this.context.getLineCol().getColumnNumber() + declaration.getCol(), params, this.spec.getSpec().getSpecUrl(), this.result);
            }
        }
    }
}

