/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.utils;

import dev.amp.validator.ValidatorProtos;
import java.io.Serializable;
import javax.annotation.Nonnull;

public final class DispatchKeyUtils {
    private DispatchKeyUtils() {
    }

    public static String makeDispatchKey(@Nonnull ValidatorProtos.AttrSpec.DispatchKeyType dispatchKeyType, @Nonnull String attrName, @Nonnull String attrValue, @Nonnull String mandatoryParent) {
        switch (dispatchKeyType) {
            case NAME_DISPATCH: {
                return attrName;
            }
            case NAME_VALUE_DISPATCH: {
                return attrName + "\u0000" + attrValue;
            }
            case NAME_VALUE_PARENT_DISPATCH: {
                return attrName + "\u0000" + attrValue + "\u0000" + (mandatoryParent != null ? "true" : "");
            }
        }
        assert (false);
        return "";
    }

    public static String getDispatchKeyForTagSpecOrNone(@Nonnull ValidatorProtos.TagSpec tagSpec) {
        for (ValidatorProtos.AttrSpec attr : tagSpec.getAttrsList()) {
            if (attr.getDispatchKey() == ValidatorProtos.AttrSpec.DispatchKeyType.NONE_DISPATCH) continue;
            boolean mandatoryParent = tagSpec.hasMandatoryParent();
            if (attr.getDispatchKey() == ValidatorProtos.AttrSpec.DispatchKeyType.NAME_DISPATCH) {
                return attr.getName();
            }
            String attrValue = null;
            if (attr.getValueCaseiList() != null && attr.getValueCaseiList().size() > 0) {
                attrValue = attr.getValueCasei(0);
            } else if (attr.getValueList() != null && attr.getValueList().size() > 0) {
                attrValue = attr.getValue(0).toLowerCase();
            }
            if (attrValue == null) {
                return null;
            }
            if (attr.getDispatchKey() == ValidatorProtos.AttrSpec.DispatchKeyType.NAME_VALUE_DISPATCH) {
                return attr.getName() + "\u0000" + attrValue;
            }
            if (attr.getDispatchKey() != ValidatorProtos.AttrSpec.DispatchKeyType.NAME_VALUE_PARENT_DISPATCH) continue;
            return attr.getName() + "\u0000" + attrValue + "\u0000" + (Serializable)(mandatoryParent ? Boolean.valueOf(mandatoryParent) : "");
        }
        return null;
    }
}

