/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator;

import com.google.protobuf.ProtocolStringList;
import dev.amp.validator.Context;
import dev.amp.validator.ParsedHtmlTag;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.exception.TagValidationException;
import dev.amp.validator.utils.TagSpecUtils;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class ChildTagMatcher {
    @Nonnull
    private ValidatorProtos.TagSpec parentSpec;

    public ChildTagMatcher(@Nonnull ValidatorProtos.TagSpec parentSpec) throws TagValidationException {
        this.parentSpec = parentSpec;
        if (!parentSpec.hasChildTags()) {
            throw new TagValidationException("The parent's child tag should be null");
        }
    }

    public void matchChildTagName(@Nonnull ParsedHtmlTag encounteredTag, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder result) throws TagValidationException {
        ArrayList<String> params;
        String allowedNames;
        ProtocolStringList names;
        ValidatorProtos.ChildTagSpec childTags = this.parentSpec.getChildTags();
        if (childTags.getChildTagNameOneofList().size() > 0 && (names = childTags.getChildTagNameOneofList()).indexOf(encounteredTag.upperName()) == -1) {
            allowedNames = "['" + StringUtils.join((Iterable)names, (String)", ") + "']";
            params = new ArrayList<String>();
            params.add(encounteredTag.lowerName());
            params.add(TagSpecUtils.getTagSpecName(this.parentSpec));
            params.add(allowedNames.toLowerCase());
            context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_CHILD_TAG_NAME, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(this.parentSpec), result);
        }
        if (childTags.getFirstChildTagNameOneofList().size() > 0 && context.getTagStack().parentChildCount() == 0 && (names = childTags.getFirstChildTagNameOneofList()).indexOf(encounteredTag.upperName()) == -1) {
            allowedNames = "['" + StringUtils.join((Iterable)names, (String)", ") + "']";
            params = new ArrayList();
            params.add(encounteredTag.lowerName());
            params.add(TagSpecUtils.getTagSpecName(this.parentSpec));
            params.add(allowedNames.toLowerCase());
            context.addError(ValidatorProtos.ValidationError.Code.DISALLOWED_FIRST_CHILD_TAG_NAME, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(this.parentSpec), result);
        }
    }

    public void exitTag(@Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder result) throws TagValidationException {
        int expectedNumChildTags = this.parentSpec.getChildTags().getMandatoryNumChildTags();
        if (expectedNumChildTags != -1 && expectedNumChildTags != context.getTagStack().parentChildCount()) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(TagSpecUtils.getTagSpecName(this.parentSpec));
            params.add(String.valueOf(expectedNumChildTags));
            params.add(String.valueOf(context.getTagStack().parentChildCount()));
            context.addError(ValidatorProtos.ValidationError.Code.INCORRECT_NUM_CHILD_TAGS, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(this.parentSpec), result);
            return;
        }
        int expectedMinNumChildTags = this.parentSpec.getChildTags().getMandatoryMinNumChildTags();
        if (expectedMinNumChildTags != -1 && context.getTagStack().parentChildCount() < expectedMinNumChildTags) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(TagSpecUtils.getTagSpecName(this.parentSpec));
            params.add(String.valueOf(expectedMinNumChildTags));
            params.add(String.valueOf(context.getTagStack().parentChildCount()));
            context.addError(ValidatorProtos.ValidationError.Code.INCORRECT_MIN_NUM_CHILD_TAGS, context.getLineCol(), params, TagSpecUtils.getTagSpecUrl(this.parentSpec), result);
            return;
        }
    }
}

