/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.visitor;

import com.steadystate.css.parser.Token;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.AtRule;
import dev.amp.validator.css.CssTokenUtil;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.Declaration;
import dev.amp.validator.css.ErrorToken;
import dev.amp.validator.css.ParsedCssUrl;
import dev.amp.validator.css.QualifiedRule;
import dev.amp.validator.css.TokenType;
import dev.amp.validator.utils.CssSpecUtils;
import dev.amp.validator.visitor.RuleVisitor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class UrlFunctionVisitor
implements RuleVisitor {
    @Nonnull
    private String atRuleScope;
    @Nonnull
    private final List<ErrorToken> errors;
    @Nonnull
    private final List<ParsedCssUrl> parsedUrls;

    public UrlFunctionVisitor(@Nonnull List<ParsedCssUrl> parsedUrls, @Nonnull List<ErrorToken> errors) {
        this.parsedUrls = parsedUrls;
        this.errors = errors;
        this.atRuleScope = "";
    }

    @Override
    public void visitAtRule(@Nonnull AtRule atRule) {
        this.atRuleScope = atRule.getName();
    }

    @Override
    public void leaveAtRule(@Nonnull AtRule atRule) {
        this.atRuleScope = "";
    }

    @Override
    public void visitQualifiedRule(@Nonnull QualifiedRule qualifiedRule) {
        this.atRuleScope = "";
    }

    @Override
    public void visitDeclaration(@Nonnull Declaration declaration) throws CssValidationException {
        if (declaration.getValue().size() <= 0) {
            throw new CssValidationException("Invalid declaration size");
        }
        if (CssTokenUtil.getTokenType((Token)declaration.getValue().get(declaration.getValue().size() - 1)) != TokenType.EOF_TOKEN) {
            throw new CssValidationException("Last Token is not EOF");
        }
        int ii = 0;
        while (ii < declaration.getValue().size() - 1) {
            ParsedCssUrl parsedUrl;
            Token token = (Token)declaration.getValue().get(ii);
            if (CssTokenUtil.getTokenType(token) == TokenType.URL) {
                parsedUrl = new ParsedCssUrl();
                CssSpecUtils.parseUrlToken((List<Token>)declaration.getValue(), ii, parsedUrl);
                parsedUrl.setAtRuleScope(this.atRuleScope);
                this.parsedUrls.add(parsedUrl);
                ++ii;
                continue;
            }
            if (CssTokenUtil.getTokenType(token) == TokenType.FUNCTION_TOKEN && token.toString().equals("url(")) {
                parsedUrl = new ParsedCssUrl();
                ii = CssSpecUtils.parseUrlFunction((List<Token>)declaration.getValue(), ii, parsedUrl);
                if (ii == -1) {
                    ArrayList<String> params = new ArrayList<String>();
                    params.add("style");
                    this.errors.add((ErrorToken)CssTokenUtil.copyPosTo(token, new ErrorToken(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_BAD_URL, params)));
                    return;
                }
                parsedUrl.setAtRuleScope(this.atRuleScope);
                this.parsedUrls.add(parsedUrl);
                continue;
            }
            ++ii;
        }
    }
}

