/*
 * Decompiled with CFR 0.152.
 */
package dev.amp.validator.visitor;

import dev.amp.validator.Context;
import dev.amp.validator.ValidatorProtos;
import dev.amp.validator.css.AtRule;
import dev.amp.validator.css.CssValidationException;
import dev.amp.validator.css.Declaration;
import dev.amp.validator.utils.CssSpecUtils;
import dev.amp.validator.utils.TagSpecUtils;
import dev.amp.validator.visitor.RuleVisitor;
import java.util.ArrayList;
import javax.annotation.Nonnull;

public class InvalidRuleVisitor
implements RuleVisitor {
    private final ValidatorProtos.TagSpec tagSpec;
    private final ValidatorProtos.CssSpec cssSpec;
    private final Context context;
    private final ValidatorProtos.ValidationResult.Builder result;

    public InvalidRuleVisitor(@Nonnull ValidatorProtos.TagSpec tagSpec, @Nonnull ValidatorProtos.CssSpec cssSpec, @Nonnull Context context, @Nonnull ValidatorProtos.ValidationResult.Builder result) {
        this.tagSpec = tagSpec;
        this.cssSpec = cssSpec;
        this.context = context;
        this.result = result;
    }

    @Override
    public void visitAtRule(@Nonnull AtRule atRule) throws CssValidationException {
        if (!this.isAtRuleValid(this.cssSpec, atRule.getName())) {
            ArrayList<String> params = new ArrayList<String>();
            params.add(TagSpecUtils.getTagSpecName(this.tagSpec));
            params.add(atRule.getName());
            this.context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_INVALID_AT_RULE, this.context.getLineCol().getLineNumber() + atRule.getLine(), this.context.getLineCol().getColumnNumber() + atRule.getCol(), params, "", this.result);
        }
    }

    public boolean isAtRuleValid(@Nonnull ValidatorProtos.CssSpec cssSpec, @Nonnull String atRuleName) {
        for (ValidatorProtos.AtRuleSpec atRuleSpec : cssSpec.getAtRuleSpecList()) {
            if (!atRuleSpec.getName().equals(CssSpecUtils.stripVendorPrefix(atRuleName))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitDeclaration(@Nonnull Declaration declaration) {
        if (!CssSpecUtils.isDeclarationValid(this.cssSpec, declaration.getName())) {
            String declarationsStr = CssSpecUtils.allowedDeclarationsString(this.cssSpec);
            if (declarationsStr.equals("")) {
                ArrayList<String> params = new ArrayList<String>();
                params.add(TagSpecUtils.getTagSpecName(this.tagSpec));
                params.add(declaration.getName());
                this.context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_INVALID_PROPERTY_NOLIST, this.context.getLineCol().getLineNumber() + declaration.getLine(), this.context.getLineCol().getColumnNumber() + declaration.getCol(), params, "", this.result);
            } else {
                ArrayList<String> params = new ArrayList<String>();
                params.add(TagSpecUtils.getTagSpecName(this.tagSpec));
                params.add(declaration.getName());
                params.add(declaration.getName());
                CssSpecUtils.allowedDeclarationsString(this.cssSpec);
                this.context.addError(ValidatorProtos.ValidationError.Code.CSS_SYNTAX_INVALID_PROPERTY, this.context.getLineCol().getLineNumber() + declaration.getLine(), this.context.getLineCol().getColumnNumber() + declaration.getCol(), params, "", this.result);
            }
        }
    }
}

